/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.PersistedSearchOptions;
import com.intellij.find.actions.SearchOptionsService;
import com.intellij.find.actions.SearchOptionsServiceKt;
import com.intellij.find.actions.SearchTarget2UsageTarget;
import com.intellij.find.actions.UsageOptionsDialog;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a:\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0000\u001aB\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0002\u001a<\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a&\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002\u001a&\u0010\u0014\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0001\u001a\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"displayString", "", "Lcom/intellij/find/usages/api/SearchTarget;", "getDisplayString", "(Lcom/intellij/find/usages/api/SearchTarget;)Ljava/lang/String;", "canReuseTab", "", "project", "Lcom/intellij/openapi/project/Project;", "findUsages", "", "O", "target", "handler", "Lcom/intellij/find/usages/api/UsageHandler;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "showDialog", "selectedScope", "Lcom/intellij/psi/search/SearchScope;", "getSearchString", "showScopeChooser", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class FindUsagesKt {
    public static final void findUsages(boolean showDialog, @NotNull Project project, @NotNull SearchScope selectedScope, @NotNull SearchTarget target2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedScope, (String)"selectedScope");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        FindUsagesKt.findUsages(showDialog, project, target2, target2.getUsageHandler(), selectedScope);
    }

    private static final <O> void findUsages(boolean showDialog, Project project, SearchTarget target2, UsageHandler<O> handler2, SearchScope selectedScope) {
        PersistedSearchOptions persistedOptions = SearchOptionsServiceKt.getSearchOptions(SearchOptionsService.SearchVariant.FIND_USAGES, target2);
        UsageOptions usageOptions = UsageOptions.createOptions(persistedOptions.getUsages(), selectedScope);
        Intrinsics.checkNotNullExpressionValue((Object)usageOptions, (String)"UsageOptions.createOptio\u2026ns.usages, selectedScope)");
        AllSearchOptions<O> allOptions = new AllSearchOptions<O>(usageOptions, ImplKt.hasTextSearchStrings(target2) ? Boolean.valueOf(persistedOptions.getTextSearch()) : null, handler2.getCustomOptions(UsageHandler.UsageAction.FIND_USAGES));
        FindUsagesKt.findUsages(showDialog, project, target2, handler2, allOptions);
    }

    private static final <O> void findUsages(boolean showDialog, Project project, SearchTarget target2, UsageHandler<O> handler2, AllSearchOptions<O> allOptions) {
        if (showDialog) {
            boolean canReuseTab = FindUsagesKt.canReuseTab(project);
            UsageOptionsDialog<O> dialog2 = new UsageOptionsDialog<O>(project, FindUsagesKt.getDisplayString(target2), handler2, allOptions, FindUsagesKt.showScopeChooser(target2), canReuseTab);
            if (!dialog2.showAndGet()) {
                return;
            }
            AllSearchOptions<O> dialogResult = dialog2.result();
            SearchOptionsServiceKt.setSearchOptions(SearchOptionsService.SearchVariant.FIND_USAGES, target2, dialogResult);
            FindUsagesKt.findUsages(project, target2, handler2, dialogResult);
        } else {
            FindUsagesKt.findUsages(project, target2, handler2, allOptions);
        }
    }

    public static final <O> void findUsages(@NotNull Project project, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler2, @NotNull AllSearchOptions<O> allOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Intrinsics.checkNotNullParameter(allOptions, (String)"allOptions");
        Query<Usage> query2 = ImplKt.buildUsageViewQuery(project, target2, handler2, allOptions);
        Factory factory2 = new Factory(project, query2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Query $query;

            public final UsageSearcher create() {
                return new UsageSearcher(this){
                    final /* synthetic */ findUsages.factory.1 this$0;

                    public final void generate(@NotNull Processor<? super Usage> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        HelperKt.runSearch(this.this$0.$project, this.this$0.$query, it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.$project = project;
                this.$query = query2;
            }
        };
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        boolean bl = false;
        boolean bl2 = false;
        UsageViewPresentation $this$apply = usageViewPresentation;
        boolean bl3 = false;
        $this$apply.setSearchString(FindUsagesKt.getSearchString(handler2, allOptions));
        SearchScope searchScope2 = allOptions.getOptions().getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"allOptions.options.searchScope");
        $this$apply.setScopeText(searchScope2.getDisplayName());
        $this$apply.setTabText(UsageViewBundle.message((String)"search.title.0.in.1", (Object[])new Object[]{$this$apply.getSearchString(), $this$apply.getScopeText()}));
        FindSettings findSettings = FindSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)findSettings, (String)"FindSettings.getInstance()");
        $this$apply.setOpenInNewTab(findSettings.isShowResultsInSeparateView() || !FindUsagesKt.canReuseTab(project));
        UsageViewPresentation usageViewPresentation2 = usageViewPresentation;
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(UsageViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((UsageViewManager)object).searchAndShowUsages((UsageTarget[])new SearchTarget2UsageTarget[]{new SearchTarget2UsageTarget<O>(project, target2, allOptions)}, factory2, false, true, usageViewPresentation2, null);
    }

    private static final boolean canReuseTab(Project project) {
        boolean bl;
        UsageViewContentManager contentManager2 = UsageViewContentManager.getInstance((Project)project);
        Content selectedContent = contentManager2.getSelectedContent(true);
        if (selectedContent == null) {
            UsageViewContentManager usageViewContentManager = contentManager2;
            Intrinsics.checkNotNullExpressionValue((Object)usageViewContentManager, (String)"contentManager");
            bl = usageViewContentManager.getReusableContentsCount() != 0;
        } else {
            bl = !selectedContent.isPinned();
        }
        return bl;
    }

    @NotNull
    public static final String getDisplayString(@NotNull SearchTarget $this$displayString) {
        Intrinsics.checkNotNullParameter((Object)$this$displayString, (String)"$this$displayString");
        return $this$displayString.getPresentation().getPresentableText();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public static final <O> String getSearchString(@NotNull UsageHandler<O> $this$getSearchString, @NotNull AllSearchOptions<O> allOptions) {
        Intrinsics.checkNotNullParameter($this$getSearchString, (String)"$this$getSearchString");
        Intrinsics.checkNotNullParameter(allOptions, (String)"allOptions");
        String string = $this$getSearchString.getSearchString(allOptions.getOptions(), allOptions.getCustomOptions());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchString(allOptio\u2026allOptions.customOptions)");
        return string;
    }

    public static final boolean showScopeChooser(@NotNull SearchTarget $this$showScopeChooser) {
        Intrinsics.checkNotNullParameter((Object)$this$showScopeChooser, (String)"$this$showScopeChooser");
        return !($this$showScopeChooser.getMaximalSearchScope() instanceof LocalSearchScope);
    }
}

