/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesTable
extends JBTable
implements DataProvider {
    final Usage MORE_USAGES_SEPARATOR;
    final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR;
    final Usage USAGES_FILTERED_OUT_SEPARATOR;
    private static final int MARGIN = 2;
    private final ShowUsagesTableCellRenderer myRenderer;

    ShowUsagesTable(@NotNull ShowUsagesTableCellRenderer renderer2) {
        if (renderer2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(0);
        }
        this.MORE_USAGES_SEPARATOR = new UsageAdapter();
        this.USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
        this.USAGES_FILTERED_OUT_SEPARATOR = new UsageAdapter();
        this.myRenderer = renderer2;
        ScrollingUtil.installActions((JTable)((Object)this));
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ShowUsagesTable.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            int[] selected2 = this.getSelectedRows();
            if (selected2.length == 1) {
                return ShowUsagesTable.getPsiElementForHint(this.getValueAt(selected2[0], 0));
            }
        } else if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
            return PopupUtil.getPopupContainerFor((Component)((Object)this));
        }
        return null;
    }

    public int getRowHeight() {
        return super.getRowHeight() + 4;
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer2, int row2, int column2) {
        Component component2;
        if (renderer2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(2);
        }
        if ((component2 = super.prepareRenderer(renderer2, row2, column2)) instanceof JComponent) {
            ((JComponent)component2).setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0));
        }
        Component component3 = component2;
        if (component3 == null) {
            ShowUsagesTable.$$$reportNull$$$0(3);
        }
        return component3;
    }

    @NotNull
    Runnable prepareTable(@NotNull Runnable appendMoreUsageRunnable, @NotNull Runnable showInMaximalScopeRunnable) {
        if (appendMoreUsageRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(4);
        }
        if (showInMaximalScopeRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(5);
        }
        MySpeedSearch speedSearch2 = new MySpeedSearch(this);
        speedSearch2.setComparator(new SpeedSearchComparator(false));
        this.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        AtomicReference filteredOutUsagesSelected = new AtomicReference();
        this.getSelectionModel().addListSelectionListener(e -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            filteredOutUsagesSelected.set(null);
            ArrayList<Usage> usages = null;
            for (int i2 : this.getSelectedRows()) {
                Object value2 = this.getValueAt(i2, 0);
                if (!(value2 instanceof UsageNode)) continue;
                Usage usage = ((UsageNode)value2).getUsage();
                if (usage == this.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == this.MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == this.USAGES_FILTERED_OUT_SEPARATOR) {
                    filteredOutUsagesSelected.set((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)value2)));
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Usage>();
                }
                usages.add((Usage)(usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getUsageInfo().copy() : usage));
            }
            selectedUsages.set(usages);
        });
        Runnable runnable2 = () -> {
            if (moreUsagesSelected.get()) {
                appendMoreUsageRunnable.run();
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                showInMaximalScopeRunnable.run();
                return;
            }
            if (filteredOutUsagesSelected.get() != null) {
                ((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)filteredOutUsagesSelected.get()))).onSelected();
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage : usages) {
                    if (usage instanceof UsageInfo) {
                        UsageInfo usageInfo = (UsageInfo)usage;
                        UsageViewUtil.navigateTo(usageInfo, true);
                        PsiElement element2 = usageInfo.getElement();
                        if (element2 == null) continue;
                        UsageViewStatisticsCollector.logItemChosen((Project)element2.getProject(), (CodeNavigateSource)CodeNavigateSource.ShowUsagesPopup, (Language)element2.getLanguage());
                        continue;
                    }
                    if (!(usage instanceof Navigatable)) continue;
                    ((Navigatable)usage).navigate(true);
                }
            }
        };
        if (runnable2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(6);
        }
        return runnable2;
    }

    public boolean isSeparatorNode(@Nullable Usage node2) {
        return node2 == this.USAGES_OUTSIDE_SCOPE_SEPARATOR || node2 == this.MORE_USAGES_SEPARATOR || node2 == this.USAGES_FILTERED_OUT_SEPARATOR;
    }

    @Nullable
    private static PsiElement getPsiElementForHint(Object selectedValue) {
        PsiElement element2;
        Usage usage;
        if (selectedValue instanceof UsageNode && (usage = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element2 = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
            PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element2);
            return view == null ? element2 : view;
        }
        return null;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data2) {
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(7);
        }
        return data2.isEmpty() || data2.get(0) instanceof ShowUsagesAction.StringNode ? 1 : 4;
    }

    @NotNull
    MyModel setTableModel(@NotNull List<UsageNode> data2) {
        MyModel model2;
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesTable.calcColumnCount(data2);
        MyModel myModel = model2 = this.getModel() instanceof MyModel ? (MyModel)((Object)this.getModel()) : null;
        if (model2 == null || model2.getColumnCount() != columnCount) {
            model2 = new MyModel(data2, columnCount);
            this.setModel((TableModel)((Object)model2));
            for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
                TableColumn column2 = this.getColumnModel().getColumn(i2);
                column2.setPreferredWidth(0);
                column2.setCellRenderer(this.myRenderer);
            }
        }
        MyModel myModel2 = model2;
        if (myModel2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(9);
        }
        return myModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendMoreUsageRunnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showInMaximalScopeRunnable";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareTable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnCount";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTableModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<UsageNode> {
        private MyModel(@NotNull List<UsageNode> data2, int cols) {
            if (data2 == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super(MyModel.cols(cols), data2, 0);
        }

        private static ColumnInfo<UsageNode, UsageNode> @NotNull [] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node2) {
                    return node2;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o);
            ColumnInfo[] columnInfoArray = list2.toArray(ColumnInfo.emptyArray());
            if (columnInfoArray == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return columnInfoArray;
        }

        @Override
        public void addToModel(int idx, UsageNode element2) {
            if (idx < this.getRowCount()) {
                this.insertRow(idx, element2);
            } else {
                this.addRow(element2);
            }
        }

        @Override
        public void removeRangeFromModel(int start2, int end) {
            for (int i2 = end; i2 >= start2; --i2) {
                this.removeRow(i2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull ShowUsagesTable table) {
            if (table == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            super(table);
        }

        @Override
        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        @Override
        protected int getElementCount() {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().size();
        }

        @Override
        protected Object getElementAt(int viewIndex) {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().get(this.getTable().convertRowIndexToModel(viewIndex));
        }

        @Override
        protected String getElementText(@NotNull Object element2) {
            if (element2 == null) {
                MySpeedSearch.$$$reportNull$$$0(1);
            }
            if (!(element2 instanceof UsageNode)) {
                return element2.toString();
            }
            UsageNode node2 = (UsageNode)element2;
            if (node2 instanceof ShowUsagesAction.StringNode) {
                return "";
            }
            Usage usage = node2.getUsage();
            if (usage == this.getTable().MORE_USAGES_SEPARATOR || usage == this.getTable().USAGES_OUTSIDE_SCOPE_SEPARATOR || usage == this.getTable().USAGES_FILTERED_OUT_SEPARATOR) {
                return "";
            }
            GroupNode group2 = (GroupNode)node2.getParent();
            String groupText = group2 == null ? "" : group2.getGroup().getPresentableGroupText();
            return groupText + usage.getPresentation().getPlainText();
        }

        @Override
        protected void selectElement(Object element2, String selectedText) {
            List data2 = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i2 = data2.indexOf(element2);
            if (i2 == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i2);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private ShowUsagesTable getTable() {
            return (ShowUsagesTable)((Object)this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MySpeedSearch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

