/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindBundle;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Predicate<? super Usage> myOriginUsageCheck;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;
    private static final int CURRENT_ASTERISK_COL = 0;
    private static final int FILE_GROUP_COL = 1;
    private static final int LINE_NUMBER_COL = 2;
    private static final int USAGE_TEXT_COL = 3;

    ShowUsagesTableCellRenderer(@NotNull Project project, @NotNull Predicate<? super Usage> originUsageCheck, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope2) {
        if (project == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (originUsageCheck == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(1);
        }
        if (outOfScopeUsages == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(2);
        }
        if (searchScope2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myOriginUsageCheck = originUsageCheck;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope2;
    }

    @Override
    @DirtyUI
    public Component getTableCellRendererComponent(JTable list2, Object value2, boolean isSelected, boolean hasFocus, int row2, @UsageTableColumn int column2) {
        Color rowForeground;
        UsageNode usageNode = (UsageNode)value2;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        Color selectionBg = UIUtil.getListSelectionBackground((boolean)true);
        Color selectionFg = UIUtil.getListSelectionForeground((boolean)true);
        Color rowBackground = isSelected ? selectionBg : (fileBgColor == null ? list2.getBackground() : fileBgColor);
        Color color = rowForeground = isSelected ? selectionFg : list2.getForeground();
        if (usageNode == null || usageNode instanceof ShowUsagesAction.StringNode) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            if (usageNode == null) {
                textChunks.append("", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                textChunks.append(((ShowUsagesAction.StringNode)((Object)value2)).getString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column2, list2);
        }
        if (usage == ((ShowUsagesTable)((Object)list2)).MORE_USAGES_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(FindBundle.message("show.usages.more.usages.label", new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column2, list2);
        }
        if (usage == ((ShowUsagesTable)((Object)list2)).USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            String message2 = UsageViewManagerImpl.outOfScopeMessage((int)this.myOutOfScopeUsages.get(), (SearchScope)this.mySearchScope);
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(message2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column2, list2);
        }
        if (usage == ((ShowUsagesTable)((Object)list2)).USAGES_FILTERED_OUT_SEPARATOR) {
            ShowUsagesAction.FilteredOutUsagesNode filtered2 = (ShowUsagesAction.FilteredOutUsagesNode)usageNode;
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append(filtered2.getString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            JComponent component2 = ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column2, list2);
            component2.setToolTipText(filtered2.getTooltip());
            return component2;
        }
        LayoutManager layout = column2 == 3 ? new BorderLayout() : new FlowLayout(column2 == 2 ? 2 : 0, 0, 0){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                for (Component component2 : container.getComponents()) {
                    Rectangle b = component2.getBounds();
                    Insets insets = container.getInsets();
                    component2.setBounds(b.x, b.y, b.width, container.getSize().height - insets.top - insets.bottom);
                }
            }
        };
        JPanel panel2 = new JPanel(layout);
        panel2.setFont(null);
        boolean isOriginUsage = this.myOriginUsageCheck.test((Usage)usage);
        if (isOriginUsage) {
            rowBackground = ShowUsagesTableCellRenderer.slightlyDifferentColor(rowBackground);
            if (fileBgColor != null) {
                fileBgColor = ShowUsagesTableCellRenderer.slightlyDifferentColor(fileBgColor);
            }
            selectionBg = ShowUsagesTableCellRenderer.slightlyDifferentColor(selectionBg);
        }
        panel2.setBackground(rowBackground);
        panel2.setForeground(rowForeground);
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        UsagePresentation presentation2 = usage.getPresentation();
        TextChunk[] text2 = presentation2.getText();
        switch (column2) {
            case 0: {
                if (isOriginUsage) {
                    panel2.add(new JLabel(isSelected ? AllIcons.General.ModifiedSelected : AllIcons.General.Modified));
                    panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.CURRENT_ASTERISK_COL", (Object[])new Object[0]));
                    break;
                }
                panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.OTHER_ASTERISK_COL", (Object[])new Object[0]));
                break;
            }
            case 1: {
                ShowUsagesTableCellRenderer.appendGroupText(list2, (GroupNode)usageNode.getParent(), panel2, fileBgColor, isSelected);
                break;
            }
            case 2: {
                if (text2.length != 0) {
                    TextChunk chunk = text2[0];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.LINE_NUMBER_COL", (Object[])new Object[]{textChunks.getAccessibleContext().getAccessibleName()}));
                break;
            }
            case 3: {
                Icon icon2 = presentation2.getIcon();
                textChunks.setIcon(icon2 == null ? EmptyIcon.ICON_16 : icon2);
                textChunks.append("").appendTextPadding(JBUIScale.scale((int)21));
                for (int i2 = 1; i2 < text2.length; ++i2) {
                    TextChunk chunk = text2[i2];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
                panel2.add((Component)textChunks);
                panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.USAGE_TEXT_COL", (Object[])new Object[]{textChunks.getAccessibleContext().getAccessibleName()}));
                if (!isOriginUsage) break;
                SimpleColoredComponent origin = new SimpleColoredComponent();
                origin.setIconTextGap(JBUIScale.scale((int)5));
                SimpleTextAttributes attributes2 = text2.length == 0 ? SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, new Color(0x808080), null, null) : ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, text2[0]);
                origin.append("| " + FindBundle.message("show.usages.current.usage.label", new Object[0]), attributes2);
                origin.appendTextPadding(JBUIScale.scale((int)45));
                panel2.add((Component)origin, "East");
                panel2.getAccessibleContext().setAccessibleName(panel2.getAccessibleContext().getAccessibleName() + ", " + origin.getAccessibleContext().getAccessibleName());
                break;
            }
            default: {
                throw new IllegalStateException("unknown column: " + column2);
            }
        }
        return panel2;
    }

    @NotNull
    private static Color slightlyDifferentColor(@NotNull Color back) {
        if (back == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(4);
        }
        Color color = EditorColorsManager.getInstance().isDarkEditor() ? ColorUtil.brighter((Color)back, (int)3) : ColorUtil.hackBrightness((Color)back, (int)1, (float)0.952381f);
        if (color == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(5);
        }
        return color;
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(boolean isSelected, Color fileBgColor, Color selectionBg, Color selectionFg, @NotNull TextChunk chunk) {
        if (chunk == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(6);
        }
        SimpleTextAttributes background = chunk.getSimpleAttributesIgnoreBackground();
        return isSelected ? new SimpleTextAttributes(selectionBg, selectionFg, null, background.getStyle()) : ShowUsagesTableCellRenderer.deriveBgColor(background, fileBgColor);
    }

    @NotNull
    private static JComponent textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color rowBackground, Color rowForeground, final int column2, final @NotNull JTable table) {
        if (chunks == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(7);
        }
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(8);
        }
        SimpleColoredComponent component2 = new SimpleColoredComponent(){

            protected void doPaint(Graphics2D g) {
                int offset = 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i2 = 0; i2 < column2; ++i2) {
                    offset += columnModel.getColumn(i2).getWidth();
                }
                g.translate(-offset, 0);
                this.setSize(this.getWidth() + offset, this.getHeight());
                super.doPaint(g);
                g.translate(offset, 0);
            }

            @NotNull
            public Dimension getPreferredSize() {
                return column2 == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        component2.setBackground(rowBackground);
        component2.setForeground(rowForeground);
        SimpleColoredComponent.ColoredIterator iterator2 = chunks.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            String fragment2 = iterator2.getFragment();
            SimpleTextAttributes attributes2 = iterator2.getTextAttributes();
            attributes2 = attributes2.derive(attributes2.getStyle(), rowForeground, rowBackground, attributes2.getWaveColor());
            component2.append(fragment2, attributes2);
        }
        SimpleColoredComponent simpleColoredComponent = component2;
        if (simpleColoredComponent == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(9);
        }
        return simpleColoredComponent;
    }

    @NotNull
    private static SimpleTextAttributes deriveBgColor(@NotNull SimpleTextAttributes attributes2, @Nullable Color fileBgColor) {
        if (attributes2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(10);
        }
        if (fileBgColor != null) {
            attributes2 = attributes2.derive(-1, null, fileBgColor, null);
        }
        SimpleTextAttributes simpleTextAttributes = attributes2;
        if (simpleTextAttributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(11);
        }
        return simpleTextAttributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground((boolean)true);
        } else {
            Color color;
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = virtualFile2 = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile2 != null && (color = VfsPresentationUtil.getFileBackgroundColor(this.myProject, virtualFile2)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private static void appendGroupText(@NotNull JTable table, GroupNode node2, @NotNull JPanel panel2, Color fileBgColor, boolean isSelected) {
        UsageGroup group2;
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(12);
        }
        if (panel2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(13);
        }
        UsageGroup usageGroup = group2 = node2 == null ? null : node2.getGroup();
        if (group2 == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node2.getParent();
        ShowUsagesTableCellRenderer.appendGroupText(table, parentGroup, panel2, fileBgColor, isSelected);
        SimpleColoredComponent renderer2 = new SimpleColoredComponent();
        renderer2.setIcon(group2.getIcon());
        SimpleTextAttributes attributes2 = ShowUsagesTableCellRenderer.deriveBgColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
        renderer2.append(group2.getPresentableGroupText(), attributes2);
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)renderer2, (boolean)false, (boolean)isSelected);
        panel2.add((Component)renderer2);
        panel2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ShowUsagesTableCellRenderer.accessible.FILE_GROUP_COL", (Object[])new Object[]{renderer2.getAccessibleContext().getAccessibleName()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originUsageCheck";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outOfScopeUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "back";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "slightlyDifferentColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "textComponentSpanningWholeRow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveBgColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "slightlyDifferentColor";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "textComponentSpanningWholeRow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deriveBgColor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendGroupText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static @interface UsageTableColumn {
    }
}

