/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class DetectedFrameworkNode
extends DetectedFrameworkTreeNodeBase {
    private static final Logger LOG = Logger.getInstance(DetectedFrameworkNode.class);
    private final DetectedFrameworkDescription myDescription;
    private final FrameworkDetectionContext myContext;

    DetectedFrameworkNode(DetectedFrameworkDescription description, FrameworkDetectionContext context2) {
        super(description);
        this.myDescription = description;
        this.myContext = context2;
    }

    @Override
    public void renderNode(ColoredTreeCellRenderer renderer2) {
        renderer2.setIcon(this.myDescription.getDetector().getFrameworkType().getIcon());
        Collection files2 = this.myDescription.getRelatedFiles();
        VirtualFile firstFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)files2);
        LOG.assertTrue(firstFile != null);
        if (files2.size() == 1) {
            renderer2.append(firstFile.getName());
            this.appendDirectoryPath(renderer2, firstFile.getParent());
        } else {
            String commonName = firstFile.getName();
            VirtualFile commonParent = firstFile.getParent();
            for (VirtualFile file2 : files2) {
                if (commonName != null && !commonName.equals(file2.getName())) {
                    commonName = null;
                }
                if (commonParent == null || commonParent.equals(file2.getParent())) continue;
                commonParent = null;
            }
            renderer2.append(ProjectBundle.message((String)"comment.0.1.files", (Object[])new Object[]{files2.size(), commonName != null ? commonName : firstFile.getFileType().getDefaultExtension()}));
            if (commonParent != null) {
                this.appendDirectoryPath(renderer2, commonParent);
            }
        }
    }

    @Override
    public String getCheckedDescription() {
        return this.myDescription.getSetupText();
    }

    @Override
    public String getUncheckedDescription() {
        return null;
    }

    @Override
    public void disableDetection(DetectionExcludesConfiguration configuration2) {
        Collection files2 = this.myDescription.getRelatedFiles();
        FrameworkType frameworkType = this.myDescription.getDetector().getFrameworkType();
        if (files2.size() <= 5) {
            for (VirtualFile file2 : files2) {
                configuration2.addExcludedFile(file2, frameworkType);
            }
        } else {
            VirtualFile commonAncestor = VfsUtil.getCommonAncestor((Collection)files2);
            if (commonAncestor != null) {
                configuration2.addExcludedFile(commonAncestor, frameworkType);
            } else {
                LOG.info("Cannot find common ancestor for " + files2.size() + " files, disabling detection for " + frameworkType.getId() + " in the whole project");
                configuration2.addExcludedFramework(frameworkType);
            }
        }
    }

    private void appendDirectoryPath(ColoredTreeCellRenderer renderer2, VirtualFile dir) {
        String path2 = this.getRelativePath(dir);
        renderer2.append(" (" + (path2.isEmpty() ? "/" : path2) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    @NlsSafe
    private String getRelativePath(@NotNull VirtualFile file2) {
        String path2;
        VirtualFile dir;
        if (file2 == null) {
            DetectedFrameworkNode.$$$reportNull$$$0(0);
        }
        if ((dir = this.myContext.getBaseDir()) != null && (path2 = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)file2, (char)File.separatorChar)) != null) {
            String string = path2;
            if (string == null) {
                DetectedFrameworkNode.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = file2.getPresentableUrl();
        if (string == null) {
            DetectedFrameworkNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

