/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class InspectionDump
implements ApplicationStarter {
    InspectionDump() {
    }

    public String getCommandName() {
        return "inspections";
    }

    public void main(@NotNull List<String> args) {
        if (args == null) {
            InspectionDump.$$$reportNull$$$0(0);
        }
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newDefaultInstance();
        try {
            DocumentBuilder builder2 = factory2.newDocumentBuilder();
            Document document = builder2.newDocument();
            Element inspections = document.createElement("Inspections");
            document.appendChild(inspections);
            for (InspectionToolWrapper<?, ?> tool : InspectionToolRegistrar.getInstance().createTools()) {
                Element inspection = document.createElement("Inspection");
                inspection.setAttribute("groupPath", StringUtil.join((String[])tool.getGroupPath(), (String)";"));
                inspection.setAttribute("group", tool.getGroupDisplayName());
                inspection.setAttribute("name", tool.getDisplayName());
                inspection.setAttribute("level", tool.getDefaultLevel().getName());
                if (tool.getLanguage() != null) {
                    inspection.setAttribute("language", tool.getLanguage());
                }
                Element description = document.createElement("description");
                CDATASection descriptionSection = document.createCDATASection(InspectionDump.escapeCDATA(tool.loadDescription()));
                description.appendChild(descriptionSection);
                inspection.appendChild(description);
                inspections.appendChild(inspection);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            Object path2 = args.size() == 2 ? args.get(1) : PathManager.getHomePath() + File.separator + "AllInspections.xml";
            StreamResult console2 = new StreamResult(new File((String)path2));
            transformer.transform(source, console2);
            System.exit(0);
        }
        catch (ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String escapeCDATA(@NotNull String cData) {
        if (cData == null) {
            InspectionDump.$$$reportNull$$$0(1);
        }
        return cData.replaceAll("]", "&#x005D;").replaceAll("\\[", "&#x005B;");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/help/impl/InspectionDump";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "main";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "escapeCDATA";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

