/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class LocalHistoryRecordsTable
extends AbstractRecordsTable {
    private static final int VERSION = 4;
    private static final int LAST_ID_OFFSET = 8;
    private static final int FIRST_RECORD_OFFSET = 16;
    private static final int LAST_RECORD_OFFSET = 20;
    private static final int FS_TIMESTAMP_OFFSET = 24;
    private static final int HEADER_SIZE = 32;
    private static final int PREV_RECORD_OFFSET = 16;
    private static final int NEXT_RECORD_OFFSET = 20;
    private static final int TIMESTAMP_OFFSET = 24;
    private static final int RECORD_SIZE = 32;
    private static final byte[] ZEROS = new byte[32];

    public LocalHistoryRecordsTable(@NotNull Path storageFilePath, @NotNull PagePool pool) throws IOException {
        if (storageFilePath == null) {
            LocalHistoryRecordsTable.$$$reportNull$$$0(0);
        }
        if (pool == null) {
            LocalHistoryRecordsTable.$$$reportNull$$$0(1);
        }
        super(storageFilePath, pool);
    }

    protected int getHeaderSize() {
        return 32;
    }

    protected int getRecordSize() {
        return 32;
    }

    protected int getImplVersion() {
        return 4;
    }

    protected byte[] getZeros() {
        return ZEROS;
    }

    public long getLastId() {
        return this.myStorage.getLong(8L);
    }

    public void setLastId(long lastId) {
        this.markDirty();
        this.myStorage.putLong(8L, lastId);
    }

    public void setFirstRecord(int record) {
        this.markDirty();
        this.myStorage.putInt(16L, record);
    }

    public int getFirstRecord() {
        return this.myStorage.getInt(16L);
    }

    public void setLastRecord(int record) {
        this.markDirty();
        this.myStorage.putInt(20L, record);
    }

    public int getLastRecord() {
        return this.myStorage.getInt(20L);
    }

    public void setFSTimestamp(long timestamp) {
        this.markDirty();
        this.myStorage.putLong(24L, timestamp);
    }

    public long getFSTimestamp() {
        return this.myStorage.getLong(24L);
    }

    public void setPrevRecord(int record, int prevRecord) {
        this.markDirty();
        this.myStorage.putInt((long)this.getOffset(record, 16), prevRecord);
    }

    public int getPrevRecord(int record) {
        return this.myStorage.getInt((long)this.getOffset(record, 16));
    }

    public void setNextRecord(int record, int nextRecord) {
        this.markDirty();
        this.myStorage.putInt((long)this.getOffset(record, 20), nextRecord);
    }

    public int getNextRecord(int record) {
        return this.myStorage.getInt((long)this.getOffset(record, 20));
    }

    public void setTimestamp(int record, long timestamp) {
        this.markDirty();
        this.myStorage.putLong((long)this.getOffset(record, 24), timestamp);
    }

    public long getTimestamp(int record) {
        return this.myStorage.getLong((long)this.getOffset(record, 24));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "storageFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pool";
                break;
            }
        }
        objectArray[1] = "com/intellij/history/core/LocalHistoryRecordsTable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

