/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSet {
    private final long myId;
    @Nullable
    private @NlsContexts.Label String myName;
    private final long myTimestamp;
    private final List<Change> myChanges;
    private volatile boolean isLocked = false;

    public ChangeSet(long id2, long timestamp) {
        this.myId = id2;
        this.myTimestamp = timestamp;
        this.myChanges = new ArrayList<Change>();
    }

    public ChangeSet(DataInput in) throws IOException {
        this.myId = DataInputOutputUtil.readLONG((DataInput)in);
        this.myName = DataStreamUtil.readStringOrNull(in);
        this.myTimestamp = DataInputOutputUtil.readTIME((DataInput)in);
        int count = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<Change> changes = new ArrayList<Change>(count);
        while (count-- > 0) {
            changes.add(DataStreamUtil.readChange(in));
        }
        this.myChanges = Collections.unmodifiableList(changes);
        this.isLocked = true;
    }

    public void write(DataOutput out) throws IOException {
        LocalHistoryLog.LOG.assertTrue(this.isLocked, (Object)"Changeset should be locked");
        DataInputOutputUtil.writeLONG((DataOutput)out, (long)this.myId);
        DataStreamUtil.writeStringOrNull(out, this.myName);
        DataInputOutputUtil.writeTIME((DataOutput)out, (long)this.myTimestamp);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChanges.size());
        for (Change c : this.myChanges) {
            DataStreamUtil.writeChange(out, c);
        }
    }

    public void setName(@Nullable @NlsContexts.Label String name2) {
        this.myName = name2;
    }

    @NlsContexts.Label
    @Nullable
    public String getName() {
        return this.myName;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void lock() {
        this.isLocked = true;
    }

    @NlsContexts.Label
    @Nullable
    public String getLabel() {
        return this.accessChanges(() -> {
            for (Change each : this.myChanges) {
                if (!(each instanceof PutLabelChange)) continue;
                return ((PutLabelChange)each).getName();
            }
            return null;
        });
    }

    public int getLabelColor() {
        return this.accessChanges(() -> {
            for (Change each : this.myChanges) {
                if (!(each instanceof PutSystemLabelChange)) continue;
                return ((PutSystemLabelChange)each).getColor();
            }
            return -1;
        });
    }

    public void addChange(Change c) {
        LocalHistoryLog.LOG.assertTrue(!this.isLocked, (Object)"Changeset is already locked");
        this.accessChanges(() -> this.myChanges.add(c));
    }

    public List<Change> getChanges() {
        return this.accessChanges(() -> {
            if (this.isLocked) {
                return this.myChanges;
            }
            return Collections.unmodifiableList(new ArrayList<Change>(this.myChanges));
        });
    }

    public boolean isEmpty() {
        return this.accessChanges(() -> this.myChanges.isEmpty());
    }

    public boolean affectsPath(String paths2) {
        return this.accessChanges(() -> {
            for (Change c : this.myChanges) {
                if (!c.affectsPath(paths2)) continue;
                return true;
            }
            return false;
        });
    }

    public boolean isCreationalFor(String path2) {
        return this.accessChanges(() -> {
            for (Change c : this.myChanges) {
                if (!c.isCreationalFor(path2)) continue;
                return true;
            }
            return false;
        });
    }

    public List<Content> getContentsToPurge() {
        return this.accessChanges(() -> {
            ArrayList<Content> result2 = new ArrayList<Content>();
            for (Change c : this.myChanges) {
                result2.addAll(c.getContentsToPurge());
            }
            return result2;
        });
    }

    public boolean isContentChangeOnly() {
        return this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof ContentChange);
    }

    public boolean isLabelOnly() {
        return this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof PutLabelChange);
    }

    public Change getFirstChange() {
        return this.accessChanges(() -> this.myChanges.get(0));
    }

    public Change getLastChange() {
        return this.accessChanges(() -> this.myChanges.get(this.myChanges.size() - 1));
    }

    public List<String> getAffectedPaths() {
        return this.accessChanges(() -> {
            SmartList result2 = new SmartList();
            for (Change each : this.myChanges) {
                if (!(each instanceof StructuralChange)) continue;
                result2.add(((StructuralChange)each).getPath());
            }
            return result2;
        });
    }

    public String toString() {
        return this.accessChanges(() -> this.myChanges.toString());
    }

    public long getId() {
        return this.myId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSet change = (ChangeSet)o;
        return this.myId == change.myId;
    }

    public final int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        if (this.isLocked) {
            this.doAccept(v);
            return;
        }
        List<Change> list2 = this.myChanges;
        synchronized (list2) {
            this.doAccept(v);
        }
    }

    private void doAccept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.begin(this);
        for (Change c : ContainerUtil.iterateBackward(this.myChanges)) {
            c.accept(v);
        }
        v.end(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T accessChanges(@NotNull Supplier<T> func) {
        if (func == null) {
            ChangeSet.$$$reportNull$$$0(0);
        }
        if (this.isLocked) {
            return func.get();
        }
        List<Change> list2 = this.myChanges;
        synchronized (list2) {
            return func.get();
        }
    }

    private void accessChanges(@NotNull Runnable func) {
        if (func == null) {
            ChangeSet.$$$reportNull$$$0(1);
        }
        this.accessChanges(() -> {
            func.run();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "com/intellij/history/core/changes/ChangeSet", "accessChanges"));
    }
}

