/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.CliResult;
import com.intellij.ide.CommandLineProcessorResult;
import com.intellij.ide.CommandLineWaitingManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ProtocolHandler;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenResult;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.CommandLineArgs;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance(CommandLineProcessor.class);
    private static final String OPTION_WAIT = "--wait";
    public static final Future<CliResult> OK_FUTURE = CompletableFuture.completedFuture(CliResult.OK);
    @ApiStatus.Internal
    public static final String SCHEME_INTERNAL = "!!!internal!!!";

    private CommandLineProcessor() {
    }

    @ApiStatus.Internal
    @NotNull
    public static CommandLineProcessorResult doOpenFileOrProject(@NotNull Path file2, boolean shouldWait) {
        if (file2 == null) {
            CommandLineProcessor.$$$reportNull$$$0(0);
        }
        OpenProjectTask openProjectOptions = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(file2, null);
        openProjectOptions.checkDirectoryForFileBasedProjects = false;
        Project project = null;
        if (!LightEditUtil.isForceOpenInLightEditMode()) {
            OpenResult openResult = ProjectUtil.tryOpenOrImport(file2, openProjectOptions);
            if (openResult instanceof OpenResult.Success) {
                project = ((OpenResult.Success)openResult).getProject();
            } else if (openResult instanceof OpenResult.Cancel) {
                CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.open.cancelled", (Object[])new Object[0]));
                if (commandLineProcessorResult == null) {
                    CommandLineProcessor.$$$reportNull$$$0(1);
                }
                return commandLineProcessorResult;
            }
        }
        if (project == null) {
            CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessor.doOpenFile(file2, -1, -1, false, shouldWait);
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(2);
            }
            return commandLineProcessorResult;
        }
        return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForProject(project) : OK_FUTURE);
    }

    private static CommandLineProcessorResult doOpenFile(Path ioFile, int line, int column2, boolean tempProject, boolean shouldWait) {
        Project project;
        VirtualFile file2;
        RecentProjectsManager recentProjectManager;
        Project[] projects;
        Project[] projectArray = projects = tempProject ? new Project[]{} : ProjectUtilCore.getOpenProjects();
        if (!tempProject && projects.length == 0 && PlatformUtils.isDataGrip() && (recentProjectManager = RecentProjectsManager.getInstance()).willReopenProjectOnStart() && ((Boolean)recentProjectManager.reopenLastProjectsOnStart().join()).booleanValue()) {
            projects = ProjectUtilCore.getOpenProjects();
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(ioFile)) == null) {
            Project lightEditProject;
            if (LightEditUtil.isLightEditEnabled() && (lightEditProject = LightEditUtil.openFile(ioFile, true)) != null) {
                Future<CliResult> future2 = shouldWait ? CommandLineWaitingManager.getInstance().addHookForPath(ioFile) : OK_FUTURE;
                return new CommandLineProcessorResult(lightEditProject, future2);
            }
            return CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.can.not.open.file", (Object[])new Object[]{ioFile.toString()}));
        }
        if (projects.length == 0) {
            Project project2 = CommandLineProjectOpenProcessor.getInstance().openProjectAndFile(ioFile, line, column2, tempProject);
            if (project2 == null) {
                return CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.no.project.found.to.open.file.in", (Object[])new Object[0]));
            }
            return new CommandLineProcessorResult(project2, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : OK_FUTURE);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        if (LightEditUtil.isForceOpenInLightEditMode()) {
            project = LightEditService.getInstance().openFile(file2);
            LightEditFeatureUsagesUtil.logFileOpen(project, LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
        } else {
            project = CommandLineProcessor.findBestProject(file2, projects);
            OpenFileDescriptor navigatable2 = line > 0 ? new OpenFileDescriptor(project, file2, line - 1, Math.max(column2, 0)) : PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1);
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project)).execute(() -> CommandLineProcessor.lambda$doOpenFile$0((Navigatable)navigatable2));
        }
        return new CommandLineProcessorResult(project, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : OK_FUTURE);
    }

    private static Project findBestProject(VirtualFile file2, Project[] projects) {
        Project project;
        for (Project project2 : projects) {
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project2);
            if (!((Boolean)ReadAction.compute(() -> fileIndex.isInContent(file2))).booleanValue()) continue;
            return project2;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project = frame.getProject()) != null && !LightEdit.owns((Project)project)) {
            return project;
        }
        return projects[0];
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<CliResult> processProtocolCommand(@NotNull @NlsSafe String rawUri) {
        if (rawUri == null) {
            CommandLineProcessor.$$$reportNull$$$0(3);
        }
        LOG.info("external URI request:\n" + rawUri);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new IllegalStateException("cannot process URI requests in headless state");
        }
        final boolean internal = rawUri.startsWith(SCHEME_INTERNAL);
        final String uri = internal ? rawUri.substring(SCHEME_INTERNAL.length()) : rawUri;
        int separatorStart = uri.indexOf("://");
        if (separatorStart < 0) {
            throw new IllegalArgumentException(uri);
        }
        final String scheme2 = uri.substring(0, separatorStart);
        final String query2 = uri.substring(separatorStart + "://".length());
        final CompletableFuture<CliResult> result2 = new CompletableFuture<CliResult>();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"ide.protocol.progress.title", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator2.setIndeterminate(true);
                indicator2.setText(uri);
                ((CompletableFuture)(internal ? CommandLineProcessor.processInternalProtocol(query2) : ProtocolHandler.process(scheme2, query2, indicator2)).exceptionally(t -> {
                    LOG.error(t);
                    return new CliResult(0, IdeBundle.message((String)"ide.protocol.exception", (Object[])new Object[]{t.getClass().getSimpleName(), t.getMessage()}));
                })).thenAccept(cliResult -> {
                    result2.complete(cliResult);
                    if (cliResult.message != null) {
                        String title2 = IdeBundle.message((String)"ide.protocol.cannot.title", (Object[])new Object[0]);
                        new Notification("System Messages", title2, cliResult.message, NotificationType.WARNING).addAction((AnAction)ShowLogAction.notificationAction()).notify(null);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/CommandLineProcessor$1", "run"));
            }
        });
        CompletableFuture<CliResult> completableFuture = result2;
        if (completableFuture == null) {
            CommandLineProcessor.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    private static CompletableFuture<CliResult> processInternalProtocol(String query2) {
        try {
            Path file2;
            Map parameters2;
            String fileStr;
            QueryStringDecoder decoder = new QueryStringDecoder(query2);
            if ("open".equals(decoder.path()) && (fileStr = (String)ContainerUtil.getLastItem((List)((List)(parameters2 = decoder.parameters()).get("file")))) != null && !fileStr.isBlank() && (file2 = CommandLineProcessor.parseFilePath(fileStr, null)) != null) {
                int line = StringUtil.parseInt((String)((String)ContainerUtil.getLastItem((List)((List)parameters2.get("line")))), (int)-1);
                int column2 = StringUtil.parseInt((String)((String)ContainerUtil.getLastItem((List)((List)parameters2.get("column")))), (int)-1);
                CommandLineProcessorResult result2 = CommandLineProcessor.openFileOrProject(file2, line, column2, false, false, false);
                LifecycleUsageTriggerCollector.onProtocolOpenCommandHandled(result2.getProject());
                return CompletableFuture.completedFuture(CliResult.OK);
            }
            return CompletableFuture.completedFuture(new CliResult(0, IdeBundle.message((String)"ide.protocol.internal.bad.query", (Object[])new Object[]{query2})));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @NotNull
    public static CommandLineProcessorResult processExternalCommandLine(@NotNull List<String> args, @Nullable String currentDirectory) {
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(5);
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("External command line:").append('\n');
        logMessage.append("Dir: ").append(currentDirectory).append('\n');
        for (String arg : args) {
            logMessage.append(arg).append('\n');
        }
        logMessage.append("-----");
        LOG.info(logMessage.toString());
        if (args.isEmpty()) {
            return new CommandLineProcessorResult(null, OK_FUTURE);
        }
        CommandLineProcessorResult result2 = CommandLineProcessor.processApplicationStarters(args, currentDirectory);
        if (result2 != null) {
            CommandLineProcessorResult commandLineProcessorResult = result2;
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(6);
            }
            return commandLineProcessorResult;
        }
        CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessor.processOpenFile(args, currentDirectory);
        if (commandLineProcessorResult == null) {
            CommandLineProcessor.$$$reportNull$$$0(7);
        }
        return commandLineProcessorResult;
    }

    @Nullable
    private static CommandLineProcessorResult processApplicationStarters(List<String> args, @Nullable String currentDirectory) {
        String command = args.get(0);
        return (CommandLineProcessorResult)ApplicationStarter.EP_NAME.computeSafeIfAny(starter2 -> {
            if (!command.equals(starter2.getCommandName())) {
                return null;
            }
            if (!starter2.canProcessExternalCommandLine()) {
                return CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.only.one.instance.can.be.run.at.time", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
            }
            LOG.info("Processing command with " + starter2);
            int requiredModality = starter2.getRequiredModality();
            if (requiredModality == 3) {
                return new CommandLineProcessorResult(null, starter2.processExternalCommandLineAsync(args, currentDirectory));
            }
            ModalityState modalityState = requiredModality == 2 ? ModalityState.any() : ModalityState.defaultModalityState();
            AtomicReference ref = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> ref.set(new CommandLineProcessorResult(null, starter2.processExternalCommandLineAsync(args, currentDirectory))), modalityState);
            return (CommandLineProcessorResult)ref.get();
        });
    }

    private static CommandLineProcessorResult processOpenFile(List<String> args, @Nullable String currentDirectory) {
        CommandLineProcessorResult projectAndCallback = null;
        int line = -1;
        int column2 = -1;
        boolean tempProject = false;
        boolean shouldWait = args.contains(OPTION_WAIT);
        boolean lightEditMode = false;
        for (int i2 = 0; i2 < args.size(); ++i2) {
            Path file2;
            String arg = args.get(i2);
            if (CommandLineArgs.isKnownArgument(arg) || OPTION_WAIT.equals(arg)) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i2 == args.size()) break;
                line = StringUtil.parseInt((String)args.get(i2), (int)-1);
                continue;
            }
            if (arg.equals("-c") || arg.equals("--column")) {
                if (++i2 == args.size()) break;
                column2 = StringUtil.parseInt((String)args.get(i2), (int)-1);
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (arg.equals("-e") || arg.equals("--edit")) {
                lightEditMode = true;
                continue;
            }
            if (arg.equals("-p") || arg.equals("--project")) continue;
            if (StringUtil.isQuotedString((String)arg)) {
                arg = StringUtil.unquoteString((String)arg);
            }
            if ((file2 = CommandLineProcessor.parseFilePath(arg, currentDirectory)) == null) {
                return CommandLineProcessorResult.createError(IdeBundle.message((String)"dialog.message.invalid.path", (Object[])new Object[]{arg}));
            }
            projectAndCallback = CommandLineProcessor.openFileOrProject(file2, line, column2, tempProject, shouldWait, lightEditMode);
            if (shouldWait) break;
            column2 = -1;
            line = -1;
            tempProject = false;
        }
        if (projectAndCallback != null) {
            return projectAndCallback;
        }
        if (shouldWait) {
            return new CommandLineProcessorResult(null, CliResult.error((int)1, (String)IdeBundle.message((String)"dialog.message.wait.must.be.supplied.with.file.or.project.to.wait.for", (Object[])new Object[0])));
        }
        if (lightEditMode) {
            LightEditService.getInstance().showEditorWindow();
            return new CommandLineProcessorResult(LightEditService.getInstance().getProject(), OK_FUTURE);
        }
        return new CommandLineProcessorResult(null, OK_FUTURE);
    }

    @Nullable
    private static Path parseFilePath(String path2, @Nullable String currentDirectory) {
        try {
            Path file2 = Path.of(FileUtilRt.toSystemDependentName((String)path2), new String[0]);
            if (!file2.isAbsolute()) {
                file2 = currentDirectory == null ? file2.toAbsolutePath() : Path.of(currentDirectory, new String[0]).resolve(file2);
            }
            return file2.normalize();
        }
        catch (InvalidPathException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static CommandLineProcessorResult openFileOrProject(Path file2, int line, int column2, boolean tempProject, boolean shouldWait, boolean lightEditMode) {
        return (CommandLineProcessorResult)LightEditUtil.computeWithCommandLineOptions(shouldWait, lightEditMode, () -> {
            boolean asFile = line != -1 || tempProject;
            return asFile ? CommandLineProcessor.doOpenFile(file2, line, column2, tempProject, shouldWait) : CommandLineProcessor.doOpenFileOrProject(file2, shouldWait);
        });
    }

    private static /* synthetic */ void lambda$doOpenFile$0(Navigatable navigatable2) {
        navigatable2.navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawUri";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenFileOrProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processProtocolCommand";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFileOrProject";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processProtocolCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

