/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseEditorsActionBase;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CloseAllEditorsToTheLeftAction
extends CloseEditorsActionBase {
    @Override
    protected boolean isFileToClose(EditorComposite editor2, EditorWindow window) {
        return false;
    }

    @Override
    protected boolean isFileToCloseInContext(DataContext dataContext, EditorComposite candidate, EditorWindow window) {
        VirtualFile contextFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        VirtualFile candidateFile = candidate.getFile();
        if (candidate.isPinned()) {
            return false;
        }
        if (Comparing.equal((Object)candidateFile, (Object)contextFile)) {
            return false;
        }
        for (EditorWithProviderComposite composite2 : window.getEditors()) {
            VirtualFile cursorFile = composite2.getFile();
            if (!Comparing.equal((Object)cursorFile, (Object)contextFile) && !Comparing.equal((Object)cursorFile, (Object)candidateFile)) continue;
            return this.isOKToClose(contextFile, candidateFile, cursorFile);
        }
        return false;
    }

    protected boolean isOKToClose(VirtualFile contextFile, VirtualFile candidateFile, VirtualFile cursorFile) {
        return Comparing.equal((Object)cursorFile, (Object)candidateFile);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseAllEditorsToTheLeftAction.$$$reportNull$$$0(0);
        }
        super.update(event);
        int tabPlacement = UISettings.getInstance().getEditorTabPlacement();
        if (tabPlacement == 2 || tabPlacement == 4) {
            event.getPresentation().setText(IdeBundle.messagePointer((String)this.getAlternativeTextKey(), (Object[])new Object[0]));
        }
    }

    protected String getAlternativeTextKey() {
        return "action.close.all.editors.above";
    }

    @Override
    protected String getPresentationText(boolean inSplitter) {
        return ActionsBundle.actionText((String)"CloseAllToTheLeft");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/CloseAllEditorsToTheLeftAction", "update"));
    }
}

