/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Restarter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateLauncherScriptAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(0);
        }
        boolean enabled = SystemInfo.isUnix && (!ExternalUpdateManager.isRoaming() || ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX);
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String ok;
        String message2;
        Path target2;
        String home2;
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isUnix || ExternalUpdateManager.isRoaming()) {
            if (ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX) {
                String title2 = ApplicationBundle.message((String)"launcher.script.title", (Object[])new Object[0]);
                String message3 = ApplicationBundle.message((String)"launcher.script.luke", (Object[])new Object[0]);
                Messages.showInfoMessage((Project)event.getProject(), (String)message3, (String)title2);
            }
            return;
        }
        final Project project = event.getProject();
        ApplicationNamesInfo appNames = ApplicationNamesInfo.getInstance();
        String title3 = ApplicationBundle.message((String)"launcher.script.title", (Object[])new Object[0]);
        String prompt = ApplicationBundle.message((String)"launcher.script.prompt", (Object[])new Object[]{appNames.getFullProductName()});
        String scriptName = appNames.getDefaultLauncherName();
        if (scriptName == null || scriptName.isBlank()) {
            scriptName = appNames.getProductName().toLowerCase(Locale.ENGLISH);
        }
        Object path2 = "/usr/local/bin/" + scriptName;
        if ((path2 = Messages.showInputDialog((Project)project, (String)prompt, (String)title3, null, (String)path2, null)) == null) {
            return;
        }
        if (!((String)path2).startsWith("/") && (home2 = System.getenv("HOME")) != null && Files.isDirectory(Path.of(home2, new String[0]), new LinkOption[0])) {
            Object object = path2 = ((String)path2).startsWith("~/") ? home2 + ((String)path2).substring(1) : home2 + "/" + (String)path2;
        }
        if (Files.exists(target2 = Path.of((String)path2, new String[0]), new LinkOption[0]) && Messages.showOkCancelDialog((Project)project, (String)(message2 = ApplicationBundle.message((String)"launcher.script.overwrite", (Object[])new Object[]{target2})), (String)title3, (String)(ok = ApplicationBundle.message((String)"launcher.script.overwrite.button", (Object[])new Object[0])), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        new Task.Backgroundable(project, ApplicationBundle.message((String)"launcher.script.progress", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CreateLauncherScriptAction.createLauncherScript(target2);
                }
                catch (Exception e) {
                    Logger.getInstance(CreateLauncherScriptAction.class).warn((Throwable)e);
                    String title2 = IdeBundle.message((String)"notification.title.launcher.script.creation.failed", (Object[])new Object[0]);
                    String message2 = ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)IdeBundle.message((String)"notification.content.internal error", (Object[])new Object[0]));
                    new Notification("System Messages", title2, message2, NotificationType.ERROR).notify(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateLauncherScriptAction$1", "run"));
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createLauncherScript(Path scriptTarget) throws Exception {
        Path scriptFile;
        block11: {
            String interpreter;
            Path scriptTargetDir = scriptTarget.getParent();
            if (scriptTargetDir == null) {
                throw new IllegalArgumentException("Invalid path: " + scriptTarget);
            }
            File starter2 = Restarter.getIdeStarter();
            if (starter2 == null) {
                throw new IOException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{PathManager.getBinPath()}));
            }
            String string = PathEnvironmentVariableUtil.findInPath((String)"python3") != null ? "python3" : (interpreter = PathEnvironmentVariableUtil.findInPath((String)"python") != null ? "python" : null);
            if (interpreter == null) {
                throw new IOException("Cannot find a Python interpreter");
            }
            ClassLoader loader = CreateLauncherScriptAction.class.getClassLoader();
            assert (loader != null);
            Map<String, String> variables = Map.of("$PYTHON$", interpreter, "$CONFIG_PATH$", PathManager.getConfigPath(), "$SYSTEM_PATH$", PathManager.getSystemPath(), "$RUN_PATH$", starter2.getPath());
            String launcherContents = StringUtil.convertLineSeparators((String)ExecUtil.loadTemplate((ClassLoader)loader, (String)"launcher.py", variables));
            scriptFile = ExecUtil.createTempExecutableScript((String)"launcher", (String)"", (String)launcherContents).toPath();
            Path installationScript = null;
            try {
                NioFiles.createDirectories((Path)scriptTargetDir);
                Files.move(scriptFile, scriptTarget, StandardCopyOption.REPLACE_EXISTING);
                if (installationScript == null) break block11;
            }
            catch (IOException e) {
                block12: {
                    try {
                        Logger.getInstance(CreateLauncherScriptAction.class).info(scriptTarget.toString(), (Throwable)e);
                        String scriptTargetDirPath = scriptTargetDir.toString();
                        String installationScriptSrc = "#!/bin/sh\nmkdir -p '" + scriptTargetDirPath + "' && install -g 0 -o 0 '" + scriptFile + "' '" + scriptTarget + "'";
                        installationScript = ExecUtil.createTempExecutableScript((String)"launcher_installer", (String)".sh", (String)installationScriptSrc).toPath();
                        GeneralCommandLine command = new GeneralCommandLine(new String[]{installationScript.toString()}).withRedirectErrorStream(true);
                        String prompt = ApplicationBundle.message((String)"launcher.script.sudo.prompt", (Object[])new Object[]{scriptTargetDirPath});
                        ProcessOutput result2 = ExecUtil.sudoAndGetOutput((GeneralCommandLine)command, (String)prompt);
                        if (result2.getExitCode() != 0) {
                            String message2 = "Launcher script creation failed with " + result2.getExitCode();
                            String output2 = result2.getStdout();
                            if (!output2.isBlank()) {
                                message2 = message2 + "\nOutput: " + output2.trim();
                            }
                            throw new RuntimeException(message2);
                        }
                        if (installationScript == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (installationScript != null) {
                            Files.deleteIfExists(installationScript);
                        }
                        Files.deleteIfExists(scriptFile);
                        throw throwable;
                    }
                    Files.deleteIfExists(installationScript);
                }
                Files.deleteIfExists(scriptFile);
            }
            Files.deleteIfExists(installationScript);
        }
        Files.deleteIfExists(scriptFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/ide/actions/CreateLauncherScriptAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

