/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.IoErrorText;
import java.awt.Component;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\n\u0010\t\u001a\u0004\u0018\u00010\nH$J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/actions/EditCustomSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "charset", "Ljava/nio/charset/Charset;", "file", "Ljava/nio/file/Path;", "openInDialog", "frame", "Ljavax/swing/JFrame;", "openInEditor", "project", "Lcom/intellij/openapi/project/Project;", "template", "", "update", "intellij.platform.ide.impl"})
public abstract class EditCustomSettingsAction
extends DumbAwareAction {
    @Nullable
    protected abstract Path file();

    @NotNull
    protected abstract String template();

    @NotNull
    protected Charset charset() {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        return charset;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled((e.getProject() != null || WelcomeFrame.getInstance() != null) && this.file() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Path path2 = this.file();
        if (path2 == null) {
            return;
        }
        Path file2 = path2;
        Project project = e.getProject();
        if (project != null) {
            this.openInEditor(file2, project);
        } else {
            JFrame frame = (JFrame)WelcomeFrame.getInstance();
            if (frame != null) {
                this.openInDialog(file2, frame);
            }
        }
    }

    private final void openInEditor(Path file2, Project project) {
        VirtualFile vFile;
        if (!Files.exists(file2, new LinkOption[0])) {
            try {
                Files.write(file2, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)this.template()), this.charset(), new OpenOption[0]);
            }
            catch (IOException e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn(((Object)file2).toString(), (Throwable)e);
                String string = IdeBundle.message((String)"file.write.error.details", (Object[])new Object[]{file2, IoErrorText.message((Throwable)e)});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"file.\u2026, IoErrorText.message(e))");
                String message2 = string;
                Messages.showErrorDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle());
                return;
            }
        }
        if ((vFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file2)) != null) {
            vFile.refresh(false, false);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            if (psiFile != null) {
                PsiNavigationSupport.getInstance().createNavigatable(project, vFile, psiFile.getTextLength()).navigate(true);
            }
        }
    }

    private final void openInDialog(Path file2, JFrame frame) {
        List<String> lines2;
        List<String> list2;
        if (!Files.exists(file2, new LinkOption[0])) {
            list2 = StringsKt.lines((CharSequence)this.template());
        } else {
            List<String> list3;
            try {
                list3 = Files.readAllLines(file2, this.charset());
            }
            catch (IOException e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn(((Object)file2).toString(), (Throwable)e);
                String string = IdeBundle.message((String)"file.read.error.details", (Object[])new Object[]{file2, IoErrorText.message((Throwable)e)});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"file.\u2026, IoErrorText.message(e))");
                String message2 = string;
                Messages.showErrorDialog((Component)frame, (String)message2, (String)CommonBundle.getErrorTitle());
                return;
            }
            list2 = list3;
        }
        List<String> list4 = lines2 = list2;
        Intrinsics.checkNotNullExpressionValue(list4, (String)"lines");
        String text2 = CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        new DialogWrapper(this, file2, text2, frame, frame, true){
            private final EditorTextField editor;
            final /* synthetic */ EditCustomSettingsAction this$0;
            final /* synthetic */ Path $file;
            final /* synthetic */ String $text;
            final /* synthetic */ JFrame $frame;

            @NotNull
            protected EditorTextField createCenterPanel() {
                return this.editor;
            }

            @NotNull
            public EditorTextField getPreferredFocusedComponent() {
                return this.editor;
            }

            @NotNull
            protected String getDimensionServiceKey() {
                return "ide.config.custom.settings";
            }

            protected void doOKAction() {
                try {
                    String string = this.editor.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.text");
                    Files.write(this.$file, (Iterable<? extends CharSequence>)StringsKt.split$default((CharSequence)string, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null), this.this$0.charset(), new OpenOption[0]);
                    this.close(0);
                }
                catch (IOException e) {
                    Logger.getInstance(((Object)((Object)this)).getClass()).warn(((Object)this.$file).toString(), (Throwable)e);
                    String string = IdeBundle.message((String)"file.write.error.details", (Object[])new Object[]{this.$file, IoErrorText.message((Throwable)e)});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"file.\u2026, IoErrorText.message(e))");
                    String message2 = string;
                    Messages.showErrorDialog((Component)this.getWindow(), (String)message2, (String)CommonBundle.getErrorTitle());
                }
            }
            {
                this.this$0 = this$0;
                this.$file = $captured_local_variable$1;
                this.$text = $captured_local_variable$2;
                this.$frame = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
                this.setTitle(FileUtil.getLocationRelativeToUserHome((String)((Object)$captured_local_variable$1).toString()));
                this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
                Document document = EditorFactory.getInstance().createDocument((CharSequence)$captured_local_variable$2);
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"EditorFactory.getInstance().createDocument(text)");
                Document document2 = document;
                DefaultProjectFactory defaultProjectFactory = DefaultProjectFactory.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)defaultProjectFactory, (String)"DefaultProjectFactory.getInstance()");
                Project defaultProject = defaultProjectFactory.getDefaultProject();
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(((Object)$captured_local_variable$1.getFileName()).toString());
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"FileTypeManager.getInsta\u2026file.fileName.toString())");
                FileType fileType2 = fileType;
                this.editor = new EditorTextField(document2, defaultProject, fileType2, document2, defaultProject, fileType2, false, false){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ Project $defaultProject;
                    final /* synthetic */ FileType $fileType;

                    @NotNull
                    protected EditorEx createEditor() {
                        EditorEx editorEx = super.createEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"super.createEditor()");
                        EditorEx editor2 = editorEx;
                        JScrollPane jScrollPane = editor2.getScrollPane();
                        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
                        jScrollPane.setVerticalScrollBarPolicy(20);
                        JScrollPane jScrollPane2 = editor2.getScrollPane();
                        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"editor.scrollPane");
                        jScrollPane2.setHorizontalScrollBarPolicy(30);
                        return editor2;
                    }
                    {
                        this.$document = $captured_local_variable$0;
                        this.$defaultProject = $captured_local_variable$1;
                        this.$fileType = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                    }
                };
                this.init();
            }
        }.show();
    }
}

