/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowFilePathAction
extends DumbAwareAction {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final NotificationListener FILE_SELECTING_LISTENER = RevealFileAction.FILE_SELECTING_LISTENER;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(0);
        }
        boolean visible = !SystemInfo.isMac && RevealFileAction.isSupported();
        e.getPresentation().setVisible(visible);
        if (visible) {
            VirtualFile file2 = ShowFilePathAction.getFile(e);
            e.getPresentation().setEnabled(file2 != null);
            e.getPresentation().setText(ActionsBundle.messagePointer((String)(file2 != null && file2.isDirectory() ? "action.ShowFilePath.directory" : "action.ShowFilePath.file"), (Object[])new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(1);
        }
        if ((file2 = ShowFilePathAction.getFile(e)) != null) {
            ShowFilePathAction.show(file2, (Consumer<? super ListPopup>)((Consumer)popup2 -> {
                DataManager dataManager = DataManager.getInstance();
                if (dataManager != null) {
                    dataManager.getDataContextFromFocusAsync().onSuccess(arg_0 -> ((ListPopup)popup2).showInBestPositionFor(arg_0));
                }
            }));
        }
    }

    @Nullable
    private static VirtualFile getFile(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(2);
        }
        return (files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || files2.length == 1 ? (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE) : null;
    }

    public static void show(@NotNull VirtualFile file2, @NotNull MouseEvent e) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowFilePathAction.$$$reportNull$$$0(4);
        }
        ShowFilePathAction.show(file2, (Consumer<? super ListPopup>)((Consumer)popup2 -> {
            if (e.getComponent().isShowing()) {
                popup2.show(new RelativePoint(e));
            }
        }));
    }

    private static void show(@NotNull VirtualFile file2, @NotNull Consumer<? super ListPopup> action2) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(6);
        }
        if (!RevealFileAction.isSupported()) {
            return;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file2; eachParent != null; eachParent = eachParent.getParent()) {
            int index2 = files2.size();
            files2.add(index2, eachParent);
            fileUrls.add(index2, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList<Icon> icons = new ArrayList<Icon>();
            for (String url : fileUrls) {
                File ioFile = new File(url);
                icons.add(ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : EmptyIcon.ICON_16);
            }
            ApplicationManager.getApplication().invokeLater(() -> action2.consume((Object)ShowFilePathAction.createPopup(files2, icons)));
        });
    }

    private static String getPresentableUrl(VirtualFile file2) {
        Object url = file2.getPresentableUrl();
        if (file2.getParent() == null && SystemInfo.isWindows) {
            url = (String)url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(List<? extends VirtualFile> files2, List<? extends Icon> icons) {
        BaseListPopupStep<VirtualFile> step2 = new BaseListPopupStep<VirtualFile>(RevealFileAction.getActionName(), files2, icons){

            @NotNull
            public String getTextFor(VirtualFile value2) {
                String string = value2.getPresentableName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RevealFileAction.openFile(selectedFile));
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$1", "getTextFor"));
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String getFileManagerName() {
        String string = RevealFileAction.getFileManagerName();
        if (string == null) {
            ShowFilePathAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            ShowFilePathAction.$$$reportNull$$$0(8);
        }
        RevealFileAction.openFile(file2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            ShowFilePathAction.$$$reportNull$$$0(9);
        }
        RevealFileAction.openDirectory(directory);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        return RevealFileAction.findLocalFile(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ShowFilePathAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ShowFilePathAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManagerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

