/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SplitAction
extends AnAction
implements DumbAware {
    public static final Key<Boolean> FORBID_TAB_SPLIT = new Key("FORBID_TAB_SPLIT");
    private final int myOrientation;
    private final boolean myCloseSource;

    protected SplitAction(int orientation) {
        this(orientation, false);
    }

    protected SplitAction(int orientation, boolean closeSource) {
        this.myOrientation = orientation;
        this.myCloseSource = closeSource;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            SplitAction.$$$reportNull$$$0(0);
        }
        EditorWindow window = (EditorWindow)event.getRequiredData(EditorWindow.DATA_KEY);
        VirtualFile file2 = window.getSelectedFile();
        if (this.myCloseSource && file2 != null) {
            file2.putUserData(EditorWindow.DRAG_START_PINNED_KEY, (Object)window.isFilePinned(file2));
            window.closeFile(file2, false, false);
        }
        window.split(this.myOrientation, true, file2, true);
    }

    public void update(@NotNull AnActionEvent event) {
        EditorWindow window;
        if (event == null) {
            SplitAction.$$$reportNull$$$0(1);
        }
        VirtualFile selectedFile = (window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) != null ? window.getSelectedFile() : null;
        boolean enabled = this.isEnabled(selectedFile, window);
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    private boolean isEnabled(@Nullable VirtualFile vFile, @Nullable EditorWindow window) {
        if (vFile == null || window == null) {
            return false;
        }
        if (!this.myCloseSource && FileEditorManagerImpl.forbidSplitFor(vFile)) {
            return false;
        }
        int minimum = this.myCloseSource ? 2 : 1;
        return window.getTabCount() >= minimum;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/ide/actions/SplitAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

