/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.BaseSwitcherAction;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.actions.SwitcherKeyReleaseListener;
import com.intellij.ide.actions.SwitcherListFocusAction;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.ide.actions.SwitcherListRenderer;
import com.intellij.ide.actions.SwitcherRecentLocations;
import com.intellij.ide.actions.SwitcherSpeedSearch;
import com.intellij.ide.actions.SwitcherToolWindow;
import com.intellij.ide.actions.SwitcherVirtualFile;
import com.intellij.ide.actions.ui.JBListWithOpenInRightSplit;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SwingActionDelegate;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.hover.ListHoverListener;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingTextTrimmer;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Switcher
extends BaseSwitcherAction {
    public static final Key<SwitcherPanel> SWITCHER_KEY = Key.create((String)"SWITCHER_KEY");

    public Switcher() {
        super(null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull @Nls String title2, boolean pinned, VirtualFile @Nullable [] vFiles) {
        Project project;
        if (e == null) {
            Switcher.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            Switcher.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        SwitcherPanel switcher = (SwitcherPanel)SWITCHER_KEY.get((UserDataHolder)project);
        if (switcher != null && Objects.equals(switcher.myTitle, title2)) {
            return null;
        }
        InputEvent event = e.getInputEvent();
        return new SwitcherPanel(project, title2, event, pinned ? Boolean.valueOf(vFiles != null) : null, event == null || !event.isShiftDown());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/Switcher";
        objectArray[2] = "createAndShowSwitcher";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SwitcherScrollPane
    extends JBScrollPane {
        private int width;

        SwitcherScrollPane(@NotNull Component view, boolean noBorder) {
            if (view == null) {
                SwitcherScrollPane.$$$reportNull$$$0(0);
            }
            super(view, 20, noBorder ? 30 : 31);
            this.setBorder((Border)(noBorder ? JBUI.Borders.empty() : JBUI.Borders.customLineRight((Color)JBUI.CurrentTheme.Popup.separatorColor())));
            this.setViewportBorder((Border)JBUI.Borders.empty());
            this.setMinimumSize((Dimension)JBUI.size((int)(noBorder ? 250 : 0), (int)100));
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (this.isPreferredSizeSet()) {
                return size;
            }
            Dimension min = super.getMinimumSize();
            if (size.width < min.width) {
                size.width = min.width;
            }
            if (size.height < min.height) {
                size.height = min.height;
            }
            if (31 != this.getHorizontalScrollBarPolicy()) {
                return size;
            }
            size.width = this.width = Math.max(size.width, this.width);
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/ide/actions/Switcher$SwitcherScrollPane", "<init>"));
        }
    }

    static class FileInfo
    extends Pair<VirtualFile, EditorWindow> {
        final Project myProject;
        private String myNameForRendering;

        FileInfo(VirtualFile first, EditorWindow second, Project project) {
            super((Object)first, (Object)second);
            this.myProject = project;
        }

        @NlsSafe
        String getNameForRendering() {
            if (this.myNameForRendering == null) {
                this.myNameForRendering = (String)SlowOperations.allowSlowOperations(() -> EditorTabPresentationUtil.getUniqueEditorTabTitle(this.myProject, (VirtualFile)this.first));
            }
            return this.myNameForRendering;
        }
    }

    public static class SwitcherPanel
    extends BorderLayoutPanel
    implements DataProvider,
    QuickSearchComponent,
    Disposable {
        static final int SWITCHER_ELEMENTS_LIMIT = 30;
        final JBPopup myPopup;
        final JBList<SwitcherListItem> toolWindows;
        final JBList<SwitcherVirtualFile> files;
        final JCheckBox cbShowOnlyEditedFiles;
        final JLabel pathLabel;
        final Project project;
        final boolean recent;
        final boolean pinned;
        final SwitcherKeyReleaseListener onKeyRelease;
        final SwitcherSpeedSearch mySpeedSearch;
        final String myTitle;
        private JBPopup myHint;
        final ClickListener myClickListener;

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                SwitcherPanel.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.project;
            }
            if (PlatformCoreDataKeys.SELECTED_ITEM.is(dataId)) {
                if (this.files.isSelectionEmpty()) {
                    return null;
                }
                SwitcherVirtualFile item = (SwitcherVirtualFile)ContainerUtil.getOnlyItem((Collection)this.files.getSelectedValuesList());
                return item == null ? null : item.getFile();
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                if (this.files.isSelectionEmpty()) {
                    return null;
                }
                VirtualFile[] array2 = (VirtualFile[])ContainerUtil.map2Array((Collection)this.files.getSelectedValuesList(), VirtualFile.class, SwitcherVirtualFile::getFile);
                return array2.length > 0 ? array2 : null;
            }
            return null;
        }

        SwitcherPanel(@NotNull Project project, @NotNull @Nls String title2, @Nullable InputEvent event, @Nullable Boolean onlyEditedFiles, boolean forward) {
            boolean showMnemonics;
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(1);
            }
            if (title2 == null) {
                SwitcherPanel.$$$reportNull$$$0(2);
            }
            this.pathLabel = HintUtil.createAdComponent(" ", JBUI.Borders.compound((Border)JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.Advertiser.borderColor()), (Border)JBUI.CurrentTheme.Advertiser.border()), 2);
            this.myClickListener = new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pinned && (e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                        return false;
                    }
                    Object source = e.getSource();
                    if (source instanceof JList) {
                        JList jList = (JList)source;
                        if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                            jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                        }
                        if (jList.getSelectedIndex() != -1) {
                            this.navigate(e);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$1", "onClick"));
                }
            };
            this.project = project;
            this.recent = onlyEditedFiles != null;
            this.onKeyRelease = new SwitcherKeyReleaseListener(this.recent ? null : event, this::navigate);
            this.pinned = !this.onKeyRelease.isEnabled();
            boolean onlyEdited = Boolean.TRUE.equals(onlyEditedFiles);
            this.myTitle = title2;
            this.mySpeedSearch = this.recent && Registry.is((String)"ide.recent.files.speed.search") ? new SwitcherSpeedSearch(this) : null;
            this.cbShowOnlyEditedFiles = !this.recent || !Experiments.getInstance().isFeatureEnabled("recent.and.edited.files.together") ? null : new JCheckBox(IdeBundle.message((String)"recent.files.checkbox.label", (Object[])new Object[0]));
            SwitcherListRenderer renderer2 = new SwitcherListRenderer(this);
            List<SwitcherToolWindow> windows = renderer2.getToolWindows();
            boolean bl = showMnemonics = this.mySpeedSearch == null || Registry.is((String)"ide.recent.files.tool.window.mnemonics");
            if (showMnemonics || Registry.is((String)"ide.recent.files.tool.window.sort.by.mnemonics")) {
                this.updateMnemonics(windows, showMnemonics);
            }
            this.registerAction((Consumer<InputEvent>)((Consumer)this::navigate), "ENTER");
            this.registerAction((Consumer<InputEvent>)((Consumer)this::hideSpeedSearchOrPopup), "ESCAPE");
            if (this.pinned) {
                this.registerAction((Consumer<InputEvent>)((Consumer)this::closeTabOrToolWindow), ActionUtil.getShortcutSet((String)"DeleteRecentFiles"));
                this.registerAction((Consumer<InputEvent>)((Consumer)this::navigate), ActionUtil.getShortcutSet((String)"OpenElementInNewWindow"));
                this.registerAction((Consumer<InputEvent>)((Consumer)this::navigate), ActionUtil.getShortcutSet((String)"OpenInRightSplit"));
            } else {
                this.registerAction((Consumer<InputEvent>)((Consumer)this::closeTabOrToolWindow), "DELETE", "BACK_SPACE");
                this.registerSwingAction("selectPreviousRow", "KP_UP", "UP");
                this.registerSwingAction("selectNextRow", "KP_DOWN", "DOWN");
                this.registerSwingAction("selectPreviousColumn", "KP_LEFT", "LEFT");
                this.registerSwingAction("selectNextColumn", "KP_RIGHT", "RIGHT");
                this.registerSwingAction("scrollUp", "PAGE_UP");
                this.registerSwingAction("scrollDown", "PAGE_DOWN");
            }
            if (this.mySpeedSearch == null || Registry.is((String)"ide.recent.files.tool.window.mnemonics")) {
                windows.forEach(this::registerToolWindowAction);
            }
            this.setBorder((Border)JBUI.Borders.empty());
            this.setBackground(JBColor.background());
            this.pathLabel.putClientProperty(SwingTextTrimmer.KEY, (Object)SwingTextTrimmer.THREE_DOTS_AT_LEFT);
            JPanel header2 = new JPanel((LayoutManager)new HorizontalLayout(5));
            header2.setBackground(JBUI.CurrentTheme.Popup.headerBackground((boolean)false));
            header2.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
            header2.add("LEFT", RelativeFont.BOLD.install((Component)new JLabel(title2)));
            if (this.cbShowOnlyEditedFiles != null) {
                this.cbShowOnlyEditedFiles.setOpaque(false);
                this.cbShowOnlyEditedFiles.setFocusable(false);
                this.cbShowOnlyEditedFiles.setSelected(onlyEdited);
                this.cbShowOnlyEditedFiles.addItemListener(this::updateFilesByCheckBox);
                header2.add("RIGHT", this.cbShowOnlyEditedFiles);
                WindowMoveListener moveListener2 = new WindowMoveListener(header2);
                header2.addMouseListener(moveListener2);
                header2.addMouseMotionListener(moveListener2);
                ShortcutSet shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"SwitcherRecentEditedChangedToggleCheckBox");
                if (shortcuts.getShortcuts().length > 0) {
                    JLabel label2 = new JLabel(KeymapUtil.getShortcutsText((Shortcut[])shortcuts.getShortcuts()));
                    label2.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
                    header2.add("RIGHT", label2);
                }
            }
            CollectionListModel twModel = new CollectionListModel((Object[])new SwitcherListItem[0]);
            windows.stream().sorted((o1, o2) -> {
                String m1 = o1.getMnemonic();
                String m2 = o2.getMnemonic();
                return m1 == null ? (m2 == null ? 0 : 1) : (m2 == null ? -1 : m1.compareTo(m2));
            }).forEach(arg_0 -> ((CollectionListModel)twModel).add(arg_0));
            if (this.pinned && !windows.isEmpty()) {
                twModel.add((Object)new SwitcherRecentLocations(this));
            }
            if (!showMnemonics) {
                windows.forEach(window -> window.setMnemonic(null));
            }
            this.toolWindows = new JBList((ListModel)(this.mySpeedSearch != null ? this.mySpeedSearch.wrap(twModel) : twModel));
            this.toolWindows.setVisibleRowCount(this.toolWindows.getItemsCount());
            this.toolWindows.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.toolWindows.setSelectionMode(this.pinned ? 2 : 0);
            this.toolWindows.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"recent.files.accessible.tool.window.list", (Object[])new Object[0]));
            this.toolWindows.setEmptyText(IdeBundle.message((String)"recent.files.tool.window.list.empty.text", (Object[])new Object[0]));
            this.toolWindows.setCellRenderer((ListCellRenderer)renderer2);
            this.toolWindows.putClientProperty((Object)RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, (Object)true);
            this.toolWindows.addKeyListener((KeyListener)this.onKeyRelease);
            ScrollingUtil.installActions(this.toolWindows);
            ListHoverListener.DEFAULT.addTo(this.toolWindows);
            this.myClickListener.installOn(this.toolWindows);
            List<FileInfo> filesToShow = SwitcherPanel.getFilesToShow(project, SwitcherPanel.collectFiles(project, onlyEdited), this.toolWindows.getItemsCount(), this.recent);
            CollectionListModel filesModel = new CollectionListModel(SwitcherPanel.wrap(filesToShow));
            ListSelectionListener filesSelectionListener = new ListSelectionListener(){

                @NlsSafe
                private String getTitle2Text(@Nullable String fullText) {
                    if (StringUtil.isEmpty((String)fullText)) {
                        return " ";
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    PopupUpdateProcessorBase popupUpdater;
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.updatePathLabel();
                    PopupUpdateProcessorBase popupUpdateProcessorBase = popupUpdater = myHint == null || !myHint.isVisible() ? null : (PopupUpdateProcessorBase)myHint.getUserData(PopupUpdateProcessorBase.class);
                    if (popupUpdater != null) {
                        popupUpdater.updatePopup(CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext((Component)((Object)this))));
                    }
                }

                private void updatePathLabel() {
                    List values2 = this.getSelectedList().getSelectedValuesList();
                    if (values2 != null && values2.size() == 1) {
                        pathLabel.setText(this.getTitle2Text(((SwitcherListItem)values2.get(0)).getStatusText()));
                    } else {
                        pathLabel.setText(" ");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$2", "valueChanged"));
                }
            };
            this.files = JBListWithOpenInRightSplit.createListWithOpenInRightSplitter(this.mySpeedSearch != null ? this.mySpeedSearch.wrap(filesModel) : filesModel, null, true);
            this.files.setVisibleRowCount(this.files.getItemsCount());
            this.files.setSelectionMode(this.pinned ? 2 : 0);
            this.files.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"recent.files.accessible.file.list", (Object[])new Object[0]));
            this.files.setEmptyText(IdeBundle.message((String)"recent.files.file.list.empty.text", (Object[])new Object[0]));
            this.toolWindows.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.setCellRenderer((ListCellRenderer)renderer2);
            this.files.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.files.addKeyListener((KeyListener)this.onKeyRelease);
            ScrollingUtil.installActions(this.files);
            ListHoverListener.DEFAULT.addTo(this.files);
            this.myClickListener.installOn(this.files);
            if (filesModel.getSize() > 0) {
                int selectionIndex = SwitcherPanel.getFilesSelectedIndex(project, this.files, forward);
                this.files.setSelectedIndex(selectionIndex > -1 ? selectionIndex : 0);
            } else {
                ScrollingUtil.ensureSelectionExists(this.toolWindows);
            }
            this.addToTop(header2);
            this.addToBottom(this.pathLabel);
            this.addToCenter((Component)((Object)new SwitcherScrollPane((Component)this.files, true)));
            if (!windows.isEmpty()) {
                this.addToLeft((Component)((Object)new SwitcherScrollPane((Component)this.toolWindows, false)));
            }
            if (this.mySpeedSearch != null) {
                KeyListener listener2 = (KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners());
                this.files.addKeyListener(listener2);
                this.toolWindows.addKeyListener(listener2);
            }
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this), !this.files.isEmpty() || this.toolWindows.isEmpty() ? this.files : this.toolWindows).setResizable(this.pinned).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(this.pinned).setDimensionServiceKey((Project)(this.pinned ? project : null), this.pinned ? "SwitcherDM" : null, false).setCancelKeyEnabled(false).createPopup();
            Disposer.register((Disposable)this.myPopup, (Disposable)this);
            if (this.pinned) {
                this.myPopup.setMinimumSize((Dimension)new JBDimension(windows.isEmpty() ? 300 : 500, 200));
            }
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            new SwitcherListFocusAction((JList<?>)this.files, (JList<?>)this.toolWindows, "selectPreviousColumn");
            new SwitcherListFocusAction((JList<?>)this.toolWindows, (JList<?>)this.files, "selectNextColumn");
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            SwitcherPanel old = (SwitcherPanel)project.getUserData(SWITCHER_KEY);
            if (old != null) {
                old.cancel();
            }
            project.putUserData(SWITCHER_KEY, (Object)this);
            this.myPopup.showCenteredInCurrentWindow(project);
        }

        public void dispose() {
            this.project.putUserData(SWITCHER_KEY, null);
        }

        boolean isOnlyEditedFilesShown() {
            return this.cbShowOnlyEditedFiles != null && this.cbShowOnlyEditedFiles.isSelected();
        }

        boolean isSpeedSearchPopupActive() {
            return this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive();
        }

        public void registerHint(@NotNull JBPopup h) {
            if (h == null) {
                SwitcherPanel.$$$reportNull$$$0(3);
            }
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        @NotNull
        static List<VirtualFile> collectFiles(@NotNull Project project, boolean onlyEdited) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(4);
            }
            return onlyEdited ? IdeDocumentHistory.getInstance(project).getChangedFiles() : SwitcherPanel.getRecentFiles(project);
        }

        @NotNull
        static List<SwitcherVirtualFile> wrap(@NotNull List<FileInfo> list2) {
            if (list2 == null) {
                SwitcherPanel.$$$reportNull$$$0(5);
            }
            List list3 = ContainerUtil.map(list2, info2 -> {
                SwitcherVirtualFile svf = new SwitcherVirtualFile(info2.myProject, (VirtualFile)info2.first, (EditorWindow)info2.second);
                svf.setMainText(info2.getNameForRendering());
                return svf;
            });
            if (list3 == null) {
                SwitcherPanel.$$$reportNull$$$0(6);
            }
            return list3;
        }

        @NotNull
        static List<FileInfo> getFilesToShow(@NotNull Project project, @NotNull List<? extends VirtualFile> filesForInit, int toolWindowsCount, boolean pinned) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(7);
            }
            if (filesForInit == null) {
                SwitcherPanel.$$$reportNull$$$0(8);
            }
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            ArrayList<FileInfo> filesData = new ArrayList<FileInfo>();
            ArrayList<FileInfo> editors2 = new ArrayList<FileInfo>();
            LinkedHashSet<VirtualFile> addedFiles = new LinkedHashSet<VirtualFile>();
            if (!pinned) {
                for (Pair pair : editorManager.getSelectionHistory()) {
                    editors2.add(new FileInfo((VirtualFile)pair.first, (EditorWindow)pair.second, project));
                }
            }
            if (!pinned) {
                for (FileInfo fileInfo : editors2) {
                    addedFiles.add((VirtualFile)fileInfo.first);
                    filesData.add(fileInfo);
                    if (filesData.size() < 30) continue;
                    break;
                }
            }
            if (filesData.size() <= 1) {
                if (!filesForInit.isEmpty()) {
                    int editorsFilesCount = (int)editors2.stream().map(info2 -> (VirtualFile)info2.first).distinct().count();
                    int n = Math.max(editorsFilesCount, filesForInit.size());
                    int minIndex = pinned ? 0 : filesForInit.size() - Math.min(toolWindowsCount, n);
                    for (int i2 = filesForInit.size() - 1; i2 >= minIndex; --i2) {
                        FileInfo info3 = new FileInfo(filesForInit.get(i2), null, project);
                        boolean add2 = true;
                        if (pinned) {
                            for (FileInfo fileInfo : filesData) {
                                if (!((VirtualFile)fileInfo.first).equals(info3.first)) continue;
                                add2 = false;
                                break;
                            }
                        }
                        if (!add2 || !addedFiles.add((VirtualFile)info3.first)) continue;
                        filesData.add(info3);
                    }
                }
                if (editors2.size() == 1 && (filesData.isEmpty() || !((VirtualFile)((FileInfo)((Object)editors2.get(0))).getFirst()).equals(((FileInfo)((Object)filesData.get(0))).getFirst())) && addedFiles.add((VirtualFile)((FileInfo)((Object)editors2.get((int)0))).first)) {
                    filesData.add(0, (FileInfo)((Object)editors2.get(0)));
                }
            }
            ArrayList<FileInfo> arrayList = filesData;
            if (arrayList == null) {
                SwitcherPanel.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        static int getFilesSelectedIndex(Project project, JList<?> filesList, boolean forward) {
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            EditorWindow currentWindow = editorManager.getCurrentWindow();
            VirtualFile currentFile = currentWindow != null ? currentWindow.getSelectedFile() : null;
            ListModel<?> model2 = filesList.getModel();
            if (forward) {
                for (int i2 = 0; i2 < model2.getSize(); ++i2) {
                    if (SwitcherPanel.isTheSameTab(currentWindow, currentFile, model2.getElementAt(i2))) continue;
                    return i2;
                }
            } else {
                for (int i3 = model2.getSize() - 1; i3 >= 0; --i3) {
                    if (SwitcherPanel.isTheSameTab(currentWindow, currentFile, model2.getElementAt(i3))) continue;
                    return i3;
                }
            }
            return -1;
        }

        private static boolean isTheSameTab(EditorWindow currentWindow, VirtualFile currentFile, Object element2) {
            if (element2 instanceof FileInfo) {
                return SwitcherPanel.isTheSameTab(currentWindow, currentFile, (FileInfo)((Object)element2));
            }
            SwitcherVirtualFile svf = element2 instanceof SwitcherVirtualFile ? (SwitcherVirtualFile)element2 : null;
            return svf != null && svf.getFile().equals(currentFile) && (svf.getWindow() == null || svf.getWindow().equals(currentWindow));
        }

        private static boolean isTheSameTab(EditorWindow currentWindow, VirtualFile currentFile, FileInfo fileInfo) {
            return ((VirtualFile)fileInfo.first).equals(currentFile) && (fileInfo.second == null || ((EditorWindow)fileInfo.second).equals(currentWindow));
        }

        @NotNull
        private static List<VirtualFile> getRecentFiles(@NotNull Project project) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(10);
            }
            List<VirtualFile> recentFiles = EditorHistoryManager.getInstance(project).getFileList();
            Object[] openFiles = FileEditorManager.getInstance((Project)project).getOpenFiles();
            HashSet<VirtualFile> recentFilesSet = new HashSet<VirtualFile>(recentFiles);
            HashSet openFilesSet = ContainerUtil.newHashSet((Object[])openFiles);
            int index2 = 0;
            for (int i2 = 0; i2 < recentFiles.size(); ++i2) {
                if (!openFilesSet.contains(recentFiles.get(i2))) continue;
                index2 = i2;
                break;
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(recentFiles);
            result2.addAll(index2, ContainerUtil.filter((Object[])openFiles, it -> !recentFilesSet.contains(it)));
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                SwitcherPanel.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private void updateMnemonics(@NotNull List<SwitcherToolWindow> windows, boolean showMnemonics) {
            if (windows == null) {
                SwitcherPanel.$$$reportNull$$$0(12);
            }
            HashMap<String, SwitcherToolWindow> keymap2 = new HashMap<String, SwitcherToolWindow>(windows.size());
            keymap2.put(this.onKeyRelease.getForbiddenMnemonic(), null);
            this.addForbiddenMnemonics(keymap2, "SwitcherForward");
            this.addForbiddenMnemonics(keymap2, "SwitcherBackward");
            this.addForbiddenMnemonics(keymap2, "EditorUp");
            this.addForbiddenMnemonics(keymap2, "EditorDown");
            this.addForbiddenMnemonics(keymap2, "EditorLeft");
            this.addForbiddenMnemonics(keymap2, "EditorRight");
            ArrayList<SwitcherToolWindow> otherTW = new ArrayList<SwitcherToolWindow>();
            for (SwitcherToolWindow window : windows) {
                int index2 = ActivateToolWindowAction.getMnemonicForToolWindow(window.getWindow().getId());
                if (index2 >= 48 && index2 <= 57 && SwitcherPanel.addShortcut(keymap2, window, SwitcherPanel.getIndexShortcut(index2 - 48))) continue;
                otherTW.add(window);
            }
            if (!showMnemonics && !Registry.is((String)"ide.recent.files.tool.window.sort.by.automatic.mnemonics")) {
                return;
            }
            int i2 = 0;
            for (SwitcherToolWindow window : otherTW) {
                if (SwitcherPanel.addSmartShortcut(window, keymap2)) continue;
                while (!SwitcherPanel.addShortcut(keymap2, window, SwitcherPanel.getIndexShortcut(i2))) {
                    ++i2;
                }
                ++i2;
            }
        }

        private void addForbiddenMnemonics(@NotNull Map<String, SwitcherToolWindow> keymap2, @NotNull String actionId) {
            if (keymap2 == null) {
                SwitcherPanel.$$$reportNull$$$0(13);
            }
            if (actionId == null) {
                SwitcherPanel.$$$reportNull$$$0(14);
            }
            for (Shortcut shortcut : ActionUtil.getShortcutSet((String)actionId).getShortcuts()) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
                keymap2.put(this.onKeyRelease.getForbiddenMnemonic(keyboardShortcut.getFirstKeyStroke()), null);
            }
        }

        private static boolean addShortcut(Map<String, SwitcherToolWindow> keymap2, SwitcherToolWindow window, String shortcut) {
            if (keymap2.containsKey(shortcut)) {
                return false;
            }
            keymap2.put(shortcut, window);
            window.setMnemonic(shortcut);
            return true;
        }

        private static boolean addSmartShortcut(SwitcherToolWindow window, Map<String, SwitcherToolWindow> keymap2) {
            String title2 = window.getMainText();
            if (StringUtil.isEmpty((String)title2)) {
                return false;
            }
            for (int i2 = 0; i2 < title2.length(); ++i2) {
                char c = title2.charAt(i2);
                if (!Character.isUpperCase(c) || !SwitcherPanel.addShortcut(keymap2, window, String.valueOf(c))) continue;
                return true;
            }
            return false;
        }

        private static String getIndexShortcut(int index2) {
            return StringUtil.toUpperCase((String)Integer.toString(index2, index2 + 1));
        }

        private void closeTabOrToolWindow(@Nullable InputEvent event) {
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
                this.mySpeedSearch.updateEnteredPrefix();
                return;
            }
            JBList<? extends SwitcherListItem> selectedList = this.getSelectedList();
            int[] selected2 = selectedList.getSelectedIndices();
            Arrays.sort(selected2);
            int selectedIndex = 0;
            for (int i2 = selected2.length - 1; i2 >= 0; --i2) {
                selectedIndex = selected2[i2];
                SwitcherListItem item = (SwitcherListItem)selectedList.getModel().getElementAt(selectedIndex);
                if (item instanceof SwitcherVirtualFile) {
                    SwitcherVirtualFile svf = (SwitcherVirtualFile)item;
                    VirtualFile virtualFile2 = svf.getFile();
                    FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    EditorWindow wnd = SwitcherPanel.findAppropriateWindow(svf.getWindow());
                    if (wnd == null) {
                        editorManager.closeFile(virtualFile2, false, false);
                    } else {
                        editorManager.closeFile(virtualFile2, wnd, false);
                    }
                    ListUtil.removeItem((ListModel)this.files.getModel(), (int)selectedIndex);
                    if (svf.getWindow() != null) continue;
                    EditorHistoryManager.getInstance(this.project).removeFile(virtualFile2);
                    continue;
                }
                if (item == null) continue;
                item.close(this);
            }
            if (this.files == selectedList) {
                int size = this.files.getItemsCount();
                if (size > 0) {
                    int index2 = Math.min(Math.max(selectedIndex, 0), size - 1);
                    this.files.setSelectedIndex(index2);
                    this.files.ensureIndexIsVisible(index2);
                } else {
                    this.toolWindows.requestFocusInWindow();
                }
            }
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        private void hideSpeedSearchOrPopup(@Nullable InputEvent event) {
            if (this.mySpeedSearch == null || !this.mySpeedSearch.isPopupActive()) {
                this.cancel();
            } else {
                this.mySpeedSearch.hidePopup();
            }
        }

        public void go(boolean forward) {
            JBList<? extends SwitcherListItem> selected2;
            JBList<? extends SwitcherListItem> list2 = selected2 = this.getSelectedList();
            int index2 = list2.getSelectedIndex();
            index2 = forward ? ++index2 : --index2;
            if (forward && index2 >= list2.getItemsCount() || !forward && index2 < 0) {
                if (!this.toolWindows.isEmpty() && !this.files.isEmpty()) {
                    list2 = list2 == this.files ? this.toolWindows : this.files;
                }
                index2 = forward ? 0 : list2.getItemsCount() - 1;
            }
            list2.setSelectedIndex(index2);
            list2.ensureIndexIsVisible(index2);
            if (selected2 != list2) {
                IdeFocusManager.findInstanceByComponent(list2).requestFocus(list2, true);
            }
        }

        public void goForward() {
            this.go(true);
        }

        public void goBack() {
            this.go(false);
        }

        public JBList<? extends SwitcherListItem> getSelectedList() {
            return this.getSelectedList(this.files);
        }

        @Nullable
        JBList<? extends SwitcherListItem> getSelectedList(@Nullable JBList<? extends SwitcherListItem> preferable) {
            return this.files.hasFocus() ? this.files : (this.toolWindows.hasFocus() ? this.toolWindows : preferable);
        }

        private void updateFilesByCheckBox(@NotNull ItemEvent event) {
            if (event == null) {
                SwitcherPanel.$$$reportNull$$$0(15);
            }
            boolean onlyEdited = 1 == event.getStateChange();
            boolean listWasSelected = this.files.getSelectedIndex() != -1;
            List<FileInfo> filesToShow = SwitcherPanel.getFilesToShow(this.project, SwitcherPanel.collectFiles(this.project, onlyEdited), this.toolWindows.getItemsCount(), this.recent);
            ListModel model2 = this.files.getModel();
            ListUtil.removeAllItems((ListModel)model2);
            ListUtil.addAllItems((ListModel)model2, SwitcherPanel.wrap(filesToShow));
            int selectionIndex = SwitcherPanel.getFilesSelectedIndex(this.project, this.files, true);
            if (selectionIndex > -1 && listWasSelected) {
                this.files.setSelectedIndex(selectionIndex);
            }
            this.files.revalidate();
            this.files.repaint();
            ListModel toolWindowsModel = this.toolWindows.getModel();
            if (toolWindowsModel instanceof NameFilteringListModel) {
                ((NameFilteringListModel)toolWindowsModel).refilter();
            }
            this.toolWindows.repaint();
        }

        void navigate(InputEvent e) {
            FileEditorManagerImpl.OpenMode mode = e != null ? FileEditorManagerImpl.getOpenMode(e) : FileEditorManagerImpl.OpenMode.DEFAULT;
            List values2 = this.getSelectedList().getSelectedValuesList();
            String searchQuery = this.mySpeedSearch != null ? this.mySpeedSearch.getEnteredPrefix() : null;
            this.cancel();
            if (values2.isEmpty()) {
                this.tryToOpenFileSearch(e, searchQuery);
            } else if (values2.get(0) instanceof SwitcherVirtualFile) {
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> {
                    FileEditorManagerImpl manager2 = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    EditorWindow splitWindow = null;
                    for (Object value2 : values2) {
                        if (!(value2 instanceof SwitcherVirtualFile)) continue;
                        SwitcherVirtualFile item = (SwitcherVirtualFile)value2;
                        VirtualFile file2 = item.getFile();
                        if (mode == FileEditorManagerImpl.OpenMode.RIGHT_SPLIT) {
                            if (splitWindow == null) {
                                splitWindow = OpenInRightSplitAction.Companion.openInRightSplit(this.project, file2, null, true);
                            } else {
                                manager2.openFileWithProviders(file2, true, splitWindow);
                            }
                        }
                        if (mode == FileEditorManagerImpl.OpenMode.NEW_WINDOW) {
                            manager2.openFileInNewWindow(file2);
                            continue;
                        }
                        if (item.getWindow() != null) {
                            EditorWindow wnd = SwitcherPanel.findAppropriateWindow(item.getWindow());
                            if (wnd == null) continue;
                            manager2.openFileImpl2(wnd, file2, true);
                            manager2.addSelectionRecord(file2, wnd);
                            continue;
                        }
                        UISettingsState settings = UISettings.getInstance().getState();
                        boolean oldValue = settings.getReuseNotModifiedTabs();
                        settings.setReuseNotModifiedTabs(false);
                        manager2.openFile(file2, true, true);
                        if (LightEdit.owns((Project)this.project)) {
                            LightEditFeatureUsagesUtil.logFileOpen(this.project, LightEditFeatureUsagesUtil.OpenPlace.RecentFiles);
                        }
                        if (!oldValue) continue;
                        CommandProcessor.getInstance().executeCommand(this.project, () -> settings.setReuseNotModifiedTabs(true), "", null);
                    }
                }, ModalityState.current());
            } else if (values2.get(0) instanceof SwitcherListItem) {
                SwitcherListItem item = (SwitcherListItem)values2.get(0);
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> item.navigate(this, mode), ModalityState.current());
            }
        }

        private void tryToOpenFileSearch(InputEvent e, String fileName) {
            AnAction gotoFile = ActionManager.getInstance().getAction("GotoFile");
            if (gotoFile != null && !StringUtil.isEmpty((String)fileName)) {
                this.cancel();
                AnAction action2 = gotoFile;
                ApplicationManager.getApplication().invokeLater(() -> DataManager.getInstance().getDataContextFromFocus().doWhenDone(context2 -> {
                    DataContext dataContext = dataId -> {
                        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                            return fileName;
                        }
                        return context2.getData(dataId);
                    };
                    AnActionEvent event = new AnActionEvent(e, dataContext, "EditorPopup", new PresentationFactory().getPresentation(action2), ActionManager.getInstance(), 0);
                    action2.actionPerformed(event);
                }), ModalityState.current());
            }
        }

        private void registerAction(@NotNull Consumer<InputEvent> action2, String ... keys2) {
            if (action2 == null) {
                SwitcherPanel.$$$reportNull$$$0(16);
            }
            if (keys2 == null) {
                SwitcherPanel.$$$reportNull$$$0(17);
            }
            this.registerAction(action2, (ShortcutSet)this.onKeyRelease.getShortcuts(keys2));
        }

        private void registerAction(@NotNull Consumer<InputEvent> action2, @NotNull ShortcutSet shortcuts) {
            if (action2 == null) {
                SwitcherPanel.$$$reportNull$$$0(18);
            }
            if (shortcuts == null) {
                SwitcherPanel.$$$reportNull$$$0(19);
            }
            if (shortcuts.getShortcuts().length == 0) {
                return;
            }
            LightEditActionFactory.create(event -> {
                if (this.myPopup != null && this.myPopup.isVisible()) {
                    action2.consume((Object)event.getInputEvent());
                }
            }).registerCustomShortcutSet(shortcuts, (JComponent)((Object)this), (Disposable)this);
        }

        private void registerSwingAction(@NonNls @NotNull String id2, String ... keys2) {
            if (id2 == null) {
                SwitcherPanel.$$$reportNull$$$0(20);
            }
            if (keys2 == null) {
                SwitcherPanel.$$$reportNull$$$0(21);
            }
            this.registerAction((Consumer<InputEvent>)((Consumer)event -> SwingActionDelegate.performAction(id2, this.getSelectedList(null))), keys2);
        }

        private void registerToolWindowAction(@NotNull SwitcherToolWindow window) {
            String mnemonic;
            if (window == null) {
                SwitcherPanel.$$$reportNull$$$0(22);
            }
            if (!StringUtil.isEmpty((String)(mnemonic = window.getMnemonic()))) {
                this.registerAction((Consumer<InputEvent>)((Consumer)event -> {
                    this.cancel();
                    window.getWindow().activate(null, true, true);
                }), (ShortcutSet)(this.mySpeedSearch == null ? this.onKeyRelease.getShortcuts(mnemonic) : (SystemInfo.isMac ? CustomShortcutSet.fromString((String[])new String[]{"alt " + mnemonic, "alt control " + mnemonic}) : CustomShortcutSet.fromString((String[])new String[]{"alt " + mnemonic}))));
            }
        }

        @Nullable
        private static EditorWindow findAppropriateWindow(@Nullable EditorWindow window) {
            if (window == null) {
                return null;
            }
            if (UISettings.getInstance().getEditorTabPlacement() == 0) {
                return window.getOwner().getCurrentWindow();
            }
            Object[] windows = window.getOwner().getWindows();
            return ArrayUtil.contains((Object)window, (Object[])windows) ? window : (windows.length > 0 ? windows[0] : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 6: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filesForInit";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windows";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keymap";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 17: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortcuts";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesToShow";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecentFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "registerHint";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFiles";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
                case 6: 
                case 9: 
                case 11: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesToShow";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecentFiles";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "updateMnemonics";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addForbiddenMnemonics";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFilesByCheckBox";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "registerAction";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "registerSwingAction";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "registerToolWindowAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

