/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.ide.actions.SwitcherRenderingKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0016R\u0018\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\f0\b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0018\u00010\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001e\u0010\u0016\u001a\f0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/ide/actions/SwitcherToolWindow;", "Lcom/intellij/ide/actions/SwitcherListItem;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "shortcut", "", "(Lcom/intellij/openapi/wm/ToolWindow;Z)V", "actionId", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "mainText", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "getMainText", "()Ljava/lang/String;", "mnemonic", "getMnemonic", "setMnemonic", "(Ljava/lang/String;)V", "shortcutText", "Lcom/intellij/openapi/util/NlsSafe;", "getShortcutText", "statusText", "Lorg/jetbrains/annotations/Nls;", "getStatusText", "getWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "close", "", "switcher", "Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "navigate", "mode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "prepareMainRenderer", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "intellij.platform.ide.impl"})
public final class SwitcherToolWindow
implements SwitcherListItem {
    private final String actionId;
    @Nullable
    private String mnemonic;
    @NotNull
    private final String mainText;
    @NotNull
    private final String statusText;
    @Nullable
    private final String shortcutText;
    @NotNull
    private final ToolWindow window;

    @Override
    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(@Nullable String string) {
        this.mnemonic = string;
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.mainText;
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return this.shortcutText;
    }

    @Override
    public void navigate(@NotNull Switcher.SwitcherPanel switcher, @NotNull FileEditorManagerImpl.OpenMode mode) {
        ToolWindowManagerImpl manager2;
        Intrinsics.checkNotNullParameter((Object)switcher, (String)"switcher");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Project project = switcher.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"switcher.project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        if (!(toolWindowManager instanceof ToolWindowManagerImpl)) {
            toolWindowManager = null;
        }
        ToolWindowManagerImpl toolWindowManagerImpl = manager2 = (ToolWindowManagerImpl)toolWindowManager;
        if (toolWindowManagerImpl != null) {
            String string = this.window.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"window.id");
            boolean bl = switcher.isSpeedSearchPopupActive();
            toolWindowManagerImpl.activateToolWindow(string, null, true, bl ? ToolWindowEventSource.SwitcherSearch : ToolWindowEventSource.Switcher);
        } else {
            this.window.activate(null, true);
        }
    }

    @Override
    public void close(@NotNull Switcher.SwitcherPanel switcher) {
        ToolWindowManagerImpl manager2;
        Intrinsics.checkNotNullParameter((Object)switcher, (String)"switcher");
        Project project = switcher.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"switcher.project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        if (!(toolWindowManager instanceof ToolWindowManagerImpl)) {
            toolWindowManager = null;
        }
        ToolWindowManagerImpl toolWindowManagerImpl = manager2 = (ToolWindowManagerImpl)toolWindowManager;
        if (toolWindowManagerImpl != null) {
            String string = this.window.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"window.id");
            toolWindowManagerImpl.hideToolWindow(string, false, false, ToolWindowEventSource.CloseFromSwitcher);
        } else {
            this.window.hide();
        }
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component2, boolean selected2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
        Icon icon2 = this.window.getIcon();
        if (icon2 == null) {
            icon2 = EmptyIcon.ICON_13;
        }
        component2.setIcon(RenderingUtil.getIcon((Icon)icon2, (boolean)selected2));
        component2.append(this.getMainText());
    }

    @NotNull
    public final ToolWindow getWindow() {
        return this.window;
    }

    public SwitcherToolWindow(@NotNull ToolWindow window, boolean shortcut) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.window = window;
        String string = ActivateToolWindowAction.getActionIdForToolWindow(this.window.getId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ActivateToolWindowAction\u2026dForToolWindow(window.id)");
        this.actionId = string;
        String string2 = this.window.getStripeTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"window.stripeTitle");
        this.mainText = string2;
        String string3 = IdeBundle.message((String)"recent.files.accessible.show.tool.window", (Object[])new Object[]{this.getMainText()});
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"recent.files.ac\u2026w.tool.window\", mainText)");
        this.statusText = string3;
        this.shortcutText = shortcut ? SwitcherRenderingKt.access$shortcutText(this.actionId) : null;
    }

    @Override
    public boolean getSeparatorAbove() {
        return SwitcherListItem.DefaultImpls.getSeparatorAbove(this);
    }

    @Override
    public void prepareExtraRenderer(@NotNull SimpleColoredComponent component2, boolean selected2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        SwitcherListItem.DefaultImpls.prepareExtraRenderer(this, component2, selected2);
    }
}

