/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Supplier<? extends Iterable<? extends JComponent>> myProducer;

    @NotNull
    public static DefaultActionGroup createToggleToolbarGroup(@NotNull Project project, @NotNull ToolWindow toolWindow2) {
        if (project == null) {
            ToggleToolbarAction.$$$reportNull$$$0(0);
        }
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(1);
        }
        return new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow2), ToggleToolbarAction.createToolWindowAction(toolWindow2, PropertiesComponent.getInstance((Project)project))});
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id2, @NotNull PropertiesComponent properties2, @NotNull Supplier<? extends Iterable<? extends JComponent>> components) {
        if (id2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(2);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(3);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(4);
        }
        return new ToggleToolbarAction(properties2, ToggleToolbarAction.getShowToolbarProperty(id2), components);
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow2, final @NotNull PropertiesComponent properties2) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(5);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(6);
        }
        ToggleToolbarAction.updateToolbarsVisibility(toolWindow2, properties2);
        toolWindow2.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                ContentManager contentManager2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                JComponent component2 = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible(Collections.singletonList(component2), ToggleToolbarAction.isToolbarVisible(toolWindow2, properties2));
                ContentManager contentManager3 = contentManager2 = component2 instanceof DataProvider ? (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)((Object)component2)) : null;
                if (contentManager2 != null) {
                    contentManager2.addContentManagerListener((ContentManagerListener)this);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getOperation() != ContentManagerEvent.ContentOperation.remove) {
                    ToggleToolbarAction.updateToolbarsVisibility(toolWindow2, properties2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return new ToggleToolbarAction(properties2, ToggleToolbarAction.getShowToolbarProperty(toolWindow2), () -> Collections.singletonList(toolWindow2.getContentManager().getComponent()));
    }

    public static void updateToolbarsVisibility(@NotNull ToolWindow toolWindow2, @NotNull PropertiesComponent properties2) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(7);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(8);
        }
        if (toolWindow2.getContentManagerIfCreated() != null) {
            ToggleToolbarAction.setToolbarVisible(Collections.singletonList(toolWindow2.getComponent()), ToggleToolbarAction.isToolbarVisible(toolWindow2, properties2));
        }
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow2, @NotNull PropertiesComponent properties2, @Nullable Boolean visible) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(9);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(10);
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow2, properties2) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow2), properties2, Collections.singletonList(toolWindow2.getComponent()), state);
    }

    public static void setToolbarVisible(@NotNull String id2, @NotNull PropertiesComponent properties2, @NotNull Iterable<? extends JComponent> components, @Nullable Boolean visible) {
        if (id2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(11);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(12);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(13);
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(id2, properties2) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id2), properties2, components, state);
    }

    public static void setToolbarVisible(@NotNull Iterable<? extends JComponent> roots2, boolean state) {
        if (roots2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(14);
        }
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(roots2)) {
            JComponent c = toolbar.getComponent();
            c.setVisible(state);
            Container parent = c.getParent();
            if (!(parent instanceof EditorHeaderComponent)) continue;
            parent.setVisible(state);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property2) {
        if (property2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(15);
        }
        return ToggleToolbarAction.isToolbarVisible(property2, PropertiesComponent.getInstance());
    }

    public static boolean isToolbarVisible(@NotNull String property2, @NotNull Project project) {
        if (property2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(16);
        }
        if (project == null) {
            ToggleToolbarAction.$$$reportNull$$$0(17);
        }
        return ToggleToolbarAction.isToolbarVisible(property2, PropertiesComponent.getInstance((Project)project));
    }

    public static boolean isToolbarVisible(@NotNull String property2, @NotNull PropertiesComponent properties2) {
        if (property2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(18);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(19);
        }
        return ToggleToolbarAction.isSelectedImpl(properties2, ToggleToolbarAction.getShowToolbarProperty(property2));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow2) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(20);
        }
        return ToggleToolbarAction.isToolbarVisible(toolWindow2, PropertiesComponent.getInstance());
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow2, @NotNull Project project) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(21);
        }
        if (project == null) {
            ToggleToolbarAction.$$$reportNull$$$0(22);
        }
        return ToggleToolbarAction.isToolbarVisible(toolWindow2, PropertiesComponent.getInstance((Project)project));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow2, @NotNull PropertiesComponent properties2) {
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(23);
        }
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(24);
        }
        return ToggleToolbarAction.isSelectedImpl(properties2, ToggleToolbarAction.getShowToolbarProperty(toolWindow2));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property2, @NotNull Supplier<? extends Iterable<? extends JComponent>> producer) {
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(25);
        }
        if (property2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(26);
        }
        if (producer == null) {
            ToggleToolbarAction.$$$reportNull$$$0(27);
        }
        super(ActionsBundle.messagePointer((String)"action.ShowToolbar.text", (Object[])new Object[0]));
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property2;
        this.myProducer = producer;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(28);
        }
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars(this.myProducer.get()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    public static boolean hasVisibleToolwindowToolbars(@NotNull ToolWindow toolWindow2) {
        Iterator<ActionToolbar> iterator2;
        if (toolWindow2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(29);
        }
        return (iterator2 = ToggleToolbarAction.iterateToolbars(Collections.singletonList(toolWindow2.getContentManager().getComponent())).iterator()).hasNext() && iterator2.next().getComponent().isVisible();
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(30);
        }
        return this.isSelected();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ToggleToolbarAction.$$$reportNull$$$0(31);
        }
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, this.myProducer.get(), state);
    }

    static void setToolbarVisibleImpl(@NotNull String property2, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<? extends JComponent> components, boolean visible) {
        if (property2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(32);
        }
        if (propertiesComponent == null) {
            ToggleToolbarAction.$$$reportNull$$$0(33);
        }
        if (components == null) {
            ToggleToolbarAction.$$$reportNull$$$0(34);
        }
        propertiesComponent.setValue(property2, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties2, @NotNull String property2) {
        if (properties2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(35);
        }
        if (property2 == null) {
            ToggleToolbarAction.$$$reportNull$$$0(36);
        }
        return properties2.getBoolean(property2, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        if (window == null) {
            ToggleToolbarAction.$$$reportNull$$$0(37);
        }
        return ToggleToolbarAction.getShowToolbarProperty("ToolWindow" + window.getStripeTitle());
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull @NonNls String s) {
        if (s == null) {
            ToggleToolbarAction.$$$reportNull$$$0(38);
        }
        String string = s + ".ShowToolbar";
        if (string == null) {
            ToggleToolbarAction.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<? extends JComponent> roots2) {
        JBIterable jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots2)).preOrderDfsTraversal().filter(ActionToolbar.class);
        if (jBIterable == null) {
            ToggleToolbarAction.$$$reportNull$$$0(40);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 19: 
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 13: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 26: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToggleToolbarAction";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowToolbarProperty";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateToolbars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToggleToolbarGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateToolbarsVisibility";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisible";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isToolbarVisible";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasVisibleToolwindowToolbars";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVisibleImpl";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedImpl";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getShowToolbarProperty";
                break;
            }
            case 39: 
            case 40: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OptionsGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        OptionsGroup(ToolWindow toolWindow2) {
            this.getTemplatePresentation().setText(IdeBundle.message((String)"group.view.options", (Object[])new Object[0]));
            this.setPopup(true);
            this.myToolWindow = toolWindow2;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            JComponent contentComponent;
            ContentManager contentManager2 = this.myToolWindow.getContentManagerIfCreated();
            Content selectedContent = contentManager2 == null ? null : contentManager2.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent == null ? null : selectedContent.getComponent();
            if (contentComponent == null || e == null) {
                if (EMPTY_ARRAY == null) {
                    OptionsGroup.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            UpdateSession session2 = Utils.getOrCreateUpdateSession(e);
            SmartList result2 = new SmartList();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(Collections.singletonList(contentComponent))) {
                JComponent c = toolbar.getComponent();
                if (c.isVisible() || !c.isValid()) continue;
                if (!result2.isEmpty() && !(ContainerUtil.getLastItem((List)result2) instanceof Separator)) {
                    result2.add(Separator.getInstance());
                }
                List actions2 = toolbar.getActions();
                for (AnAction action2 : actions2) {
                    if (action2 instanceof ToggleAction && !result2.contains(action2) && session2.presentation(action2).isVisible()) {
                        result2.add(action2);
                        continue;
                    }
                    if (!(action2 instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem((List)result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean popup2 = ContainerUtil.count((Iterable)result2, it -> !(it instanceof Separator)) > 3;
            this.setPopup(popup2);
            if (!popup2 && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                OptionsGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup", "getChildren"));
        }
    }
}

