/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.Urls;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WhatsNewAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            WhatsNewAction.$$$reportNull$$$0(0);
        }
        boolean available = ApplicationInfoEx.getInstanceEx().getWhatsNewUrl() != null;
        e.getPresentation().setEnabledAndVisible(available);
        if (available) {
            e.getPresentation().setText(IdeBundle.messagePointer((String)"whats.new.action.custom.text", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            e.getPresentation().setDescription(IdeBundle.messagePointer((String)"whats.new.action.custom.description", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String whatsNewUrl;
        if (e == null) {
            WhatsNewAction.$$$reportNull$$$0(1);
        }
        if ((whatsNewUrl = ApplicationInfoEx.getInstanceEx().getWhatsNewUrl()) == null) {
            throw new IllegalStateException();
        }
        Project project = e.getProject();
        if (project != null && JBCefApp.isSupported() && ApplicationInfoEx.getInstanceEx().isWhatsNewEligibleFor(1)) {
            WhatsNewAction.openWhatsNewPage(project, whatsNewUrl);
        } else {
            BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(whatsNewUrl));
        }
    }

    @ApiStatus.Internal
    public static boolean isAvailable() {
        return ApplicationInfoEx.getInstanceEx().isWhatsNewEligibleFor(2) || Boolean.getBoolean("whats.new.notification");
    }

    public static void openWhatsNewPage(@NotNull Project project, @NotNull String url) {
        if (project == null) {
            WhatsNewAction.$$$reportNull$$$0(2);
        }
        if (url == null) {
            WhatsNewAction.$$$reportNull$$$0(3);
        }
        String title2 = IdeBundle.message((String)"update.whats.new", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (!JBCefApp.isSupported()) {
            String notificationTitle = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            String name2 = ApplicationNamesInfo.getInstance().getFullProductName();
            String version2 = ApplicationInfo.getInstance().getShortVersion();
            String content2 = IdeBundle.message((String)"whats.new.notification.text", (Object[])new Object[]{name2, version2, url});
            UpdateChecker.getNotificationGroup().createNotification(notificationTitle, content2, NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER).notify(project);
        } else {
            boolean darkTheme = UIUtil.isUnderDarcula();
            Map<String, String> parameters2 = darkTheme ? Map.of("var", "embed", "theme", "dark") : Map.of("var", "embed");
            String embeddedUrl = Urls.newFromEncoded((String)url).addParameters(parameters2).toExternalForm();
            String timeoutContent = null;
            try (InputStream html = WhatsNewAction.class.getResourceAsStream("whatsNewTimeoutText.html");){
                if (html != null) {
                    timeoutContent = new String(StreamUtil.readBytes((InputStream)html), StandardCharsets.UTF_8).replace("__THEME__", darkTheme ? "theme-dark" : "").replace("__TITLE__", IdeBundle.message((String)"whats.new.timeout.title", (Object[])new Object[0])).replace("__MESSAGE__", IdeBundle.message((String)"whats.new.timeout.message", (Object[])new Object[0])).replace("__ACTION__", IdeBundle.message((String)"whats.new.timeout.action", (Object[])new Object[]{url}));
                }
            }
            catch (IOException e) {
                Logger.getInstance(WhatsNewAction.class).error((Throwable)e);
            }
            HTMLEditorProvider.openEditor(project, title2, embeddedUrl, timeoutContent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/WhatsNewAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openWhatsNewPage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

