/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.project;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.project.ConvertModuleGroupsToQualifiedNamesDialog;
import com.intellij.ide.actions.project.LoadModuleRenamingSchemeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.JdomKt;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"EXPORTED_PATH_PROPERTY", "", "getDefaultRenamingSchemeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "saveDefaultRenamingSchemeFilePath", "", "filePath", "saveModuleRenamingScheme", "", "dialog", "Lcom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog;", "intellij.platform.ide.impl"})
public final class LoadSaveModuleRenameMappingKt {
    private static final String EXPORTED_PATH_PROPERTY = "module.renaming.scheme.file";

    public static final boolean saveModuleRenamingScheme(@NotNull ConvertModuleGroupsToQualifiedNamesDialog dialog2) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        Project project = dialog2.getProject();
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(ProjectBundle.message((String)"module.renaming.scheme.save.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"module.renaming.scheme.save.chooser.description", (Object[])new Object[0]), new String[]{"xml"});
        VirtualFile virtualFile2 = LoadSaveModuleRenameMappingKt.getDefaultRenamingSchemeFile(project);
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.getParent()) == null) {
            virtualFile2 = project.getBaseDir();
        }
        VirtualFile baseDir = virtualFile2;
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, project).save(baseDir, "module-renaming-scheme.xml");
        if (fileWrapper != null) {
            File file2 = fileWrapper.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"fileWrapper.file");
            LoadSaveModuleRenameMappingKt.saveDefaultRenamingSchemeFilePath(project, FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
            ModuleRenamingHistoryState state = new ModuleRenamingHistoryState();
            state.oldToNewName.putAll(dialog2.getRenamingScheme());
            try {
                Element element2 = XmlSerializer.serialize((Object)state);
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"XmlSerializer.serialize(state)");
                Parent parent = (Parent)element2;
                Path path2 = fileWrapper.getFile().toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fileWrapper.file.toPath()");
                JdomKt.write$default((Parent)parent, (Path)path2, null, (int)2, null);
                VirtualFile virtualFile3 = fileWrapper.getVirtualFile();
                if (virtualFile3 != null) {
                    virtualFile3.refresh(true, false);
                }
                return true;
            }
            catch (Exception e) {
                LoadModuleRenamingSchemeAction.Companion.getLOG().info((Throwable)e);
                String string = CommonBundle.getErrorTitle();
                Object[] objectArray = new Object[1];
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                objectArray[0] = string2;
                Messages.showErrorDialog((Project)project, (String)string, (String)ProjectBundle.message((String)"module.renaming.scheme.cannot.save.error", (Object[])objectArray));
            }
        }
        return false;
    }

    private static final void saveDefaultRenamingSchemeFilePath(Project project, String filePath) {
        PropertiesComponent.getInstance((Project)project).setValue(EXPORTED_PATH_PROPERTY, filePath);
    }

    private static final VirtualFile getDefaultRenamingSchemeFile(Project project) {
        VirtualFile virtualFile2;
        String string = PropertiesComponent.getInstance((Project)project).getValue(EXPORTED_PATH_PROPERTY);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(it);
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    public static final /* synthetic */ VirtualFile access$getDefaultRenamingSchemeFile(Project project) {
        return LoadSaveModuleRenameMappingKt.getDefaultRenamingSchemeFile(project);
    }
}

