/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.AutoCompletionCommand;
import com.intellij.ide.actions.searcheverywhere.AutoCompletionContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AutoCompletionProvider {
    AutoCompletionProvider() {
    }

    public static List<SearchEverywhereFoundElementInfo> getCompletionElements(Collection<SearchEverywhereContributor<?>> contributors, JTextComponent textComponent) {
        StubContributor stubContributor = new StubContributor(textComponent);
        return ContainerUtil.map(AutoCompletionProvider.getCompletions(contributors, textComponent), command -> new SearchEverywhereFoundElementInfo(command, 0, stubContributor));
    }

    private static List<AutoCompletionCommand> getCompletions(Collection<SearchEverywhereContributor<?>> contributors, JTextComponent textComponent) {
        return contributors.stream().filter(c -> c instanceof AutoCompletionContributor).map(c -> (AutoCompletionContributor)c).flatMap(c -> c.getAutocompleteItems(textComponent.getText(), textComponent.getCaretPosition()).stream()).collect(Collectors.toList());
    }

    private static class CommandRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer<AutoCompletionCommand> {
        protected boolean mySelected;
        protected Color myForeground;
        protected Color mySelectionForeground;

        private CommandRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoCompletionCommand> list2, AutoCompletionCommand value2, int index2, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            this.getIpad().right = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale((int)UIUtil.getListCellHPadding());
            this.getIpad().left = this.getIpad().right;
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setFont(list2.getFont());
            this.setIcon(EmptyIcon.ICON_16);
            this.mySelected = isSelected;
            this.myForeground = this.isEnabled() ? list2.getForeground() : UIUtil.getLabelDisabledForeground();
            this.mySelectionForeground = list2.getSelectionForeground();
            if (UIUtil.isUnderWin10LookAndFeel()) {
                this.setBackground(isSelected ? list2.getSelectionBackground() : list2.getBackground());
            } else {
                this.setBackground(isSelected ? list2.getSelectionBackground() : null);
            }
            SimpleTextAttributes baseStyle2 = new SimpleTextAttributes(0, list2.getForeground());
            this.appendHTML(value2.getPresentationString(), baseStyle2);
            return this;
        }

        public final void append(@NotNull String fragment2, @NotNull SimpleTextAttributes attributes2, boolean isMainText) {
            if (fragment2 == null) {
                CommandRenderer.$$$reportNull$$$0(0);
            }
            if (attributes2 == null) {
                CommandRenderer.$$$reportNull$$$0(1);
            }
            if (this.mySelected) {
                super.append(fragment2, new SimpleTextAttributes(attributes2.getStyle(), this.mySelectionForeground), isMainText);
            } else if (attributes2.getFgColor() == null) {
                super.append(fragment2, attributes2.derive(-1, this.myForeground, null, null), isMainText);
            } else {
                super.append(fragment2, attributes2, isMainText);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/searcheverywhere/AutoCompletionProvider$CommandRenderer";
            objectArray[2] = "append";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StubContributor
    implements SearchEverywhereContributor<AutoCompletionCommand> {
        private final JTextComponent myTextComponent;

        private StubContributor(JTextComponent component2) {
            this.myTextComponent = component2;
        }

        @NotNull
        public String getSearchProviderId() {
            return "AutocompletionContributor";
        }

        @Nls
        @NotNull
        public String getGroupName() {
            return "Autocompletion";
        }

        public int getSortWeight() {
            return 0;
        }

        public boolean showInFindResults() {
            return false;
        }

        public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super AutoCompletionCommand> consumer2) {
            if (pattern == null) {
                StubContributor.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                StubContributor.$$$reportNull$$$0(1);
            }
            if (consumer2 == null) {
                StubContributor.$$$reportNull$$$0(2);
            }
        }

        public boolean processSelectedItem(@NotNull AutoCompletionCommand selected2, int modifiers, @NotNull String searchText) {
            if (selected2 == null) {
                StubContributor.$$$reportNull$$$0(3);
            }
            if (searchText == null) {
                StubContributor.$$$reportNull$$$0(4);
            }
            selected2.completeQuery(this.myTextComponent);
            return false;
        }

        @NotNull
        public ListCellRenderer<? super AutoCompletionCommand> getElementsRenderer() {
            return new CommandRenderer();
        }

        @Nullable
        public Object getDataForItem(@NotNull AutoCompletionCommand element2, @NotNull String dataId) {
            if (element2 == null) {
                StubContributor.$$$reportNull$$$0(5);
            }
            if (dataId == null) {
                StubContributor.$$$reportNull$$$0(6);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchText";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AutoCompletionProvider$StubContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchElements";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processSelectedItem";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataForItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

