/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.CalculatorSEContributorKt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"minExponentialNotationValue", "", "precision", "", "doEvaluate", "", "str", "", "evaluate", "input", "format", "doubleValue", "round", "value", "intellij.platform.lang.impl"})
public final class CalculatorSEContributorKt {
    private static final int precision = 9;
    private static final long minExponentialNotationValue = 1000000000L;

    @NotNull
    public static final String evaluate(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return CalculatorSEContributorKt.format(CalculatorSEContributorKt.round(CalculatorSEContributorKt.doEvaluate(input)));
    }

    private static final double doEvaluate(String str) {
        return new Object(str){
            private int pos;
            private char ch;
            final /* synthetic */ String $str;

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            public final char getCh() {
                return this.ch;
            }

            public final void setCh(char c) {
                this.ch = c;
            }

            public final void nextChar() {
                char c;
                doEvaluate.1 v0 = this;
                CharSequence charSequence = this.$str;
                doEvaluate.1 v1 = this;
                ++v1.pos;
                int n = v1.pos;
                boolean bl = false;
                if (n >= 0 && n <= StringsKt.getLastIndex((CharSequence)charSequence)) {
                    c = charSequence.charAt(n);
                } else {
                    int n2 = n;
                    doEvaluate.1 var6_5 = v0;
                    boolean bl2 = false;
                    char c2 = '\u0000';
                    v0 = var6_5;
                    c = c2;
                }
                v0.ch = c;
            }

            public final boolean eat(char charToEat) {
                while (this.ch == ' ') {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            public final double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat('+')) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat('-')) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            public final double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat('*')) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat('/')) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            public final double parseFactor() {
                return this.eat('+') ? this.parseFactor() : (this.eat('-') ? -this.parseFactor() : this.parsePrimary());
            }

            /*
             * Enabled aggressive block sorting
             */
            public final double parsePrimary() {
                boolean bl;
                double x = 0.0;
                if (this.eat('(')) {
                    x = this.parseExpression();
                    this.eat(')');
                } else if (this.eat('0')) {
                    x = this.eat('x') || this.eat('X') ? this.parseHex() : (this.eat('b') || this.eat('B') ? this.parseBinary() : this.parseDecimalOrOctal());
                } else {
                    int startPos = this.pos;
                    char c = this.ch;
                    if ('1' <= c && '9' >= c || this.ch == '.') {
                        this.nextChar();
                        while ('0' <= (c = this.ch) && '9' >= c || this.ch == '.') {
                            this.nextChar();
                        }
                        String string = this.$str;
                        int n = this.pos;
                        boolean bl2 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(startPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        string = string3;
                        n = 0;
                        x = Double.parseDouble(string);
                    } else {
                        double d;
                        c = this.ch;
                        if ('a' > c) {
                            throw (Throwable)new RuntimeException("Unexpected: " + this.ch);
                        }
                        if ('z' < c) throw (Throwable)new RuntimeException("Unexpected: " + this.ch);
                        while ('a' <= (c = this.ch) && 'z' >= c) {
                            this.nextChar();
                        }
                        String string = this.$str;
                        int n = this.pos;
                        bl = false;
                        String string4 = string;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(startPos, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String func = string5;
                        x = this.parseFactor();
                        switch (func) {
                            case "sqrt": {
                                n = 0;
                                d = Math.sqrt(x);
                                break;
                            }
                            case "sin": {
                                double d2 = Math.toRadians(x);
                                boolean bl3 = false;
                                d = Math.sin(d2);
                                break;
                            }
                            case "cos": {
                                double d3 = Math.toRadians(x);
                                boolean bl3 = false;
                                d = Math.cos(d3);
                                break;
                            }
                            case "tan": {
                                double d4 = Math.toRadians(x);
                                boolean bl3 = false;
                                d = Math.tan(d4);
                                break;
                            }
                            default: {
                                throw (Throwable)new RuntimeException("Unknown function: " + func);
                            }
                        }
                        x = d;
                    }
                }
                if (!this.eat('^')) return x;
                double d = x;
                double d5 = this.parseFactor();
                bl = false;
                return Math.pow(d, d5);
            }

            private final double parseHex() {
                int startPos = this.pos;
                while (true) {
                    char c;
                    if ('0' > (c = this.ch) || '9' < c) {
                        c = this.ch;
                        if ('a' > c || 'f' < c) {
                            c = this.ch;
                            if ('A' > c || 'F' < c) break;
                        }
                    }
                    this.nextChar();
                }
                String string = this.$str;
                int n = this.pos;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startPos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string3, 16);
            }

            private final double parseBinary() {
                int startPos = this.pos;
                while (this.ch == '0' || this.ch == '1') {
                    this.nextChar();
                }
                String string = this.$str;
                int n = this.pos;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startPos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string3, 2);
            }

            private final double parseDecimalOrOctal() {
                int startPos = this.pos;
                if (this.eat('.')) {
                    while (true) {
                        char c;
                        if ('0' > (c = this.ch) || '9' < c) {
                            if (this.ch != '.') break;
                        }
                        this.nextChar();
                    }
                    String string = this.$str;
                    int n = this.pos;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(startPos, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string3;
                    n = 0;
                    return Double.parseDouble(string);
                }
                char c = this.ch;
                if ('0' <= c && '7' >= c) {
                    while ('0' <= (c = this.ch) && '7' >= c) {
                        this.nextChar();
                    }
                    String string = this.$str;
                    int n = this.pos;
                    boolean bl = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(startPos, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    return Long.parseLong(string5, 8);
                }
                return 0.0;
            }

            public final double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < this.$str.length()) {
                    throw (Throwable)new RuntimeException("Unexpected: " + this.ch);
                }
                return x;
            }
            {
                this.$str = $captured_local_variable$0;
                this.pos = -1;
            }
        }.parse();
    }

    private static final double round(double value2) {
        if (Double.isFinite(value2)) {
            return new BigDecimal(String.valueOf(value2)).setScale(9, RoundingMode.HALF_UP).doubleValue();
        }
        return value2;
    }

    private static final String format(double doubleValue) {
        String string;
        long longValue = (long)doubleValue;
        boolean bl = false;
        String pattern = Math.abs(longValue) < 1000000000L ? "0" : "0E0";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        boolean bl2 = false;
        boolean bl3 = false;
        DecimalFormat $this$apply = decimalFormat;
        boolean bl4 = false;
        $this$apply.setMaximumFractionDigits(9);
        DecimalFormat df = decimalFormat;
        if ((double)longValue == doubleValue) {
            String string2 = df.format(longValue);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"df.format(longValue)");
        } else {
            String string3 = df.format(doubleValue);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"df.format(doubleValue)");
        }
        return string;
    }
}

