/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionsOnSave;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionsOnSave.ActionOnSaveBackedByOwnConfigurable;
import com.intellij.ide.actionsOnSave.ActionOnSaveColumnInfo;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfoProvider;
import com.intellij.ide.actionsOnSave.ActivatedOnColumnInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsOnSaveConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String CONFIGURABLE_ID = "actions.on.save";
    private static final Logger LOG = Logger.getInstance(ActionsOnSaveConfigurable.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private ActionOnSaveContext myActionOnSaveContext;
    private TableView<ActionOnSaveInfo> myTable;

    public ActionsOnSaveConfigurable(@NotNull Project project) {
        if (project == null) {
            ActionsOnSaveConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDisposable = Disposer.newDisposable();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"actions.on.save.page.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        return CONFIGURABLE_ID;
    }

    public String getHelpTopic() {
        return "settings.actions.on.save";
    }

    @Nullable
    public JComponent createComponent() {
        this.myTable = this.createTable();
        JPanel panel2 = new JPanel(new BorderLayout(10, 4));
        panel2.add((Component)new JBScrollPane(this.myTable), "Center");
        ActionLink autoSaveOptionsLink = ActionsOnSaveConfigurable.createGoToPageInSettingsLink(IdeBundle.message((String)"actions.on.save.link.configure.autosave.options", (Object[])new Object[0]), "preferences.general");
        panel2.add((Component)autoSaveOptionsLink, "South");
        return panel2;
    }

    @NotNull
    private TableView<ActionOnSaveInfo> createTable() {
        TableView table = new TableView(new ListTableModel(new ColumnInfo[]{new ActionOnSaveColumnInfo(), new ActivatedOnColumnInfo()}));
        table.getTableHeader().setReorderingAllowed(false);
        table.setShowGrid(false);
        table.setRowSelectionAllowed(false);
        table.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                ActionsOnSaveConfigurable.this.updateTable();
            }
        });
        new TableHoverListener(){

            public void onHover(@NotNull JTable table, int row2, int column2) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (column2 != -1 && row2 != -1) {
                    table.editCellAt(row2, column2);
                } else {
                    ((TableView)table).stopEditing();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ide/actionsOnSave/ActionsOnSaveConfigurable$2", "onHover"));
            }
        }.addTo((JComponent)table);
        TableView tableView = table;
        if (tableView == null) {
            ActionsOnSaveConfigurable.$$$reportNull$$$0(1);
        }
        return tableView;
    }

    public boolean isModified() {
        for (ActionOnSaveInfo info2 : this.myTable.getItems()) {
            if (!info2.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (ActionOnSaveInfo info2 : this.myTable.getItems()) {
            info2.apply();
        }
    }

    public void reset() {
        if (!this.myTable.isShowing()) {
            return;
        }
        for (ActionOnSaveInfo info2 : this.myTable.getItems()) {
            if (!(info2 instanceof ActionOnSaveBackedByOwnConfigurable)) continue;
            ((ActionOnSaveBackedByOwnConfigurable)info2).resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage();
        }
        this.myActionOnSaveContext = null;
        this.updateTable();
    }

    private void updateTable() {
        Settings settings = Settings.KEY.getData(DataManager.getInstance().getDataContext(this.myTable));
        if (settings == null) {
            this.myTable.getListTableModel().setItems(Collections.emptyList());
            LOG.error("Settings not found");
            return;
        }
        if (this.myActionOnSaveContext == null) {
            this.myActionOnSaveContext = new ActionOnSaveContext(this.myProject, settings, this.myDisposable);
        }
        List<ActionOnSaveInfo> infos = ActionOnSaveInfoProvider.getAllActionOnSaveInfos(this.myActionOnSaveContext);
        this.myTable.getListTableModel().setItems(infos);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    public static ActionLink createGoToActionsOnSavePageLink() {
        return ActionsOnSaveConfigurable.createGoToPageInSettingsLink(IdeBundle.message((String)"actions.on.save.link.all.actions.on.save", (Object[])new Object[0]), CONFIGURABLE_ID);
    }

    @NotNull
    public static ActionLink createGoToPageInSettingsLink(@NotNull @NlsContexts.LinkLabel String linkText, final @NotNull String configurableId) {
        if (linkText == null) {
            ActionsOnSaveConfigurable.$$$reportNull$$$0(2);
        }
        if (configurableId == null) {
            ActionsOnSaveConfigurable.$$$reportNull$$$0(3);
        }
        return new ActionLink(linkText, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context2 -> {
                    Settings settings = Settings.KEY.getData((DataContext)context2);
                    if (settings != null) {
                        settings.select(settings.find(configurableId));
                    }
                });
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actionsOnSave/ActionsOnSaveConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actionsOnSave/ActionsOnSaveConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createGoToPageInSettingsLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionsOnSaveConfigurableProvider
    extends ConfigurableProvider {
        @NotNull
        private final Project myProject;

        public ActionsOnSaveConfigurableProvider(@NotNull Project project) {
            if (project == null) {
                ActionsOnSaveConfigurableProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Nullable
        public Configurable createConfigurable() {
            return new ActionsOnSaveConfigurable(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actionsOnSave/ActionsOnSaveConfigurable$ActionsOnSaveConfigurableProvider", "<init>"));
        }
    }
}

