/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/bookmark/actions/AddAnotherBookmarkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "process", "", "perform", "update", "intellij.platform.lang.impl"})
public final class AddAnotherBookmarkAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation2 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
        presentation2.setEnabledAndVisible(this.process(event, false));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.process(event, true);
    }

    private final boolean process(AnActionEvent event, boolean perform2) {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return false;
        }
        BookmarksManager manager2 = bookmarksManager;
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark == null) {
            return false;
        }
        Bookmark bookmark2 = bookmark;
        if (bookmark2 instanceof LineBookmark) {
            return false;
        }
        BookmarkType bookmarkType = manager2.getType(bookmark2);
        if (bookmarkType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarkType, (String)"manager.getType(bookmark) ?: return false");
        BookmarkType type = bookmarkType;
        if (perform2) {
            manager2.add(bookmark2, type);
        }
        return true;
    }

    public AddAnotherBookmarkAction() {
        super(BookmarkBundle.messagePointer("bookmark.add.another.action.text", new Object[0]));
        this.setEnabledInModalContext(true);
    }
}

