/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/bookmark/actions/NextBookmarkService;", "Lcom/intellij/ide/bookmark/BookmarksListener;", "Ljava/util/Comparator;", "Lcom/intellij/ide/bookmark/LineBookmark;", "Lkotlin/Comparator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bookmarks", "", "getBookmarks", "()Ljava/util/List;", "cache", "Ljava/util/concurrent/atomic/AtomicReference;", "bookmarkAdded", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmarkRemoved", "bookmarksChanged", "compare", "", "bookmark1", "bookmark2", "compareFiles", "compareLines", "getCachedBookmarks", "next", "forward", "", "index", "intellij.platform.lang.impl"})
public final class NextBookmarkService
implements BookmarksListener,
Comparator<LineBookmark> {
    private final AtomicReference<List<LineBookmark>> cache;
    private final Project project;

    /*
     * WARNING - void declaration
     */
    private final List<LineBookmark> getBookmarks() {
        Object object;
        block4: {
            block3: {
                void $this$filterIsInstanceTo$iv$iv;
                object = BookmarksManager.getInstance((Project)this.project);
                if (object == null || (object = object.getBookmarks()) == null) break block3;
                Iterable $this$filterIsInstance$iv = (Iterable)object;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LineBookmark)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)this);
                if (object != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<LineBookmark> getCachedBookmarks() {
        List<LineBookmark> list2;
        AtomicReference<List<LineBookmark>> atomicReference = this.cache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (atomicReference) {
            boolean bl3 = false;
            List<LineBookmark> list3 = this.cache.get();
            if (list3 == null) {
                List<LineBookmark> list4 = this.getBookmarks();
                boolean bl4 = false;
                boolean bl5 = false;
                List<LineBookmark> it = list4;
                boolean bl6 = false;
                this.cache.set(it);
                list3 = list4;
            }
            list2 = list3;
        }
        return list2;
    }

    public void bookmarkAdded(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmarksChanged(bookmark);
    }

    public void bookmarkRemoved(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmarksChanged(bookmark);
    }

    private final void bookmarksChanged(Bookmark bookmark) {
        if (bookmark instanceof LineBookmark) {
            this.cache.set(null);
        }
    }

    private final int compareFiles(LineBookmark bookmark1, LineBookmark bookmark2) {
        String string = bookmark1.getFile().getPath();
        String string2 = bookmark2.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bookmark2.file.path");
        return string.compareTo(string2);
    }

    private final int compareLines(LineBookmark bookmark1, LineBookmark bookmark2) {
        return Intrinsics.compare((int)bookmark1.getLine(), (int)bookmark2.getLine());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compare(@NotNull LineBookmark bookmark1, @NotNull LineBookmark bookmark2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        int result2 = this.compareFiles(bookmark1, bookmark2);
        switch (result2) {
            case 0: {
                n = this.compareLines(bookmark1, bookmark2);
                break;
            }
            default: {
                void var3_3;
                n = var3_3;
            }
        }
        return n;
    }

    private final int next(boolean forward, int index2) {
        return index2 < 0 ? -index2 - (forward ? 1 : 2) : index2 - (forward ? -1 : 1);
    }

    @Nullable
    public final LineBookmark next(boolean forward, @Nullable LineBookmark bookmark) {
        Collection collection = this.getCachedBookmarks();
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return null;
        }
        List bookmarks = (List)collection;
        if (bookmark == null) {
            return forward ? (LineBookmark)CollectionsKt.first((List)bookmarks) : (LineBookmark)CollectionsKt.last((List)bookmarks);
        }
        return (LineBookmark)CollectionsKt.getOrNull((List)bookmarks, (int)this.next(forward, CollectionsKt.binarySearch$default((List)bookmarks, (Object)bookmark, (Comparator)this, (int)0, (int)0, (int)12, null)));
    }

    public NextBookmarkService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = new AtomicReference();
        this.project.getMessageBus().connect((Disposable)this.project).subscribe(BookmarksListener.TOPIC, (Object)this);
    }
}

