/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.bookmark.ui.tree.RootNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.presentation.FilePresentationService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0004J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u0012\u0010(\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u000f\u0010+\u001a\t\u0018\u00010,\u00a2\u0006\u0002\b\u0016H\u0014J\u0011\u0010-\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0096\u0002J\u0017\u0010.\u001a\t\u0018\u00010,\u00a2\u0006\u0002\b\u00162\u0006\u0010/\u001a\u00020$H\u0016J\u0017\u00100\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020&H\u0016J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000105H\u0004R\u0018\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00067"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "B", "Lcom/intellij/ide/bookmark/Bookmark;", "Lcom/intellij/ui/BackgroundSupplier;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/Bookmark;)V", "bookmarkDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "getBookmarkDescription", "()Ljava/lang/String;", "bookmarkGroup", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "getBookmarkGroup", "()Lcom/intellij/ide/bookmark/BookmarkGroup;", "setBookmarkGroup", "(Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "bookmarkType", "Lcom/intellij/ide/bookmark/BookmarkType;", "Lorg/jetbrains/annotations/Nullable;", "getBookmarkType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "bookmarksView", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "getBookmarksView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "addTextTo", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "canNavigate", "", "canNavigateToSource", "canRepresent", "element", "", "computeBackgroundColor", "Ljava/awt/Color;", "contains", "getElementBackground", "row", "getRelativePath", "navigate", "requestFocus", "update", "wrapIcon", "Ljavax/swing/Icon;", "icon", "intellij.platform.lang.impl"})
public abstract class BookmarkNode<B extends Bookmark>
extends ProjectViewNode<B>
implements BackgroundSupplier {
    @Nullable
    private BookmarkGroup bookmarkGroup;

    @Nullable
    public final BookmarksView getBookmarksView() {
        RootNode rootNode = ExtensionsKt.getParentRootNode(this);
        return rootNode != null ? (BookmarksView)rootNode.getValue() : null;
    }

    @Nullable
    public final BookmarkType getBookmarkType() {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(this);
        return bookmarksManager != null ? bookmarksManager.getType((Bookmark)this.getValue()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getBookmarkDescription() {
        CharSequence charSequence;
        BookmarkGroup bookmarkGroup = this.bookmarkGroup;
        Object object = bookmarkGroup;
        if (bookmarkGroup == null) return null;
        Bookmark bookmark = (Bookmark)this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)bookmark, (String)"value");
        String string = object.getDescription(bookmark);
        object = string;
        if (string == null) return null;
        CharSequence charSequence2 = (CharSequence)object;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl2 = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String string2 = (String)charSequence;
        return string2;
    }

    @Nullable
    public final BookmarkGroup getBookmarkGroup() {
        return this.bookmarkGroup;
    }

    public final void setBookmarkGroup(@Nullable BookmarkGroup bookmarkGroup) {
        this.bookmarkGroup = bookmarkGroup;
    }

    public boolean canRepresent(@Nullable Object element2) {
        VirtualFile virtualFile2 = this.getVirtualFile();
        return virtualFile2 != null ? virtualFile2.equals(element2) : false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl2 = false;
            boolean bl3 = false;
            VirtualFile it = virtualFile3;
            boolean bl4 = false;
            bl = VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)file2, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean canNavigate() {
        return ((Bookmark)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Bookmark)this.getValue()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        ((Bookmark)this.getValue()).navigate(requestFocus);
    }

    @Nullable
    protected Color computeBackgroundColor() {
        return FilePresentationService.getFileBackgroundColor((Project)this.getProject(), (VirtualFile)this.getVirtualFile());
    }

    @Nullable
    public Color getElementBackground(int row2) {
        PresentationData presentationData = this.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentationData, (String)"presentation");
        return presentationData.getBackground();
    }

    @NotNull
    protected final Icon wrapIcon(@Nullable Icon icon2) {
        Icon icon3;
        BookmarkType bookmarkType = this.getBookmarkType();
        if (bookmarkType == null) {
            bookmarkType = BookmarkType.DEFAULT;
        }
        BookmarkType type = bookmarkType;
        if (icon2 == null) {
            icon3 = type.getIcon();
        } else if (type == BookmarkType.DEFAULT) {
            icon3 = icon2;
        } else {
            RowIcon rowIcon = IconManager.getInstance().createRowIcon(new Icon[]{type.getIcon(), icon2});
            Intrinsics.checkNotNullExpressionValue((Object)rowIcon, (String)"IconManager.getInstance(\u2026eRowIcon(type.icon, icon)");
            icon3 = (Icon)rowIcon;
        }
        return icon3;
    }

    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile ?: return");
        VirtualFile file2 = virtualFile2;
        presentation2.setIcon(this.wrapIcon(CompoundIconProvider.findIcon((PsiElement)PsiUtilCore.findFileSystemItem((Project)this.getProject(), (VirtualFile)file2), 0)));
        BookmarkNode.addTextTo$default(this, presentation2, file2, 0, 4, null);
    }

    protected final void addTextTo(@NotNull PresentationData presentation2, @NotNull VirtualFile file2, int line) {
        block5: {
            String description;
            String location;
            boolean bl;
            String name2;
            block4: {
                String string;
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                String string2 = file2.getPresentableName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.presentableName");
                name2 = string2;
                VirtualFile virtualFile2 = file2.getParent();
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl2 = false;
                    bl = false;
                    VirtualFile it = virtualFile3;
                    boolean bl3 = false;
                    string = this.getRelativePath(it);
                } else {
                    string = null;
                }
                location = string;
                description = this.getBookmarkDescription();
                if (description != null) break block4;
                presentation2.setPresentableText(name2);
                presentation2.addText(name2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (line > 0) {
                    presentation2.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                String string3 = location;
                if (string3 == null) break block5;
                String string4 = string3;
                bl = false;
                boolean bl4 = false;
                String it = string4;
                boolean bl5 = false;
                presentation2.addText("  " + it, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                break block5;
            }
            presentation2.setPresentableText(description + ' ' + name2);
            presentation2.addText(description + "  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation2.addText(name2, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            if (line > 0) {
                presentation2.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            String string = location;
            if (string == null) break block5;
            String string5 = string;
            bl = false;
            boolean bl6 = false;
            String it = string5;
            boolean bl7 = false;
            presentation2.addText("  (" + it + ')', SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public static /* synthetic */ void addTextTo$default(BookmarkNode bookmarkNode, PresentationData presentationData, VirtualFile virtualFile2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTextTo");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        bookmarkNode.addTextTo(presentationData, virtualFile2, n);
    }

    private final String getRelativePath(VirtualFile file2) {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex index2 = projectFileIndex;
        if (index2.getModuleForFile(file2, false) == null) {
            return FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        }
        VirtualFile root2 = file2;
        while (root2.getParent() != null) {
            VirtualFile parent;
            if (index2.getModuleForFile(parent, false) == null) {
                break;
            }
            root2 = parent;
        }
        return Intrinsics.areEqual((Object)file2, (Object)root2) ? null : VfsUtil.getRelativePath((VirtualFile)file2, (VirtualFile)root2);
    }

    public BookmarkNode(@NotNull Project project, @NotNull B bookmark) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(bookmark, (String)"bookmark");
        super(project, bookmark, (ViewSettings)ProjectViewSettings.Immutable.DEFAULT);
    }
}

