/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.cds;

import com.intellij.ide.cds.CDSTaskResult;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/cds/CDSFUSCollector;", "", "()V", "groupId", "", "uptime", "", "getUptime", "()J", "logCDSBuildingCompleted", "", "duration", "result", "Lcom/intellij/ide/cds/CDSTaskResult;", "logCDSBuildingStarted", "logCDSStatus", "enabled", "", "runningWithArchive", "intellij.platform.ide.impl"})
public final class CDSFUSCollector {
    private static final String groupId = "intellij.cds";
    @NotNull
    public static final CDSFUSCollector INSTANCE;

    private final long getUptime() {
        long l = System.currentTimeMillis();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        return l - runtimeMXBean.getUptime();
    }

    public final void logCDSStatus(boolean enabled, boolean runningWithArchive) {
        FUCounterUsageLogger.getInstance().logEvent(groupId, "running.with.cds", new FeatureUsageData().addData("running_with_archive", runningWithArchive).addData("status", enabled ? "enabled" : "disabled"));
    }

    public final void logCDSBuildingStarted() {
        FUCounterUsageLogger.getInstance().logEvent(groupId, "building.cds.started", new FeatureUsageData().addData("uptime_millis", this.getUptime()));
    }

    public final void logCDSBuildingCompleted(long duration, @NotNull CDSTaskResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        FUCounterUsageLogger.getInstance().logEvent(groupId, "building.cds.finished", new FeatureUsageData().addData("duration", duration).addData("uptime_millis", this.getUptime()).addData("status", result2.getStatusName()));
    }

    private CDSFUSCollector() {
    }

    static {
        CDSFUSCollector cDSFUSCollector;
        INSTANCE = cDSFUSCollector = new CDSFUSCollector();
    }
}

