/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

abstract class FileTemplateTabAsList
extends FileTemplateTab {
    private final JList<FileTemplate> myList = new JBList();
    private MyListModel myModel;

    FileTemplateTabAsList(@NlsContexts.TabTitle String title2) {
        super(title2);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer<FileTemplate>)SimpleListCellRenderer.create((label2, value2, index2) -> {
            label2.setIcon(FileTemplateUtil.getIcon(value2));
            label2.setText(value2.getName());
            if (!value2.isDefault() && this.myList.getSelectedIndex() != index2) {
                label2.setForeground(MODIFIED_FOREGROUND);
            }
            if (FileTemplateBase.isChild(value2)) {
                label2.setBorder((Border)JBUI.Borders.emptyLeft((int)JBUI.scale((int)20)));
                label2.setText(value2.getFileName().isEmpty() ? IdeBundle.message((String)"label.empty.file.name", (Object[])new Object[0]) : value2.getFileName());
            }
        }));
        this.myList.addListSelectionListener(__ -> this.onTemplateSelected());
        new ListSpeedSearch<FileTemplate>(this.myList, FileTemplate::getName);
    }

    @Override
    public void removeSelected() {
        FileTemplate selectedTemplate = this.getSelectedTemplate();
        if (selectedTemplate == null) {
            return;
        }
        DefaultListModel model2 = (DefaultListModel)this.myList.getModel();
        for (FileTemplate child2 : selectedTemplate.getChildren()) {
            model2.removeElement(child2);
        }
        int selectedIndex = this.myList.getSelectedIndex();
        model2.remove(selectedIndex);
        if (!model2.isEmpty()) {
            this.myList.setSelectedIndex(Math.min(selectedIndex, model2.size() - 1));
        }
        this.onTemplateSelected();
    }

    @Override
    protected void initSelection(FileTemplate selection) {
        this.myModel = new MyListModel();
        this.myList.setModel(this.myModel);
        for (FileTemplate template : this.myTemplates) {
            this.myModel.addElement(template);
        }
        if (selection != null) {
            this.selectTemplate(selection);
        } else if (this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    @Override
    public void fireDataChanged() {
        this.myModel.fireListDataChanged();
    }

    @Override
    public FileTemplate @NotNull [] getTemplates() {
        int size = this.myModel.getSize();
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            templates.add((FileTemplate)this.myModel.getElementAt(i2));
        }
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateTabAsList.$$$reportNull$$$0(0);
        }
        return fileTemplateArray;
    }

    @Override
    public void addTemplate(FileTemplate newTemplate) {
        this.myModel.addElement(newTemplate);
    }

    @Override
    public void insertTemplate(FileTemplate newTemplate, int index2) {
        this.myModel.insertElementAt(newTemplate, index2);
    }

    @Override
    public void selectTemplate(FileTemplate template) {
        this.myList.setSelectedValue(template, true);
    }

    @Override
    public FileTemplate getSelectedTemplate() {
        return this.myList.getSelectedValue();
    }

    @Override
    public JComponent getComponent() {
        return this.myList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateTabAsList", "getTemplates"));
    }

    private static class MyListModel
    extends DefaultListModel<FileTemplate> {
        private MyListModel() {
        }

        void fireListDataChanged() {
            int size = this.getSize();
            if (size > 0) {
                this.fireContentsChanged(this, 0, size - 1);
            }
        }
    }
}

