/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PlatformUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public final class EndUserAgreement {
    private static final Logger LOG = Logger.getInstance(EndUserAgreement.class);
    private static final String POLICY_TEXT_PROPERTY = "jb.privacy.policy.text";
    private static final String PRIVACY_POLICY_DOCUMENT_NAME = "privacy";
    private static final String PRIVACY_POLICY_EAP_DOCUMENT_NAME = "privacyEap";
    private static final String CWM_GUEST_EULA_NAME = "cwmGuestEua";
    private static final String EULA_DOCUMENT_NAME = "eua";
    private static final String EULA_COMMUNITY_DOCUMENT_NAME = "euaCommunity";
    private static final String EULA_EAP_DOCUMENT_NAME = "euaEap";
    private static final String PRIVACY_POLICY_CONTENT_FILE_NAME = "Cached";
    private static final String DEFAULT_DOC_NAME = "eua";
    private static final String DEFAULT_DOC_EAP_NAME = "euaEap";
    private static final String ACTIVE_DOC_FILE_NAME = "documentName";
    private static final String ACTIVE_DOC_EAP_FILE_NAME = "documentName.eap";
    private static final String RELATIVE_RESOURCE_PATH = "PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final Version MAGIC_VERSION = new Version(999, 999);

    public static Path getDocumentContentFile() {
        return EndUserAgreement.getDocumentContentFile(EndUserAgreement.getDocumentName());
    }

    @NotNull
    private static Path getDocumentContentFile(String docName) {
        Path path2 = EndUserAgreement.getDataRoot().resolve((String)(PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? PRIVACY_POLICY_CONTENT_FILE_NAME : docName + ".cached"));
        if (path2 == null) {
            EndUserAgreement.$$$reportNull$$$0(0);
        }
        return path2;
    }

    @NotNull
    private static Path getDocumentNameFile() {
        Path path2 = EndUserAgreement.getDataRoot().resolve(EndUserAgreement.isEAP() ? ACTIVE_DOC_EAP_FILE_NAME : ACTIVE_DOC_FILE_NAME);
        if (path2 == null) {
            EndUserAgreement.$$$reportNull$$$0(1);
        }
        return path2;
    }

    private static boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    @NotNull
    private static Path getDataRoot() {
        Path path2 = PathManager.getCommonDataPath().resolve(RELATIVE_RESOURCE_PATH);
        if (path2 == null) {
            EndUserAgreement.$$$reportNull$$$0(2);
        }
        return path2;
    }

    private static String getBundledResourcePath(String docName) {
        return PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? "/PrivacyPolicy.html" : "/" + docName + ".html";
    }

    public static void setAccepted(@NotNull Document doc) {
        Version version2;
        if (doc == null) {
            EndUserAgreement.$$$reportNull$$$0(3);
        }
        if ((version2 = doc.getVersion()).isUnknown()) {
            Prefs.remove((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()));
        } else {
            Prefs.put((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()), (String)version2.toString());
        }
    }

    @NotNull
    private static Version getAcceptedVersion(String docName) {
        Version version2 = Version.fromString(Prefs.get((String)EndUserAgreement.getAcceptedVersionKey(docName), null));
        if (version2 == null) {
            EndUserAgreement.$$$reportNull$$$0(4);
        }
        return version2;
    }

    @NotNull
    public static Document getLatestDocument() {
        Document fromProperty;
        String text2 = System.getProperty(POLICY_TEXT_PROPERTY, null);
        if (text2 != null && !(fromProperty = new Document(PRIVACY_POLICY_DOCUMENT_NAME, text2)).getVersion().isUnknown()) {
            Document document = fromProperty;
            if (document == null) {
                EndUserAgreement.$$$reportNull$$$0(5);
            }
            return document;
        }
        String docName = EndUserAgreement.getDocumentName();
        Document fromFile = EndUserAgreement.loadContent(docName, EndUserAgreement.getDocumentContentFile(docName));
        if (!fromFile.getVersion().isUnknown()) {
            Document document = fromFile;
            if (document == null) {
                EndUserAgreement.$$$reportNull$$$0(6);
            }
            return document;
        }
        return EndUserAgreement.loadContent(docName, EndUserAgreement.getBundledResourcePath(docName));
    }

    public static boolean updateCachedContentToLatestBundledVersion() {
        block5: {
            try {
                Document bundled;
                Document cached;
                String docName = EndUserAgreement.getDocumentName();
                Path cacheFile2 = EndUserAgreement.getDocumentContentFile(docName);
                if (!Files.exists(cacheFile2, new LinkOption[0]) || (cached = EndUserAgreement.loadContent(docName, cacheFile2)).getVersion().isUnknown() || (bundled = EndUserAgreement.loadContent(docName, EndUserAgreement.getBundledResourcePath(docName))).getVersion().isUnknown() || !bundled.getVersion().isNewer(cached.getVersion())) break block5;
                try {
                    EndUserAgreement.writeToFile(EndUserAgreement.getDocumentContentFile(docName), bundled.getText());
                }
                catch (FileNotFoundException e) {
                    LOG.info(e.getMessage());
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void writeToFile(@NotNull Path file2, @NotNull String text2) throws IOException {
        if (file2 == null) {
            EndUserAgreement.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            EndUserAgreement.$$$reportNull$$$0(8);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        Files.writeString(file2, (CharSequence)text2, new OpenOption[0]);
    }

    public static void update(@NotNull String docName, @NotNull String text2) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            EndUserAgreement.$$$reportNull$$$0(10);
        }
        try {
            EndUserAgreement.writeToFile(EndUserAgreement.getDocumentContentFile(docName), text2);
            EndUserAgreement.writeToFile(EndUserAgreement.getDocumentNameFile(), docName);
        }
        catch (NoSuchFileException e) {
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Document loadContent(String docName, String resourcePath) {
        InputStream stream;
        block13: {
            Object object;
            try {
                Object object2;
                block15: {
                    stream = EndUserAgreement.class.getResourceAsStream(resourcePath);
                    try {
                        void result2;
                        if (stream == null) break block13;
                        object2 = stream;
                        try {
                            String result22 = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                        }
                        finally {
                            if (object2 != null) {
                                ((InputStream)object2).close();
                            }
                        }
                        object2 = new Document(docName, (String)result2);
                        if (stream == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                object = object2;
            }
            catch (IOException e) {
                LOG.info(docName + ": " + e.getMessage());
                LOG.debug((Throwable)e);
                return new Document(docName, "");
            }
            if (object != null) return object;
            EndUserAgreement.$$$reportNull$$$0(11);
            return object;
        }
        if (stream == null) return new Document(docName, "");
        stream.close();
        return new Document(docName, "");
    }

    @NotNull
    private static Document loadContent(String docName, Path file2) {
        try {
            return new Document(docName, Files.readString(file2));
        }
        catch (IOException e) {
            LOG.info(docName + ": " + e.getMessage());
            LOG.debug((Throwable)e);
            return new Document(docName, "");
        }
    }

    @NotNull
    private static String getDocumentName() {
        block6: {
            String string;
            if (!PlatformUtils.isCommercialEdition()) {
                if (PlatformUtils.isCommunityEdition()) {
                    return EndUserAgreement.isEAP() ? "euaEap" : EULA_COMMUNITY_DOCUMENT_NAME;
                }
                if (PlatformUtils.isJetBrainsClient()) {
                    return CWM_GUEST_EULA_NAME;
                }
                return EndUserAgreement.isEAP() ? PRIVACY_POLICY_EAP_DOCUMENT_NAME : PRIVACY_POLICY_DOCUMENT_NAME;
            }
            try {
                String docName = Files.readString(EndUserAgreement.getDocumentNameFile());
                if (docName == null || docName.isBlank()) break block6;
                string = docName;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                EndUserAgreement.$$$reportNull$$$0(12);
            }
            return string;
        }
        return EndUserAgreement.isEAP() ? "euaEap" : "eua";
    }

    @NotNull
    private static String getAcceptedVersionKey(String docName) {
        if (PRIVACY_POLICY_DOCUMENT_NAME.equals(docName)) {
            return "JetBrains.privacy_policy.accepted_version";
        }
        Object keyName = docName;
        if ("euaEap".equals(docName)) {
            keyName = "ij_" + (String)keyName;
        }
        String string = "JetBrains.privacy_policy." + (String)keyName + "_accepted_version";
        if (string == null) {
            EndUserAgreement.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentContentFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentNameFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataRoot";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDocument";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersionKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAccepted";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Document {
        private final String myName;
        private final String myText;
        private final Version myVersion;

        public Document(String name2, String text2) {
            this.myName = name2;
            this.myText = text2;
            this.myVersion = Document.parseVersion(text2);
        }

        public boolean isPrivacyPolicy() {
            return EndUserAgreement.PRIVACY_POLICY_DOCUMENT_NAME.equals(this.myName) || EndUserAgreement.PRIVACY_POLICY_EAP_DOCUMENT_NAME.equals(this.myName);
        }

        public boolean isAccepted() {
            Version thisVersion = this.getVersion();
            if (thisVersion.isUnknown() || MAGIC_VERSION.equals(thisVersion)) {
                return true;
            }
            Version acceptedByUser = EndUserAgreement.getAcceptedVersion(this.getName());
            return !acceptedByUser.isUnknown() && acceptedByUser.getMajor() >= thisVersion.getMajor();
        }

        public String getName() {
            return this.myName;
        }

        public Version getVersion() {
            return this.myVersion;
        }

        public String getText() {
            return this.myText;
        }

        @NotNull
        private static Version parseVersion(String text2) {
            if (text2 == null || text2.isBlank()) {
                Version version2 = Version.UNKNOWN;
                if (version2 == null) {
                    Document.$$$reportNull$$$0(0);
                }
                return version2;
            }
            Iterator iterator2 = text2.lines().iterator();
            while (iterator2.hasNext()) {
                int endComment;
                String line = (String)iterator2.next();
                int startComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_START);
                if (startComment < 0 || (endComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_END)) <= startComment) continue;
                Version version3 = Version.fromString(line.substring(startComment + EndUserAgreement.VERSION_COMMENT_START.length(), endComment).trim());
                if (version3 == null) {
                    Document.$$$reportNull$$$0(1);
                }
                return version3;
            }
            Version version4 = Version.UNKNOWN;
            if (version4 == null) {
                Document.$$$reportNull$$$0(2);
            }
            return version4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/EndUserAgreement$Document", "parseVersion"));
        }
    }
}

