/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataValidators {
    private static final Logger LOG = Logger.getInstance(DataValidators.class);
    public static final ExtensionPointName<DataValidators> EP_NAME = ExtensionPointName.create((String)"com.intellij.dataValidators");
    private static final Map<String, Validator<?>[]> ourValidators = new ConcurrentHashMap<String, Validator<?>[]>();

    public abstract void collectValidators(@NotNull Registry var1);

    @NotNull
    public static <T> Validator<T[]> arrayValidator(@NotNull Validator<? super T> validator2) {
        if (validator2 == null) {
            DataValidators.$$$reportNull$$$0(0);
        }
        Validator<T[]> validator3 = (data2, dataId, source) -> {
            for (Object element2 : data2) {
                if (element2 == null) {
                    Object notNull = ContainerUtil.find((Object[])data2, (Condition)Conditions.notNull());
                    LOG.error("Array with null provided by " + source.getClass().getName() + ".getData(\"" + dataId + "\"): " + data2.getClass().getComponentType().getName() + "[" + ((Object[])data2).length + "] {" + (notNull == null ? null : notNull.getClass().getName()) + (((Object[])data2).length > 1 ? ", ..." : "") + "}");
                    return false;
                }
                if (validator2.checkValid(element2, dataId, source)) continue;
                return false;
            }
            return true;
        };
        if (validator3 == null) {
            DataValidators.$$$reportNull$$$0(1);
        }
        return validator3;
    }

    @Nullable
    public static Object validOrNull(@NotNull Object data2, @NotNull String dataId, @NotNull Object source) {
        if (data2 == null) {
            DataValidators.$$$reportNull$$$0(2);
        }
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(3);
        }
        if (source == null) {
            DataValidators.$$$reportNull$$$0(4);
        }
        return DataValidators.isDataValid(data2, dataId, source) ? data2 : null;
    }

    private static boolean isDataValid(@NotNull Object data2, @NotNull String dataId, @NotNull Object source) {
        Validator<?>[] validators;
        if (data2 == null) {
            DataValidators.$$$reportNull$$$0(5);
        }
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(6);
        }
        if (source == null) {
            DataValidators.$$$reportNull$$$0(7);
        }
        if ((validators = DataValidators.getValidators(dataId)) == null) {
            return true;
        }
        try {
            for (Validator<?> validator2 : validators) {
                if (validator2.checkValid(data2, dataId, source)) continue;
                return false;
            }
        }
        catch (ClassCastException ex) {
            LOG.error("Object of incorrect type provided by " + source.getClass().getName() + ".getData(\"" + dataId + "\")");
            return false;
        }
        return true;
    }

    static Validator<?> @Nullable [] getValidators(@NotNull String dataId) {
        Validator<?>[] result2;
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(8);
        }
        if ((result2 = ourValidators.get(dataId)) != null || !ourValidators.isEmpty()) {
            return result2;
        }
        final Map map2 = FactoryMap.create(__ -> new ArrayList());
        Registry registry = new Registry(){

            @Override
            public <T> void register(@NotNull DataKey<T> key, @NotNull Validator<? super T> validator2) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (validator2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ((List)map2.get(key.getName())).add(validator2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "validator";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/impl/DataValidators$2";
                objectArray[2] = "register";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (DataValidators validators : EP_NAME.getExtensionList()) {
            validators.collectValidators(registry);
        }
        Validator[] emptyArray = new Validator[]{};
        for (String s : map2.keySet()) {
            ourValidators.put(s, ((List)map2.get(s)).toArray(emptyArray));
        }
        return ourValidators.get(dataId);
    }

    static {
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DataValidators>(){

            public void extensionAdded(@NotNull DataValidators extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ourValidators.clear();
            }

            public void extensionRemoved(@NotNull DataValidators extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ourValidators.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/impl/DataValidators$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/DataValidators";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/DataValidators";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "arrayValidator";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validOrNull";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDataValid";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValidators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Registry {
        public <T> void register(@NotNull DataKey<T> var1, @NotNull Validator<? super T> var2);
    }

    public static interface Validator<T> {
        public boolean checkValid(@NotNull T var1, @NotNull String var2, @NotNull Object var3);
    }
}

