/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenResult;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.ide.impl.SelectProjectOpenProcessorDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.SystemDependent;

public final class ProjectUtil
extends ProjectUtilCore {
    private static final Logger LOG = Logger.getInstance(ProjectUtil.class);
    public static final String DEFAULT_PROJECT_NAME = "default";
    public static final String PROJECTS_DIR = "projects";
    public static final String PROPERTY_PROJECT_PATH = "%s.project.path";
    private static String ourProjectsPath;

    private ProjectUtil() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void updateLastProjectLocation(@NotNull String projectFilePath) {
        if (projectFilePath == null) {
            ProjectUtil.$$$reportNull$$$0(0);
        }
        ProjectUtil.updateLastProjectLocation(Paths.get(projectFilePath, new String[0]));
    }

    public static void updateLastProjectLocation(@NotNull Path lastProjectLocation) {
        if (lastProjectLocation == null) {
            ProjectUtil.$$$reportNull$$$0(1);
        }
        if (Files.isRegularFile(lastProjectLocation, new LinkOption[0])) {
            lastProjectLocation = lastProjectLocation.getParent();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParent()) == null) {
            return;
        }
        String path2 = lastProjectLocation.toString();
        try {
            path2 = FileUtil.resolveShortWindowsName((String)path2);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)path2));
    }

    @Deprecated
    public static boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(2);
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project);
    }

    public static Project openOrImport(@NotNull Path path2, Project projectToClose, boolean forceOpenInNewFrame) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(3);
        }
        return ProjectUtil.openOrImport(path2, OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    public static Project openOrImport(@NotNull Path path2) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(4);
        }
        return ProjectUtil.openOrImport(path2, new OpenProjectTask());
    }

    @Nullable
    public static Project openOrImport(@NotNull String path2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(5);
        }
        return ProjectUtil.openOrImport(Paths.get(path2, new String[0]), OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    @Nullable
    public static Project openOrImport(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        OpenResult openResult;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(6);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(7);
        }
        if ((openResult = ProjectUtil.tryOpenOrImport(file2, options2)) instanceof OpenResult.Success) {
            return ((OpenResult.Success)openResult).getProject();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @ApiStatus.Experimental
    @NotNull
    public static OpenResult tryOpenOrImport(@NotNull Path file, @NotNull OpenProjectTask options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static OpenResult openResult(@Nullable Project project, @NotNull OpenResult alternative) {
        if (alternative == null) {
            ProjectUtil.$$$reportNull$$$0(16);
        }
        OpenResult openResult = project != null ? new OpenResult.Success(project) : alternative;
        if (openResult == null) {
            ProjectUtil.$$$reportNull$$$0(17);
        }
        return openResult;
    }

    /*
     * Exception decompiling
     */
    public static @NotNull CompletableFuture<@Nullable Project> openOrImportAsync(@NotNull Path file, @NotNull OpenProjectTask options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static List<ProjectOpenProcessor> computeProcessors(@NotNull Path file2, @NotNull NullableLazyValue<? extends VirtualFile> lazyVirtualFile) {
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(27);
        }
        if (lazyVirtualFile == null) {
            ProjectUtil.$$$reportNull$$$0(28);
        }
        SmartList processors = new SmartList();
        ProjectOpenProcessor.EXTENSION_POINT_NAME.forEachExtensionSafe(arg_0 -> ProjectUtil.lambda$computeProcessors$4(file2, (List)processors, lazyVirtualFile, arg_0));
        SmartList smartList = processors;
        if (smartList == null) {
            ProjectUtil.$$$reportNull$$$0(29);
        }
        return smartList;
    }

    @Nullable
    private static Project postProcess(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed(), () -> {
            ToolWindow toolWindow2 = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
            if (toolWindow2 != null) {
                toolWindow2.activate(null);
            }
        }));
        return project;
    }

    @Nullable
    private static Project chooseProcessorAndOpen(@NotNull List<? extends ProjectOpenProcessor> processors, @NotNull VirtualFile virtualFile2, @NotNull OpenProjectTask options2) {
        ProjectOpenProcessor processor2;
        if (processors == null) {
            ProjectUtil.$$$reportNull$$$0(30);
        }
        if (virtualFile2 == null) {
            ProjectUtil.$$$reportNull$$$0(31);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(32);
        }
        if (processors.size() == 1) {
            processor2 = processors.get(0);
        } else {
            processors.removeIf(it -> it instanceof PlatformProjectOpenProcessor);
            if (processors.size() == 1) {
                processor2 = processors.get(0);
            } else if (options2.getOpenProcessorChooser() != null) {
                LOG.info("options.openProcessorChooser will handle the open processor dilemma");
                processor2 = (ProjectOpenProcessor)options2.getOpenProcessorChooser().invoke(processors);
            } else {
                Ref ref = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)SelectProjectOpenProcessorDialog.showAndGetChoice(processors, virtualFile2)));
                processor2 = (ProjectOpenProcessor)ref.get();
                if (processor2 == null) {
                    return null;
                }
            }
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)processor2.doOpenProject(virtualFile2, options2.getProjectToClose(), options2.getForceOpenInNewFrame())));
        return (Project)result2.get();
    }

    private static @NotNull CompletableFuture<@Nullable Project> chooseProcessorAndOpenAsync(@NotNull List<ProjectOpenProcessor> processors, @NotNull VirtualFile virtualFile2, @NotNull OpenProjectTask options2) {
        CompletableFuture<ProjectOpenProcessor> processorFuture;
        if (processors == null) {
            ProjectUtil.$$$reportNull$$$0(33);
        }
        if (virtualFile2 == null) {
            ProjectUtil.$$$reportNull$$$0(34);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(35);
        }
        if (processors.size() == 1) {
            processorFuture = CompletableFuture.completedFuture(processors.get(0));
        } else {
            processors.removeIf(it -> it instanceof PlatformProjectOpenProcessor);
            if (processors.size() == 1) {
                processorFuture = CompletableFuture.completedFuture(processors.get(0));
            } else if (options2.getOpenProcessorChooser() != null) {
                LOG.info("options.openProcessorChooser will handle the open processor dilemma");
                processorFuture = CompletableFuture.completedFuture((ProjectOpenProcessor)options2.getOpenProcessorChooser().invoke(processors));
            } else {
                processorFuture = CompletableFuture.supplyAsync(() -> SelectProjectOpenProcessorDialog.showAndGetChoice(processors, virtualFile2), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0));
            }
        }
        CompletionStage completionStage = processorFuture.thenCompose(processor2 -> {
            if (processor2 == null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture future2 = processor2.openProjectAsync(virtualFile2, options2.getProjectToClose(), options2.getForceOpenInNewFrame());
            if (future2 != null) {
                return future2;
            }
            return CompletableFuture.supplyAsync(() -> processor2.doOpenProject(virtualFile2, options2.getProjectToClose(), options2.getForceOpenInNewFrame()), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0));
        });
        if (completionStage == null) {
            ProjectUtil.$$$reportNull$$$0(36);
        }
        return completionStage;
    }

    @Nullable
    public static Project openProject(@NotNull String path2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(37);
        }
        return ProjectUtil.openProject(Paths.get(path2, new String[0]), OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    @Nullable
    public static Project openProject(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        Path dir;
        BasicFileAttributes fileAttributes;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(38);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(39);
        }
        if ((fileAttributes = PathKt.basicAttributesIfExists((Path)file2)) == null) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{file2.toString()}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(file2);
        if (existing != null) {
            return existing;
        }
        if (ProjectUtil.isRemotePath(file2.toString()) && !RecentProjectsManager.getInstance().hasPath(FileUtil.toSystemIndependentName((String)file2.toString())) && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        if (options2.getUntrusted() && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.open.file.from.untrusted.source", "title.open.file.from.untrusted.source")) {
            return null;
        }
        if (fileAttributes.isDirectory() && !Files.isDirectory(dir = file2.resolve(".idea"), new LinkOption[0])) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{dir.toString()}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        try {
            return ProjectManagerEx.getInstanceEx().openProject(file2, options2);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path2, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(40);
        }
        if (msgKey == null) {
            ProjectUtil.$$$reportNull$$$0(41);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(42);
        }
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path2}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull @Nls String message2, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (message2 == null) {
            ProjectUtil.$$$reportNull$$$0(43);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(44);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)titleKey, (Object[])new Object[0]), (String)message2).icon(Messages.getWarningIcon())).ask((Component)ProjectUtil.getActiveFrameOrWelcomeScreen());
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path2) {
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(45);
        }
        return path2.contains("://") || path2.contains("\\\\");
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(@NotNull Path file2) {
        Project[] openProjects;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(46);
        }
        if ((openProjects = ProjectUtil.getOpenProjects()).length == 0) {
            return null;
        }
        for (Project project : openProjects) {
            if (!ProjectUtil.isSameProject(file2, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        return ProjectUtil.confirmOpenNewProject(isNewProject, null);
    }

    public static int confirmOpenNewProject(boolean isNewProject, @Nullable String projectName) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return 0;
        }
        int mode = GeneralSettings.getInstance().getConfirmOpenNewProject();
        if (mode == -1) {
            String message2;
            String string = message2 = projectName == null ? IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]) : IdeBundle.message((String)"prompt.open.project.with.name.in.new.frame", (Object[])new Object[]{projectName});
            if (isNewProject) {
                boolean openInExistingFrame = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeCoreBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)message2).yesText(IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]))).doNotAsk((DoNotAskOption)new ProjectNewWindowDoNotAskOption())).guessWindowAndAsk();
                mode = openInExistingFrame ? 1 : 0;
            } else {
                int exitCode = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)message2).yesText(IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]))).doNotAsk((DoNotAskOption)new ProjectNewWindowDoNotAskOption())).guessWindowAndAsk();
                int n = exitCode == 0 ? 1 : (mode = exitCode == 1 ? 0 : 2);
            }
            if (mode != 2) {
                LifecycleUsageTriggerCollector.onProjectFrameSelected(mode);
            }
        }
        return mode;
    }

    public static int confirmOpenOrAttachProject() {
        int mode = GeneralSettings.getInstance().getConfirmOpenNewProject();
        if (mode == -1) {
            int exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.or.attach", (Object[])new Object[0]), (String)IdeBundle.message((String)"prompt.open.project.or.attach.title", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"prompt.open.project.or.attach.button.this.window", (Object[])new Object[0]), IdeBundle.message((String)"prompt.open.project.or.attach.button.new.window", (Object[])new Object[0]), IdeBundle.message((String)"prompt.open.project.or.attach.button.attach", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            int n = exitCode == 0 ? 1 : (exitCode == 1 ? 0 : (mode = exitCode == 2 ? 2 : -1));
            if (mode != -1) {
                LifecycleUsageTriggerCollector.onProjectFrameSelected(mode);
            }
        }
        return mode;
    }

    @Deprecated
    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(47);
        }
        return projectFilePath != null && ProjectUtil.isSameProject(Paths.get(projectFilePath, new String[0]), project);
    }

    public static boolean isSameProject(@NotNull Path projectFile, @NotNull Project project) {
        IProjectStore projectStore;
        Path existingBaseDirPath;
        if (projectFile == null) {
            ProjectUtil.$$$reportNull$$$0(48);
        }
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(49);
        }
        if ((existingBaseDirPath = (projectStore = ProjectKt.getStateStore(project)).getProjectBasePath()).getFileSystem() != projectFile.getFileSystem()) {
            return false;
        }
        if (Files.isDirectory(projectFile, new LinkOption[0])) {
            try {
                return Files.isSameFile(projectFile, existingBaseDirPath);
            }
            catch (IOException ignore) {
                return false;
            }
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            try {
                return Files.isSameFile(projectFile, projectStore.getProjectFilePath());
            }
            catch (IOException ignore) {
                return false;
            }
        }
        Path parent = projectFile.getParent();
        if (parent == null) {
            return false;
        }
        Path parentFileName = parent.getFileName();
        if (parentFileName != null && parentFileName.toString().equals(".idea")) {
            return (parent = parent.getParent()) != null && FileUtil.pathsEqual((String)parent.toString(), (String)existingBaseDirPath.toString());
        }
        return projectFile.getFileName().toString().endsWith(".ipr") && FileUtil.pathsEqual((String)parent.toString(), (String)existingBaseDirPath.toString());
    }

    public static void focusProjectWindow(@Nullable Project project, boolean stealFocusIfAppInactive) {
        int state;
        boolean appIsActive;
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (frame == null) {
            return;
        }
        boolean bl = appIsActive = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != null;
        if ((SystemInfo.isWindows || SystemInfo.isXWindow && appIsActive) && ((state = frame.getExtendedState()) & 1) != 0) {
            frame.setExtendedState(state & 0xFFFFFFFE);
        }
        if (stealFocusIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)frame);
        } else {
            if (!SystemInfo.isXWindow || appIsActive) {
                frame.toFront();
            }
            if (!SystemInfo.isWindows) {
                AppIcon.getInstance().requestAttention(project, true);
            }
        }
    }

    @NotNull
    public static String getBaseDir() {
        String defaultDirectory = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (Strings.isNotEmpty((String)defaultDirectory)) {
            String string = defaultDirectory.replace('/', File.separatorChar);
            if (string == null) {
                ProjectUtil.$$$reportNull$$$0(50);
            }
            return string;
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            String string = lastProjectLocation.replace('/', File.separatorChar);
            if (string == null) {
                ProjectUtil.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = ProjectUtil.getUserHomeProjectDir();
        if (string == null) {
            ProjectUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    private static String getUserHomeProjectDir() {
        String productName = PlatformUtils.isCLion() || PlatformUtils.isAppCode() || PlatformUtils.isDataGrip() ? ApplicationNamesInfo.getInstance().getProductName() : ApplicationNamesInfo.getInstance().getLowercaseProductName();
        return SystemProperties.getUserHome().replace('/', File.separatorChar) + File.separator + productName + "Projects";
    }

    @Nullable
    public static Project tryOpenFiles(@Nullable Project project, @NotNull List<? extends Path> list2, String location) {
        if (list2 == null) {
            ProjectUtil.$$$reportNull$$$0(53);
        }
        try {
            for (Path path2 : list2) {
                OpenResult openResult = ProjectUtil.tryOpenOrImport(path2.toAbsolutePath(), OpenProjectTask.withProjectToClose(project, true));
                if (openResult instanceof OpenResult.Success) {
                    LOG.debug(location + ": load project from ", new Object[]{path2});
                    return ((OpenResult.Success)openResult).getProject();
                }
                if (!(openResult instanceof OpenResult.Cancel)) continue;
                LOG.debug(location + ": canceled project opening");
                return null;
            }
        }
        catch (ProcessCanceledException ex) {
            LOG.debug(location + ": skip project opening");
            return null;
        }
        Project result2 = null;
        for (Path path3 : list2) {
            Project opened;
            if (!Files.exists(path3, new LinkOption[0])) continue;
            LOG.debug(location + ": open file ", new Object[]{path3});
            if (project != null) {
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtilRt.toSystemIndependentName((String)path3.toString()));
                if (virtualFile2 != null && virtualFile2.isValid()) {
                    OpenFileAction.openFile(virtualFile2, project);
                }
                result2 = project;
                continue;
            }
            CommandLineProjectOpenProcessor processor2 = CommandLineProjectOpenProcessor.getInstanceIfExists();
            if (processor2 == null || (opened = processor2.openProjectAndFile(path3, -1, -1, false)) == null || result2 != null) continue;
            result2 = opened;
        }
        return result2;
    }

    @NotNull
    public static @SystemDependent String getProjectsPath() {
        String fromSettings;
        Application application = ApplicationManager.getApplication();
        String string = fromSettings = application == null || application.isHeadlessEnvironment() ? null : GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (StringUtil.isNotEmpty((String)fromSettings)) {
            String string2 = PathManager.getAbsolutePath((String)fromSettings);
            if (string2 == null) {
                ProjectUtil.$$$reportNull$$$0(54);
            }
            return string2;
        }
        if (ourProjectsPath == null) {
            String produceName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.ENGLISH);
            String propertyName = String.format(PROPERTY_PROJECT_PATH, produceName);
            String propertyValue = System.getProperty(propertyName);
            ourProjectsPath = propertyValue != null ? PathManager.getAbsolutePath((String)StringUtil.unquoteString((String)propertyValue, (char)'\"')) : ProjectUtil.getProjectsDirDefault();
        }
        String string3 = ourProjectsPath;
        if (string3 == null) {
            ProjectUtil.$$$reportNull$$$0(55);
        }
        return string3;
    }

    @NotNull
    private static String getProjectsDirDefault() {
        if (PlatformUtils.isDataGrip()) {
            String string = ProjectUtil.getUserHomeProjectDir();
            if (string == null) {
                ProjectUtil.$$$reportNull$$$0(56);
            }
            return string;
        }
        String string = PathManager.getConfigPath() + File.separator + PROJECTS_DIR;
        if (string == null) {
            ProjectUtil.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static Path getProjectPath(@NotNull String name2) {
        if (name2 == null) {
            ProjectUtil.$$$reportNull$$$0(58);
        }
        Path path2 = Paths.get(ProjectUtil.getProjectsPath(), name2);
        if (path2 == null) {
            ProjectUtil.$$$reportNull$$$0(59);
        }
        return path2;
    }

    @Nullable
    public static Path getProjectFile(@NotNull String name2) {
        Path projectDir;
        if (name2 == null) {
            ProjectUtil.$$$reportNull$$$0(60);
        }
        return Files.isDirectory((projectDir = ProjectUtil.getProjectPath(name2)).resolve(".idea"), new LinkOption[0]) ? projectDir : null;
    }

    @Nullable
    public static Project openOrCreateProject(@NotNull String name2) {
        if (name2 == null) {
            ProjectUtil.$$$reportNull$$$0(61);
        }
        return ProjectUtil.openOrCreateProject(name2, null);
    }

    @Nullable
    public static Project openOrCreateProject(@NotNull String name2, @Nullable ProjectCreatedCallback projectCreatedCallback) {
        if (name2 == null) {
            ProjectUtil.$$$reportNull$$$0(62);
        }
        return (Project)ProgressManager.getInstance().computeInNonCancelableSection(() -> ProjectUtil.openOrCreateProjectInner(name2, projectCreatedCallback));
    }

    @NotNull
    public static Set<String> getExistingProjectNames() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        File file2 = new File(ProjectUtil.getProjectsPath());
        for (String name2 : (String[])ObjectUtils.notNull((Object)file2.list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY)) {
            if (ProjectUtil.getProjectFile(name2) == null) continue;
            result2.add(name2);
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            ProjectUtil.$$$reportNull$$$0(63);
        }
        return linkedHashSet;
    }

    @Nullable
    private static Project openOrCreateProjectInner(@NotNull String name2, @Nullable ProjectCreatedCallback projectCreatedCallback) {
        Project project;
        boolean created;
        Path existingFile;
        if (name2 == null) {
            ProjectUtil.$$$reportNull$$$0(64);
        }
        if ((existingFile = ProjectUtil.getProjectFile(name2)) != null) {
            Project[] openProjects;
            for (Project p : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (p.isDefault() || !ProjectUtil.isSameProject(existingFile, p)) continue;
                ProjectUtil.focusProjectWindow(p, false);
                return p;
            }
            return ProjectManagerEx.getInstanceEx().openProject(existingFile, new OpenProjectTask().withRunConfigurators());
        }
        Path file2 = ProjectUtil.getProjectPath(name2);
        try {
            created = !Files.exists(file2, new LinkOption[0]) && Files.createDirectories(file2, new FileAttribute[0]) != null || Files.isDirectory(file2, new LinkOption[0]);
        }
        catch (IOException e) {
            created = false;
        }
        Path projectFile = null;
        if (created && (project = ProjectManagerEx.getInstanceEx().newProject(file2, OpenProjectTask.newProject(true).withProjectName(name2))) != null) {
            if (projectCreatedCallback != null) {
                projectCreatedCallback.projectCreated(project);
            }
            ProjectUtil.saveAndDisposeProject(project);
            projectFile = ProjectUtil.getProjectFile(name2);
        }
        if (projectFile == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProject(projectFile, OpenProjectTask.fromWizardAndRunConfigurators());
    }

    private static void saveAndDisposeProject(@NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(65);
        }
        StoreUtil.saveSettings((ComponentManager)project, true);
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> Disposer.dispose((Disposable)project)));
    }

    private static /* synthetic */ void lambda$computeProcessors$4(Path file2, List processors, NullableLazyValue lazyVirtualFile, ProjectOpenProcessor processor2) {
        if (processor2 instanceof PlatformProjectOpenProcessor) {
            if (Files.isDirectory(file2, new LinkOption[0])) {
                processors.add(processor2);
            }
        } else {
            VirtualFile virtualFile2 = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile2 != null && processor2.canOpenProject(virtualFile2)) {
                processors.add(processor2);
            }
        }
    }

    private static /* synthetic */ boolean lambda$openOrImportAsync$3(Project p) {
        p.putUserData(PlatformProjectOpenProcessor.PROJECT_OPENED_BY_PLATFORM_PROCESSOR, (Object)Boolean.TRUE);
        return true;
    }

    private static /* synthetic */ VirtualFile lambda$openOrImportAsync$2(Path file2) {
        return ProjectUtil.getFileAndRefresh(file2);
    }

    private static /* synthetic */ boolean lambda$tryOpenOrImport$1(Project p) {
        p.putUserData(PlatformProjectOpenProcessor.PROJECT_OPENED_BY_PLATFORM_PROCESSOR, (Object)Boolean.TRUE);
        return true;
    }

    private static /* synthetic */ VirtualFile lambda$tryOpenOrImport$0(Path file2) {
        return ProjectUtil.getFileAndRefresh(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 36: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 36: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastProjectLocation";
                break;
            }
            case 2: 
            case 47: 
            case 49: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 37: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 8: 
            case 18: 
            case 27: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 19: 
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 36: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/ProjectUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternative";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyVirtualFile";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgKey";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/ProjectUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryOpenOrImport";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "openResult";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "openOrImportAsync";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProcessors";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseProcessorAndOpenAsync";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDir";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsPath";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsDirDefault";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProjectNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateLastProjectLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDispose";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openOrImport";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryOpenOrImport";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 36: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 63: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openResult";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "openOrImportAsync";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "computeProcessors";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "chooseProcessorAndOpen";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "chooseProcessorAndOpenAsync";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "confirmLoadingFromRemotePath";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isRemotePath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findAndFocusExistingProjectForPath";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isSameProject";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "tryOpenFiles";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPath";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getProjectFile";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "openOrCreateProject";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "openOrCreateProjectInner";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "saveAndDisposeProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 36: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectCreatedCallback {
        public void projectCreated(Project var1);
    }
}

