/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ModuleStructureComponent;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.LangBundle;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureViewWrapperImpl
implements StructureViewWrapper,
Disposable {
    public static final Topic<Runnable> STRUCTURE_CHANGED = new Topic("structure view changed", Runnable.class, Topic.BroadcastDirection.NONE);
    @ApiStatus.Experimental
    public static final DataKey<Optional<VirtualFile>> STRUCTURE_VIEW_TARGET_FILE_KEY = DataKey.create("STRUCTURE_VIEW_TARGET_FILE_KEY");
    private static final Logger LOG = Logger.getInstance(StructureViewWrapperImpl.class);
    private static final DataKey<StructureViewWrapper> WRAPPER_DATA_KEY = DataKey.create("WRAPPER_DATA_KEY");
    private static final int REFRESH_TIME = 100;
    private static final int REBUILD_TIME = 100;
    private final Project myProject;
    private final ToolWindow myToolWindow;
    private VirtualFile myFile;
    private StructureView myStructureView;
    private FileEditor myFileEditor;
    private ModuleStructureComponent myModuleStructureComponent;
    private JPanel[] myPanels;
    private final MergingUpdateQueue myUpdateQueue;
    private Runnable myPendingSelection;
    private boolean myFirstRun;
    private int myActivityCount;

    public StructureViewWrapperImpl(@NotNull Project project, @NotNull ToolWindow toolWindow2) {
        if (project == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(0);
        }
        if (toolWindow2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(1);
        }
        this.myPanels = new JPanel[0];
        this.myFirstRun = true;
        this.myProject = project;
        this.myToolWindow = toolWindow2;
        JComponent component2 = toolWindow2.getComponent();
        if (ProjectManagerImpl.isLight(project)) {
            LOG.error("StructureViewWrapperImpl must be not created for light project.");
        }
        this.myUpdateQueue = new MergingUpdateQueue("StructureView", 100, false, component2, (Disposable)this, component2).usePassThroughInUnitTestMode();
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        final Timer timer2 = TimerUtil.createNamedTimer((String)"StructureView", (int)100, event -> {
            if (!component2.isShowing()) {
                return;
            }
            int count = ActivityTracker.getInstance().getCount();
            if (count == this.myActivityCount) {
                return;
            }
            ModalityState state = ModalityState.stateForComponent((Component)component2);
            if (ModalityState.current().dominates(state)) {
                return;
            }
            boolean successful = StructureViewWrapperImpl.loggedRun("check if update needed", this::checkUpdate);
            if (successful) {
                this.myActivityCount = count;
            }
        });
        LOG.debug("timer to check if update needed: add");
        timer2.start();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                LOG.debug("timer to check if update needed: remove");
                timer2.stop();
            }
        });
        component2.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (BitUtil.isSet((long)e.getChangeFlags(), (long)2L)) {
                    boolean visible = StructureViewWrapperImpl.this.myToolWindow.isVisible();
                    LOG.debug("displayability changed: " + visible);
                    if (visible) {
                        StructureViewWrapperImpl.loggedRun("update file", () -> StructureViewWrapperImpl.this.checkUpdate());
                        StructureViewWrapperImpl.this.scheduleRebuild();
                    } else if (!StructureViewWrapperImpl.this.myProject.isDisposed()) {
                        StructureViewWrapperImpl.this.myFile = null;
                        StructureViewWrapperImpl.loggedRun("clear a structure on hide", StructureViewWrapperImpl.this::rebuild);
                    }
                }
            }
        });
        if (component2.isShowing()) {
            StructureViewWrapperImpl.loggedRun("initial structure rebuild", this::checkUpdate);
            this.scheduleRebuild();
        }
        this.myToolWindow.getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (StructureViewWrapperImpl.this.myStructureView instanceof StructureViewComposite) {
                    StructureViewComposite.StructureViewDescriptor[] views;
                    for (StructureViewComposite.StructureViewDescriptor view : views = ((StructureViewComposite)StructureViewWrapperImpl.this.myStructureView).getStructureViews()) {
                        if (!view.title.equals(event.getContent().getTabName())) continue;
                        StructureViewWrapperImpl.this.updateHeaderActions(view.structureView);
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/impl/StructureViewWrapperImpl$3", "selectionChanged"));
            }
        });
        Disposer.register((Disposable)this.myToolWindow.getContentManager(), (Disposable)this);
        PsiStructureViewFactory.EP_NAME.addChangeListener(this::clearCaches, (Disposable)this);
        StructureViewBuilder.EP_NAME.addChangeListener(this::clearCaches, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(STRUCTURE_CHANGED, this::clearCaches);
    }

    private void clearCaches() {
        StructureViewComponent.clearStructureViewState(this.myProject);
        if (this.myStructureView != null) {
            this.myStructureView.disableStoreState();
        }
        this.rebuild();
    }

    private void checkUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean insideToolwindow = SwingUtilities.isDescendingFrom(this.myToolWindow.getComponent(), owner);
        if (insideToolwindow) {
            LOG.debug("inside structure view");
        }
        if (!this.myFirstRun && (insideToolwindow || JBPopupFactory.getInstance().isPopupActive())) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(owner);
        if (WRAPPER_DATA_KEY.getData(dataContext) == this) {
            return;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        if (insideToolwindow) {
            if (this.myFirstRun) {
                this.setFileFromSelectionHistory();
                this.myFirstRun = false;
            }
        } else {
            DataContext asyncDataContext = Utils.wrapDataContext(dataContext);
            ReadAction.nonBlocking(() -> StructureViewWrapperImpl.getTargetVirtualFile(asyncDataContext)).coalesceBy(new Object[]{this, owner}).finishOnUiThread(ModalityState.defaultModalityState(), file2 -> {
                if (file2 != null) {
                    this.setFile((VirtualFile)file2);
                } else if (this.myFirstRun) {
                    this.setFileFromSelectionHistory();
                } else {
                    this.setFile(null);
                }
                this.myFirstRun = false;
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    @Nullable
    private static VirtualFile getTargetVirtualFile(@NotNull DataContext asyncDataContext) {
        Optional<VirtualFile> explicitlySpecifiedFile;
        if (asyncDataContext == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(2);
        }
        if ((explicitlySpecifiedFile = STRUCTURE_VIEW_TARGET_FILE_KEY.getData(asyncDataContext)) != null) {
            return explicitlySpecifiedFile.orElse(null);
        }
        VirtualFile[] commonFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(asyncDataContext);
        return commonFiles != null && commonFiles.length == 1 ? commonFiles[0] : null;
    }

    private void setFileFromSelectionHistory() {
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myProject);
        List<Pair<VirtualFile, EditorWindow>> history2 = editorManager.getSelectionHistory();
        if (!history2.isEmpty()) {
            this.setFile((VirtualFile)history2.get(0).getFirst());
        }
    }

    private void setFile(@Nullable VirtualFile file2) {
        boolean forceRebuild;
        boolean bl = forceRebuild = !Comparing.equal((Object)file2, (Object)this.myFile);
        if (!forceRebuild && this.myStructureView != null) {
            StructureViewModel model2 = this.myStructureView.getTreeModel();
            StructureViewTreeElement treeElement = model2.getRoot();
            Object value2 = treeElement.getValue();
            if (value2 == null || value2 instanceof PsiElement && !((PsiElement)value2).isValid() || this.myStructureView instanceof StructureViewComposite && ((StructureViewComposite)this.myStructureView).isOutdated()) {
                forceRebuild = true;
            } else if (file2 != null) {
                boolean bl2 = forceRebuild = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2) != this.myFileEditor;
            }
        }
        if (forceRebuild) {
            this.myFile = file2;
            LOG.debug("show structure for file: ", new Object[]{file2});
            this.scheduleRebuild();
        }
    }

    public void dispose() {
    }

    @Override
    public boolean selectCurrentElement(FileEditor fileEditor, VirtualFile file2, boolean requestFocus) {
        Runnable runnable2 = () -> {
            if (!Comparing.equal((Object)this.myFileEditor, (Object)fileEditor)) {
                this.myFile = file2;
                LOG.debug("replace file on selection: ", new Object[]{file2});
                StructureViewWrapperImpl.loggedRun("rebuild a structure immediately: ", this::rebuild);
            }
            if (this.myStructureView != null) {
                this.myStructureView.navigateToSelectedElement(requestFocus);
            }
        };
        if (this.isStructureViewShowing()) {
            if (this.myUpdateQueue.isEmpty()) {
                runnable2.run();
            } else {
                this.myPendingSelection = runnable2;
            }
        } else {
            this.myPendingSelection = runnable2;
        }
        return true;
    }

    private void scheduleRebuild() {
        if (!this.myToolWindow.isVisible()) {
            return;
        }
        LOG.debug("request to rebuild a structure");
        this.myUpdateQueue.queue(new Update("rebuild"){

            public void run() {
                if (StructureViewWrapperImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (!ApplicationManager.getApplication().isDispatchThread()) {
                    LOG.error("EDT-based MergingUpdateQueue on background thread");
                }
                StructureViewWrapperImpl.loggedRun("rebuild a structure: ", StructureViewWrapperImpl.this::rebuild);
            }
        });
    }

    public void rebuild() {
        VirtualFile[] selectedFiles;
        if (this.myProject.isDisposed()) {
            return;
        }
        Dimension referenceSize = null;
        JComponent container = this.myToolWindow.getComponent();
        boolean wasFocused = UIUtil.isFocusAncestor((Component)container);
        if (this.myStructureView != null) {
            if (this.myStructureView instanceof StructureView.Scrollable) {
                referenceSize = ((StructureView.Scrollable)this.myStructureView).getCurrentSize();
            }
            this.myStructureView.storeState();
            Disposer.dispose((Disposable)this.myStructureView);
            this.myStructureView = null;
            this.myFileEditor = null;
        }
        if (this.myModuleStructureComponent != null) {
            Disposer.dispose((Disposable)this.myModuleStructureComponent);
            this.myModuleStructureComponent = null;
        }
        ContentManager contentManager2 = this.myToolWindow.getContentManager();
        contentManager2.removeAllContents(true);
        if (!this.isStructureViewShowing()) {
            return;
        }
        VirtualFile file2 = this.myFile;
        if (file2 == null && (selectedFiles = FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).length > 0) {
            file2 = selectedFiles[0];
        }
        String[] names2 = new String[]{""};
        if (file2 != null && file2.isValid()) {
            if (file2.isDirectory()) {
                Module module;
                if (ProjectRootsUtil.isModuleContentRoot(file2, this.myProject) && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject)) != null && !ModuleType.isInternal((Module)module)) {
                    this.myModuleStructureComponent = new ModuleStructureComponent(module);
                    this.createSinglePanel(this.myModuleStructureComponent.getComponent());
                    Disposer.register((Disposable)this, (Disposable)this.myModuleStructureComponent);
                }
            } else {
                StructureViewBuilder structureViewBuilder;
                FileEditor editor2 = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2);
                StructureViewBuilder structureViewBuilder2 = structureViewBuilder = editor2 != null && editor2.isValid() ? editor2.getStructureViewBuilder() : this.createStructureViewBuilder(file2);
                if (structureViewBuilder != null) {
                    this.myStructureView = structureViewBuilder.createStructureView(editor2, this.myProject);
                    this.myFileEditor = editor2;
                    Disposer.register((Disposable)this, (Disposable)this.myStructureView);
                    if (this.myStructureView instanceof StructureView.Scrollable) {
                        ((StructureView.Scrollable)this.myStructureView).setReferenceSizeWhileInitializing(referenceSize);
                    }
                    if (this.myStructureView instanceof StructureViewComposite) {
                        StructureViewComposite composite2 = (StructureViewComposite)this.myStructureView;
                        StructureViewComposite.StructureViewDescriptor[] views = composite2.getStructureViews();
                        this.myPanels = new JPanel[views.length];
                        names2 = new String[views.length];
                        for (int i2 = 0; i2 < this.myPanels.length; ++i2) {
                            this.myPanels[i2] = this.createContentPanel(views[i2].structureView.getComponent());
                            names2[i2] = views[i2].title;
                        }
                    } else {
                        this.createSinglePanel(this.myStructureView.getComponent());
                    }
                    this.myStructureView.restoreState();
                    this.myStructureView.centerSelectedRow();
                }
            }
        }
        this.updateHeaderActions(this.myStructureView);
        if (this.myModuleStructureComponent == null && this.myStructureView == null) {
            JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText(){

                public Color getBackground() {
                    return UIUtil.getTreeBackground();
                }
            };
            panel2.getEmptyText().setText(LangBundle.message((String)"panel.empty.text.no.structure", (Object[])new Object[0]));
            this.createSinglePanel((JComponent)panel2);
        }
        for (int i3 = 0; i3 < this.myPanels.length; ++i3) {
            Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myPanels[i3], names2[i3], false);
            contentManager2.addContent(content2);
            if (i3 != 0 || this.myStructureView == null) continue;
            Disposer.register((Disposable)content2, (Disposable)this.myStructureView);
        }
        if (this.myPendingSelection != null) {
            Runnable selection = this.myPendingSelection;
            this.myPendingSelection = null;
            selection.run();
        }
        if (wasFocused) {
            Component component2;
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            Component component3 = component2 = policy == null ? null : policy.getDefaultComponent(container);
            if (component2 != null) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject(component2, this.myProject);
            }
        }
    }

    private void updateHeaderActions(@Nullable StructureView structureView) {
        List<Object> titleActions = Collections.emptyList();
        if (structureView instanceof StructureViewComponent) {
            JTree tree = ((StructureViewComponent)structureView).getTree();
            CommonActionsManager commonActionManager = CommonActionsManager.getInstance();
            titleActions = Arrays.asList(commonActionManager.createExpandAllHeaderAction(tree), commonActionManager.createCollapseAllHeaderAction(tree));
        }
        this.myToolWindow.setTitleActions(titleActions);
    }

    private void createSinglePanel(JComponent component2) {
        this.myPanels = new JPanel[1];
        this.myPanels[0] = this.createContentPanel(component2);
    }

    private ContentPanel createContentPanel(JComponent component2) {
        ContentPanel panel2 = new ContentPanel();
        panel2.setBackground(UIUtil.getTreeBackground());
        panel2.add((Component)component2, "Center");
        return panel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StructureViewBuilder createStructureViewBuilder(@NotNull VirtualFile file2) {
        FileEditorProvider provider2;
        if (file2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(3);
        }
        if (file2.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize()) {
            return null;
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
        FileEditorProvider fileEditorProvider = provider2 = providers.length == 0 ? null : providers[0];
        if (provider2 == null) {
            return null;
        }
        if (provider2 instanceof TextEditorProvider) {
            return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
        }
        FileEditor editor2 = provider2.createEditor(this.myProject, file2);
        try {
            StructureViewBuilder structureViewBuilder = editor2.getStructureViewBuilder();
            return structureViewBuilder;
        }
        finally {
            Disposer.dispose((Disposable)editor2);
        }
    }

    private boolean isStructureViewShowing() {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow2 = windowManager.getToolWindow("Structure");
        return toolWindow2 != null && toolWindow2.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loggedRun(@NotNull String message2, @NotNull Runnable task2) {
        if (message2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(4);
        }
        if (task2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(5);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message2 + ": started");
            }
            task2.run();
            boolean bl = true;
            return bl;
        }
        catch (ProcessCanceledException exception) {
            LOG.debug(message2, new Object[]{": canceled"});
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            LOG.warn(message2, throwable);
            boolean bl = false;
            return bl;
        }
        finally {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message2 + ": finished");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncDataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/StructureViewWrapperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStructureViewBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loggedRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ContentPanel
    extends JPanel
    implements DataProvider {
        ContentPanel() {
            super(new BorderLayout());
        }

        @Override
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ContentPanel.$$$reportNull$$$0(0);
            }
            if (WRAPPER_DATA_KEY.is(dataId)) {
                return StructureViewWrapperImpl.this;
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return StructureViewWrapperImpl.this.myStructureView instanceof QuickActionProvider ? StructureViewWrapperImpl.this.myStructureView : null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/StructureViewWrapperImpl$ContentPanel", "getData"));
        }
    }
}

