/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.lightEdit.LightEditConfiguration;
import com.intellij.ide.lightEdit.LightEditConfirmationDialog;
import com.intellij.ide.lightEdit.LightEditFrameWrapper;
import com.intellij.ide.lightEdit.LightEditPanel;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceListener;
import com.intellij.ide.lightEdit.LightEditTabs;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.ide.lightEdit.project.LightEditProjectManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="LightEdit", storages={@Storage(value="lightEdit.xml", roamingType=RoamingType.DISABLED)})
public final class LightEditServiceImpl
implements LightEditService,
Disposable,
LightEditorListener,
AppLifecycleListener,
PersistentStateComponent<LightEditConfiguration> {
    private static final Logger LOG = Logger.getInstance(LightEditServiceImpl.class);
    private LightEditFrameWrapper myFrameWrapper;
    private final LightEditorManagerImpl myEditorManager;
    private final LightEditConfiguration myConfiguration = new LightEditConfiguration();
    private final LightEditProjectManager myLightEditProjectManager = new LightEditProjectManager();
    private boolean myEditorWindowClosing = false;
    private boolean mySaveSession;

    @NotNull
    public LightEditConfiguration getState() {
        LightEditConfiguration lightEditConfiguration = this.myConfiguration;
        if (lightEditConfiguration == null) {
            LightEditServiceImpl.$$$reportNull$$$0(0);
        }
        return lightEditConfiguration;
    }

    public void loadState(@NotNull LightEditConfiguration state) {
        if (state == null) {
            LightEditServiceImpl.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myConfiguration);
    }

    public LightEditServiceImpl() {
        this.myEditorManager = new LightEditorManagerImpl(this);
        this.myEditorManager.addListener(this);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)this);
        Disposer.register((Disposable)this, (Disposable)this.myEditorManager);
    }

    private void init(boolean restoreSession) {
        Project project = this.getOrCreateProject();
        LightEditServiceImpl.invokeOnEdt(() -> {
            IdeFrameImpl frame;
            boolean notify2 = false;
            if (this.myFrameWrapper == null) {
                this.mySaveSession = restoreSession;
                this.myFrameWrapper = LightEditFrameWrapper.allocate(project, this.myConfiguration.frameInfo, () -> this.closeEditorWindow());
                LOG.info("Frame created");
                if (restoreSession) {
                    this.restoreSession();
                }
                notify2 = true;
            }
            if (!(frame = this.myFrameWrapper.requireNotNullFrame()).isVisible()) {
                frame.setVisible(true);
                LOG.info("Window opened");
                notify2 = true;
            }
            this.myFrameWrapper.setFrameTitle(LightEditServiceImpl.getAppName());
            if (notify2) {
                ((LightEditServiceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LightEditServiceListener.TOPIC)).lightEditWindowOpened(project);
            }
        });
    }

    public void showEditorWindow() {
        this.doShowEditorWindow(true);
    }

    private void doShowEditorWindow(boolean restoreSession) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.init(restoreSession);
        }
    }

    private static String getAppName() {
        return ApplicationInfo.getInstance().getVersionName();
    }

    @Nullable
    public Project getProject() {
        return this.myLightEditProjectManager.getProject();
    }

    @NotNull
    Project getOrCreateProject() {
        Project project = this.myLightEditProjectManager.getOrCreateProject();
        if (project == null) {
            LightEditServiceImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public Project openFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(3);
        }
        Project project = this.myLightEditProjectManager.getOrCreateProject();
        LightEditUtil.LightEditCommandLineOptions commandLineOptions = LightEditUtil.getCommandLineOptions();
        LightEditServiceImpl.doWhenActionManagerInitialized(() -> this.doOpenFile(file2, commandLineOptions == null || !commandLineOptions.shouldWait()));
        Project project2 = project;
        if (project2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(4);
        }
        return project2;
    }

    private static void doWhenActionManagerInitialized(@NotNull Runnable callback2) {
        ActionManager created;
        if (callback2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(5);
        }
        if ((created = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) == null) {
            NonUrgentExecutor.getInstance().execute(() -> {
                ActionManager.getInstance();
                LightEditServiceImpl.invokeOnEdt(callback2);
            });
        } else {
            LightEditServiceImpl.invokeOnEdt(callback2);
        }
    }

    private static void invokeOnEdt(@NotNull Runnable callback2) {
        if (callback2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            callback2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(callback2);
        }
    }

    private void doOpenFile(@NotNull VirtualFile file2, boolean restoreSession) {
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(7);
        }
        this.doShowEditorWindow(restoreSession);
        LightEditorInfo openEditorInfo = this.myEditorManager.findOpen(file2);
        if (openEditorInfo == null) {
            LightEditorInfo newEditorInfo = this.myEditorManager.createEditor(file2);
            if (newEditorInfo != null) {
                this.addEditorTab(newEditorInfo);
                LOG.info("Opened new tab for " + file2.getPresentableUrl());
                if (Boolean.TRUE.equals(file2.getUserData(LightEditUtil.SUGGEST_SWITCH_TO_PROJECT))) {
                    file2.putUserData(LightEditUtil.SUGGEST_SWITCH_TO_PROJECT, null);
                    if (!LightEditConfiguration.PreferredMode.LightEdit.equals((Object)this.myConfiguration.preferredMode)) {
                        this.suggestSwitchToProject(this.getOrCreateProject(), file2);
                    }
                }
            } else {
                this.processNotOpenedFile(file2);
            }
        } else {
            this.selectEditorTab(openEditorInfo);
            LOG.info("Selected tab for " + file2.getPresentableUrl());
        }
        this.logStartupTime();
    }

    private void suggestSwitchToProject(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            LightEditServiceImpl.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(9);
        }
        LightEditConfirmationDialog dialog2 = new LightEditConfirmationDialog(project);
        dialog2.show();
        if (dialog2.isDontAsk()) {
            switch (dialog2.getExitCode()) {
                case 100: {
                    this.myConfiguration.preferredMode = LightEditConfiguration.PreferredMode.LightEdit;
                    break;
                }
                case 101: {
                    this.myConfiguration.preferredMode = LightEditConfiguration.PreferredMode.Project;
                }
            }
        }
        if (dialog2.getExitCode() == 101) {
            LightEditOpenInProjectIntention.performOn(this.getOrCreateProject(), file2);
        }
    }

    private void processNotOpenedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(10);
        }
        FileType fileType = file2.getFileType();
        Project project = Objects.requireNonNull(this.getProject());
        Messages.showWarningDialog((Project)project, (String)ApplicationBundle.message((String)"light.edit.unableToOpenFile.text", (Object[])new Object[]{file2.getPresentableName()}), (String)ApplicationBundle.message((String)"light.edit.unableToOpenFile.title", (Object[])new Object[0]));
        LOG.info("Failed to open " + file2.getPresentableUrl() + ", binary: " + fileType.isBinary());
    }

    private void logStartupTime() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myFrameWrapper != null) {
            ObjectUtils.consumeIfNotNull((Object)this.getEditPanel().getTabs().getSelectedInfo(), tabInfo -> UiNotifyConnector.doWhenFirstShown((JComponent)tabInfo.getComponent(), () -> ApplicationManager.getApplication().invokeLater(() -> LOG.info("Startup took: " + ManagementFactory.getRuntimeMXBean().getUptime() + " ms"))));
        }
    }

    private void selectEditorTab(LightEditorInfo openEditorInfo) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().selectTab(openEditorInfo);
        }
    }

    private void addEditorTab(@NotNull LightEditorInfo newEditorInfo) {
        if (newEditorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(11);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().addEditorTab(newEditorInfo);
        }
    }

    public void closeEditor(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(12);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().closeTab(editorInfo);
        }
    }

    public LightEditorInfo createNewDocument(@Nullable Path preferredSavePath) {
        this.showEditorWindow();
        String preferredName = preferredSavePath == null ? null : preferredSavePath.getFileName().toString();
        LightEditorInfo newEditorInfo = this.myEditorManager.createEmptyEditor(preferredName);
        newEditorInfo.setPreferredSavePath(preferredSavePath);
        this.addEditorTab(newEditorInfo);
        return newEditorInfo;
    }

    public boolean closeEditorWindow() {
        if (this.canClose()) {
            Project project = this.myFrameWrapper.getProject();
            this.myFrameWrapper.requireNotNullFrame().setVisible(false);
            this.saveSession();
            this.myEditorWindowClosing = true;
            try {
                this.myEditorManager.closeAllEditors();
            }
            finally {
                this.myEditorWindowClosing = false;
            }
            LOG.info("Window closed");
            ((LightEditServiceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LightEditServiceListener.TOPIC)).lightEditWindowClosed(project);
            if (ProjectManager.getInstance().getOpenProjects().length == 0 && WelcomeFrame.getInstance() == null) {
                this.closeAndDisposeFrame();
                LOG.info("No open projects or welcome frame, exiting");
                try {
                    Disposer.dispose((Disposable)this.myEditorManager);
                    ApplicationManager.getApplication().exit();
                }
                catch (Throwable t) {
                    System.exit(1);
                }
            } else {
                this.myFrameWrapper.releaseFrame();
                this.myFrameWrapper = null;
            }
        } else {
            LOG.info("Close cancelled");
        }
        return false;
    }

    private boolean canClose() {
        final FileDocumentManager documentManager = FileDocumentManager.getInstance();
        return !this.myEditorManager.containsUnsavedDocuments() || this.autosaveDocuments() || LightEditUtil.confirmClose(ApplicationBundle.message((String)"light.edit.exit.message", (Object[])new Object[0]), ApplicationBundle.message((String)"light.edit.exit.title", (Object[])new Object[0]), new LightEditSaveConfirmationHandler(){

            @Override
            public void onSave() {
                documentManager.saveAllDocuments();
            }

            @Override
            public void onDiscard() {
                LightEditServiceImpl.this.myEditorManager.getUnsavedEditors().forEach(editorInfo -> {
                    VirtualFile file2 = editorInfo.getFile();
                    Document document = documentManager.getDocument(file2);
                    if (document != null) {
                        documentManager.reloadFromDisk(document);
                    }
                });
            }
        });
    }

    private boolean autosaveDocuments() {
        if (this.isAutosaveMode()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            return true;
        }
        return false;
    }

    public LightEditPanel getEditPanel() {
        assert (!Disposer.isDisposed((Disposable)this.myFrameWrapper.getLightEditPanel()));
        return this.myFrameWrapper.getLightEditPanel();
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        LightEditFrameWrapper frameWrapper = this.myFrameWrapper;
        if (frameWrapper == null) {
            return null;
        }
        LightEditPanel panel2 = frameWrapper.getLightEditPanel();
        if (!Disposer.isDisposed((Disposable)panel2)) {
            return panel2.getTabs().getSelectedFile();
        }
        return null;
    }

    @Nullable
    public FileEditor getSelectedFileEditor() {
        LightEditFrameWrapper frameWrapper = this.myFrameWrapper;
        if (frameWrapper == null) {
            return null;
        }
        LightEditPanel panel2 = frameWrapper.getLightEditPanel();
        if (!Disposer.isDisposed((Disposable)panel2)) {
            return panel2.getTabs().getSelectedFileEditor();
        }
        return null;
    }

    public void updateFileStatus(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(13);
        }
        List editors2 = ContainerUtil.mapNotNull(files2, this.myEditorManager::findOpen);
        if (!editors2.isEmpty()) {
            this.myEditorManager.fireFileStatusChanged(editors2);
        }
    }

    public void dispose() {
        if (this.myFrameWrapper != null) {
            this.closeAndDisposeFrame();
        }
    }

    private void closeAndDisposeFrame() {
        this.myFrameWrapper.closeAndDispose(this);
        this.myFrameWrapper = null;
        LOG.info("Frame disposed");
    }

    public void afterSelect(@Nullable LightEditorInfo editorInfo) {
        if (this.myFrameWrapper != null) {
            this.myFrameWrapper.setFrameTitle(editorInfo == null ? LightEditServiceImpl.getAppName() : LightEditServiceImpl.getFileTitle(editorInfo));
        }
    }

    private static String getFileTitle(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(14);
        }
        VirtualFile file2 = editorInfo.getFile();
        StringBuilder titleBuilder = new StringBuilder();
        titleBuilder.append(file2.getPresentableName());
        String parentPath = LightEditServiceImpl.getPresentablePath(editorInfo);
        if (parentPath != null) {
            titleBuilder.append(" - ").append(LightEditServiceImpl.truncateUrl(parentPath));
        }
        return titleBuilder.toString();
    }

    @Nullable
    private static String getPresentablePath(@NotNull LightEditorInfo editorInfo) {
        VirtualFile file2;
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(15);
        }
        if ((file2 = editorInfo.getFile()) instanceof LightVirtualFile) {
            Path preferredPath = editorInfo.getPreferredSavePath();
            if (preferredPath != null && preferredPath.getParent() != null) {
                return preferredPath.getParent().toString();
            }
        } else {
            VirtualFile parent = file2.getParent();
            if (parent != null) {
                return parent.getPresentableUrl();
            }
        }
        return null;
    }

    private static String truncateUrl(@NotNull String url) {
        String truncated;
        String withoutLast;
        int prevSlashPos;
        int slashPos;
        if (url == null) {
            LightEditServiceImpl.$$$reportNull$$$0(16);
        }
        if ((slashPos = Math.max(url.lastIndexOf(92), url.lastIndexOf(47))) >= 0 && (prevSlashPos = Math.max((withoutLast = url.substring(0, slashPos)).lastIndexOf(92), withoutLast.lastIndexOf(47))) >= 0 && !url.equals(truncated = url.substring(prevSlashPos))) {
            return "..." + url.substring(prevSlashPos);
        }
        return url;
    }

    public void afterClose(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(17);
        }
        if (this.myEditorManager.getEditorCount() == 0 && !this.myEditorWindowClosing) {
            this.closeEditorWindow();
        }
    }

    @NotNull
    public LightEditorManager getEditorManager() {
        LightEditorManagerImpl lightEditorManagerImpl = this.myEditorManager;
        if (lightEditorManagerImpl == null) {
            LightEditServiceImpl.$$$reportNull$$$0(18);
        }
        return lightEditorManagerImpl;
    }

    private void saveEditorAs(@NotNull LightEditorInfo editorInfo, @NotNull VirtualFile targetFile) {
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(19);
        }
        if (targetFile == null) {
            LightEditServiceImpl.$$$reportNull$$$0(20);
        }
        LightEditorInfo newInfo = this.myEditorManager.saveAs(editorInfo, targetFile);
        this.getEditPanel().getTabs().replaceTab(editorInfo, newInfo);
    }

    public void saveToAnotherFile(@NotNull VirtualFile file2) {
        VirtualFile targetFile;
        LightEditorInfo editorInfo;
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(21);
        }
        if ((editorInfo = this.myEditorManager.getEditorInfo(file2)) != null && (targetFile = LightEditUtil.chooseTargetFile(this.myFrameWrapper.getLightEditPanel(), editorInfo)) != null) {
            this.saveEditorAs(editorInfo, targetFile);
        }
    }

    public boolean isAutosaveMode() {
        return this.myConfiguration.autosaveMode;
    }

    public void setAutosaveMode(boolean autosaveMode) {
        this.myConfiguration.autosaveMode = autosaveMode;
        this.myEditorManager.fireAutosaveModeChanged(autosaveMode);
    }

    @TestOnly
    public void disposeCurrentSession() {
        this.myEditorManager.releaseEditors();
        Project project = this.myLightEditProjectManager.getProject();
        if (project != null) {
            ProjectManagerEx.getInstanceEx().forceCloseProject(project);
        }
    }

    private void saveSession() {
        if (this.mySaveSession) {
            LightEditTabs tabs = this.myFrameWrapper.getLightEditPanel().getTabs();
            List<VirtualFile> openFiles = tabs.getOpenFiles();
            this.myConfiguration.sessionFiles.clear();
            this.myConfiguration.sessionFiles.addAll(ContainerUtil.map(openFiles, openFile2 -> VfsUtilCore.pathToUrl((String)openFile2.getPath())));
        }
    }

    private void restoreSession() {
        LightEditServiceImpl.doWhenActionManagerInitialized(() -> {
            this.myFrameWrapper.setFrameTitleUpdateEnabled(false);
            this.myConfiguration.sessionFiles.forEach(path2 -> {
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(path2);
                if (file2 != null) {
                    this.doOpenFile(file2, false);
                }
            });
            this.myFrameWrapper.setFrameTitleUpdateEnabled(true);
        });
    }

    void setFrameInfo(@NotNull FrameInfo frameInfo) {
        if (frameInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(22);
        }
        this.myConfiguration.frameInfo = frameInfo;
    }

    @Override
    public void appClosing() {
        ((EncodingManagerImpl)EncodingManager.getInstance()).clearDocumentQueue();
        if (this.myFrameWrapper != null) {
            this.closeAndDisposeFrame();
        }
        Disposer.dispose((Disposable)this.myEditorManager);
    }

    public void saveNewDocuments() {
        for (VirtualFile virtualFile2 : this.myEditorManager.getOpenFiles()) {
            LightEditorInfo editorInfo = Objects.requireNonNull(this.myEditorManager.getEditorInfo(virtualFile2));
            if (!editorInfo.isNew()) continue;
            VirtualFile preferredTarget = LightEditUtil.getPreferredSaveTarget(editorInfo);
            if (preferredTarget != null) {
                this.saveEditorAs(editorInfo, preferredTarget);
                continue;
            }
            this.saveToAnotherFile(virtualFile2);
        }
    }

    public boolean isTabNavigationAvailable(@NotNull AnAction navigationAction) {
        if (navigationAction == null) {
            LightEditServiceImpl.$$$reportNull$$$0(23);
        }
        return this.getEditPanel().getTabs().isTabNavigationAvailable(navigationAction);
    }

    public void navigateToTab(@NotNull AnAction navigationAction) {
        if (navigationAction == null) {
            LightEditServiceImpl.$$$reportNull$$$0(24);
        }
        this.getEditPanel().getTabs().navigateToTab(navigationAction);
    }

    public boolean isPreferProjectMode() {
        return this.myConfiguration.preferredMode != null && LightEditConfiguration.PreferredMode.Project.equals((Object)this.myConfiguration.preferredMode);
    }

    public boolean isLightEditEnabled() {
        return LightEditUtil.isLightEditEnabled();
    }

    @Nullable
    public Project openFile(@NotNull Path path2, boolean suggestSwitchToProject) {
        if (path2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(25);
        }
        return LightEditUtil.openFile(path2, suggestSwitchToProject);
    }

    public boolean isForceOpenInLightEditMode() {
        return LightEditUtil.isForceOpenInLightEditMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditServiceImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEditorInfo";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameInfo";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationAction";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doWhenActionManagerInitialized";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnEdt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suggestSwitchToProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processNotOpenedFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addEditorTab";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "closeEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateFileStatus";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileTitle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "truncateUrl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "afterClose";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveEditorAs";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "saveToAnotherFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setFrameInfo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTabNavigationAvailable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTab";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

