/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.EmptyCompletionNotifier;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditUtil {
    private static final String ENABLED_FILE_OPEN_KEY = "light.edit.file.open.enabled";
    private static final String OPEN_FILE_IN_PROJECT_HREF = "open_file_in_project";
    static final Key<String> CREATION_MESSAGE = Key.create((String)"light.edit.file.creation.message");
    private static final Logger LOG = Logger.getInstance(LightEditUtil.class);
    private static final ThreadLocal<LightEditCommandLineOptions> ourCommandLineOptions = new ThreadLocal();
    public static final Key<Boolean> SUGGEST_SWITCH_TO_PROJECT = Key.create((String)"light.edit.suggest.project.switch");

    private LightEditUtil() {
    }

    @Nullable
    public static Project openFile(@NotNull Path path2, boolean suggestSwitchToProject) {
        VirtualFile virtualFile2;
        if (path2 == null) {
            LightEditUtil.$$$reportNull$$$0(0);
        }
        if ((virtualFile2 = VfsUtil.findFile((Path)path2, (boolean)true)) != null) {
            if (suggestSwitchToProject) {
                virtualFile2.putUserData(SUGGEST_SWITCH_TO_PROJECT, (Object)true);
            }
            Project project = LightEditService.getInstance().openFile(virtualFile2);
            LightEditFeatureUsagesUtil.logFileOpen(project, LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
            return project;
        }
        return LightEditUtil.handleNonExisting(path2);
    }

    @Nullable
    private static Project handleNonExisting(@NotNull Path path2) {
        if (path2 == null) {
            LightEditUtil.$$$reportNull$$$0(1);
        }
        if (path2.getFileName() == null) {
            LOG.error("No file name is given");
        }
        if (LightEditUtil.isLightEditEnabled() && path2.getNameCount() > 0) {
            File newFile;
            String fileName = path2.getFileName().toString();
            Ref creationMessage = Ref.create();
            if (path2.getNameCount() > 1 && !FileUtil.ensureCanCreateFile((File)(newFile = path2.toFile()))) {
                creationMessage.set((Object)ApplicationBundle.message((String)"light.edit.file.creation.failed.message", (Object[])new Object[]{path2.toString(), fileName}));
            }
            Project project = ((LightEditServiceImpl)LightEditService.getInstance()).getOrCreateProject();
            ApplicationManager.getApplication().invokeLater(() -> {
                LightEditorInfo editorInfo = LightEditService.getInstance().createNewDocument(path2);
                if (creationMessage.get() != null) {
                    editorInfo.getFile().putUserData(CREATION_MESSAGE, (Object)((String)creationMessage.get()));
                    EditorNotifications.getInstance((Project)project).updateNotifications(editorInfo.getFile());
                }
            });
            return project;
        }
        return null;
    }

    @Nullable
    public static Path getPreferredSavePathForNonExistentFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditUtil.$$$reportNull$$$0(2);
        }
        if (file2 instanceof LightVirtualFile) {
            LightEditorInfo editorInfo = (LightEditorInfo)ContainerUtil.getFirstItem((Collection)LightEditService.getInstance().getEditorManager().getEditors(file2));
            return editorInfo != null ? editorInfo.getPreferredSavePath() : null;
        }
        return null;
    }

    public static boolean isForceOpenInLightEditMode() {
        LightEditCommandLineOptions options2 = LightEditUtil.getCommandLineOptions();
        return options2 != null && options2.myLightEditMode;
    }

    @Nullable
    public static Project getProjectIfCreated() {
        return LightEditService.getInstance().getProject();
    }

    static boolean confirmClose(@NotNull @NlsContexts.DialogMessage String message2, @NotNull @NlsContexts.DialogTitle String title2, @NotNull LightEditSaveConfirmationHandler handler2) {
        if (message2 == null) {
            LightEditUtil.$$$reportNull$$$0(3);
        }
        if (title2 == null) {
            LightEditUtil.$$$reportNull$$$0(4);
        }
        if (handler2 == null) {
            LightEditUtil.$$$reportNull$$$0(5);
        }
        String[] options2 = new String[]{LightEditUtil.getCloseSave(), LightEditUtil.getCloseDiscard(), LightEditUtil.getCloseCancel()};
        int result2 = Messages.showDialog((Project)LightEditUtil.requireProject(), (String)message2, (String)title2, (String[])options2, (int)0, (Icon)Messages.getWarningIcon());
        if (result2 >= 0) {
            if (LightEditUtil.getCloseCancel().equals(options2[result2])) {
                return false;
            }
            if (LightEditUtil.getCloseSave().equals(options2[result2])) {
                handler2.onSave();
            } else if (LightEditUtil.getCloseDiscard().equals(options2[result2])) {
                handler2.onDiscard();
            }
            return true;
        }
        return false;
    }

    @Nullable
    static VirtualFile chooseTargetFile(@NotNull Component parent, @NotNull LightEditorInfo editorInfo) {
        FileSaverDialog saver;
        VirtualFileWrapper fileWrapper;
        if (parent == null) {
            LightEditUtil.$$$reportNull$$$0(6);
        }
        if (editorInfo == null) {
            LightEditUtil.$$$reportNull$$$0(7);
        }
        return (fileWrapper = (saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(IdeBundle.message((String)"dialog.title.save.as", (Object[])new Object[0]), IdeBundle.message((String)"label.choose.target.file", (Object[])new Object[0]), new String[0]), parent)).save(VfsUtil.getUserHomeDir(), editorInfo.getFile().getPresentableName())) != null ? fileWrapper.getVirtualFile(true) : null;
    }

    @NlsContexts.Button
    private static String getCloseSave() {
        return ApplicationBundle.message((String)"light.edit.close.save", (Object[])new Object[0]);
    }

    @NlsContexts.Button
    private static String getCloseDiscard() {
        return ApplicationBundle.message((String)"light.edit.close.discard", (Object[])new Object[0]);
    }

    @NlsContexts.Button
    private static String getCloseCancel() {
        return ApplicationBundle.message((String)"light.edit.close.cancel", (Object[])new Object[0]);
    }

    public static void markUnknownFileTypeAsPlainTextIfNeeded(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditUtil.$$$reportNull$$$0(8);
        }
        if (project != null && !project.isDefault() && !LightEdit.owns((Project)project)) {
            return;
        }
        if (LightEditUtil.isLightEditEnabled()) {
            LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        }
    }

    public static boolean isLightEditEnabled() {
        return Registry.is((String)ENABLED_FILE_OPEN_KEY) && !PlatformUtils.isDataGrip();
    }

    @ApiStatus.Internal
    @NotNull
    public static EmptyCompletionNotifier createEmptyCompletionNotifier() {
        return new EmptyCompletionNotifier(){

            @Override
            public void showIncompleteHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String text2, boolean isDumbMode) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                HintManager.getInstance().showInformationHint(editor2, StringUtil.escapeXmlEntities((String)text2) + CodeInsightBundle.message((String)"completion.incomplete.light.edit.suffix", (Object[])new Object[]{LightEditUtil.OPEN_FILE_IN_PROJECT_HREF}), e -> {
                    VirtualFile file2;
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && LightEditUtil.OPEN_FILE_IN_PROJECT_HREF.equals(e.getDescription()) && (file2 = LightEditService.getInstance().getSelectedFile()) != null) {
                        LightEditOpenInProjectIntention.performOn(Objects.requireNonNull(editor2.getProject()), file2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/lightEdit/LightEditUtil$1";
                objectArray[2] = "showIncompleteHint";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static EditorWithProviderComposite findEditorComposite(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            LightEditUtil.$$$reportNull$$$0(9);
        }
        return ((LightEditServiceImpl)LightEditService.getInstance()).getEditPanel().getTabs().findEditorComposite(fileEditor);
    }

    @Nullable
    public static VirtualFile getPreferredSaveTarget(@NotNull LightEditorInfo editorInfo) {
        File targetFile;
        Path preferredPath;
        if (editorInfo == null) {
            LightEditUtil.$$$reportNull$$$0(10);
        }
        if (editorInfo.isNew() && (preferredPath = editorInfo.getPreferredSavePath()) != null && FileUtil.createIfDoesntExist((File)(targetFile = preferredPath.toFile()))) {
            return VfsUtil.findFile((Path)preferredPath, (boolean)true);
        }
        return null;
    }

    @NotNull
    public static Project requireLightEditProject(@Nullable Project project) {
        if (project == null || !LightEdit.owns((Project)project)) {
            LOG.error("LightEdit project is expected while " + (project != null ? project.getName() : "no project") + " is used instead");
            throw new IllegalStateException("Missing LightEdit project");
        }
        Project project2 = project;
        if (project2 == null) {
            LightEditUtil.$$$reportNull$$$0(11);
        }
        return project2;
    }

    public static void forbidServiceInLightEditMode(@Nullable Project project, @NotNull Class<?> serviceClass) {
        if (serviceClass == null) {
            LightEditUtil.$$$reportNull$$$0(12);
        }
        if (LightEdit.owns((Project)project)) {
            LOG.error("LightEdit mode lacks tool windows, so " + serviceClass.getName() + " shouldn't be instantiated there. Please change the caller to avoid loading the service in LightEdit mode!");
        }
    }

    @NotNull
    static Project requireProject() {
        return LightEditUtil.requireLightEditProject(LightEditService.getInstance().getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> T computeWithCommandLineOptions(boolean shouldWait, boolean lightEditMode, @NotNull Computable<T> computable) {
        if (computable == null) {
            LightEditUtil.$$$reportNull$$$0(13);
        }
        ourCommandLineOptions.set(new LightEditCommandLineOptions(shouldWait, lightEditMode));
        Object object = computable.compute();
        Object object2 = object;
        if (object2 == null) {
            LightEditUtil.$$$reportNull$$$0(14);
        }
        return (T)object2;
        finally {
            ourCommandLineOptions.set(null);
        }
    }

    public static void useCommandLineOptions(boolean shouldWait, boolean lightEditMode, @NotNull Disposable disposable2) {
        if (disposable2 == null) {
            LightEditUtil.$$$reportNull$$$0(15);
        }
        ourCommandLineOptions.set(new LightEditCommandLineOptions(shouldWait, lightEditMode));
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(){

            public void dispose() {
                ourCommandLineOptions.set(null);
            }
        });
    }

    @Nullable
    static LightEditCommandLineOptions getCommandLineOptions() {
        return ourCommandLineOptions.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requireLightEditProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithCommandLineOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleNonExisting";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSavePathForNonExistentFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "confirmClose";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "chooseTargetFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markUnknownFileTypeAsPlainTextIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findEditorComposite";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSaveTarget";
                break;
            }
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forbidServiceInLightEditMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeWithCommandLineOptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "useCommandLineOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class LightEditCommandLineOptions {
        private final boolean myShouldWait;
        private final boolean myLightEditMode;

        LightEditCommandLineOptions(boolean shouldWait, boolean lightEditMode) {
            this.myShouldWait = shouldWait;
            this.myLightEditMode = lightEditMode;
        }

        public boolean shouldWait() {
            return this.myShouldWait;
        }
    }
}

