/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ProjectTopics;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.navigationToolbar.NavBarActions;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.VirtualFileAppearanceListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.ListActions;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavBarListener
implements ProblemListener,
FocusListener,
FileStatusListener,
AnActionListener,
FileEditorManagerListener,
PsiTreeChangeListener,
ModuleRootListener,
NavBarModelListener,
PropertyChangeListener,
KeyListener,
WindowFocusListener,
LafManagerListener,
DynamicPluginListener,
VirtualFileAppearanceListener,
AdditionalLibraryRootsListener {
    private static final String LISTENER = "NavBarListener";
    private static final String BUS = "NavBarMessageBus";
    private final NavBarPanel myPanel;
    private boolean shouldFocusEditor;

    static void subscribeTo(@NotNull NavBarPanel panel2) {
        if (panel2 == null) {
            NavBarListener.$$$reportNull$$$0(0);
        }
        if (panel2.getClientProperty(LISTENER) != null) {
            NavBarListener.unsubscribeFrom(panel2);
        }
        NavBarListener listener2 = new NavBarListener(panel2);
        Project project = panel2.getProject();
        if (project.isDisposed()) {
            return;
        }
        panel2.putClientProperty(LISTENER, listener2);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(listener2);
        FileStatusManager.getInstance((Project)project).addFileStatusListener((FileStatusListener)listener2);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)listener2);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(AnActionListener.TOPIC, (Object)listener2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (Object)listener2);
        connection.subscribe(NavBarModelListener.NAV_BAR, (Object)listener2);
        connection.subscribe(ProblemListener.TOPIC, (Object)listener2);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)listener2);
        connection.subscribe(VirtualFileAppearanceListener.TOPIC, (Object)listener2);
        panel2.putClientProperty(BUS, connection);
        panel2.addKeyListener(listener2);
        if (panel2.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent(panel2);
            if (window != null) {
                window.addWindowFocusListener(listener2);
            }
        } else {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)connection).subscribe(LafManagerListener.TOPIC, (Object)listener2);
        }
    }

    static void unsubscribeFrom(@NotNull NavBarPanel panel2) {
        if (panel2 == null) {
            NavBarListener.$$$reportNull$$$0(1);
        }
        NavBarListener listener2 = (NavBarListener)panel2.getClientProperty(LISTENER);
        panel2.putClientProperty(LISTENER, null);
        if (listener2 == null) {
            return;
        }
        Project project = panel2.getProject();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(listener2);
        FileStatusManager.getInstance((Project)project).removeFileStatusListener((FileStatusListener)listener2);
        PsiManager.getInstance((Project)project).removePsiTreeChangeListener((PsiTreeChangeListener)listener2);
        MessageBusConnection connection = (MessageBusConnection)panel2.getClientProperty(BUS);
        panel2.putClientProperty(BUS, null);
        if (connection != null) {
            connection.disconnect();
        }
    }

    NavBarListener(NavBarPanel panel2) {
        this.myPanel = panel2;
        this.myPanel.addFocusListener(this);
        if (this.myPanel.allowNavItemsFocus()) {
            this.myPanel.addNavBarItemFocusListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.myPanel.allowNavItemsFocus() && UIUtil.isAncestor((Component)this.myPanel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (e.getOppositeComponent() == null && this.shouldFocusEditor) {
            this.shouldFocusEditor = false;
            ToolWindowManager.getInstance((Project)this.myPanel.getProject()).activateEditorComponent();
            return;
        }
        this.myPanel.updateItems();
        List<NavBarItem> items = this.myPanel.getItems();
        if (!this.myPanel.isInFloatingMode() && items.size() > 0) {
            this.myPanel.setContextComponent((Component)((Object)items.get(items.size() - 1)));
        } else {
            this.myPanel.setContextComponent(null);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.myPanel.allowNavItemsFocus() && UIUtil.isAncestor((Component)this.myPanel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (this.myPanel.getProject().isDisposed()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
            return;
        }
        DialogWrapper dialog2 = DialogWrapper.findInstance((Component)e.getOppositeComponent());
        boolean bl = this.shouldFocusEditor = dialog2 != null;
        if (dialog2 != null) {
            Disposable parent = dialog2.getDisposable();
            Disposable onParentDispose = () -> {
                if (dialog2.getExitCode() == 1) {
                    this.shouldFocusEditor = false;
                }
            };
            if (dialog2.isDisposed()) {
                Disposer.dispose((Disposable)onParentDispose);
            } else {
                Disposer.register((Disposable)parent, (Disposable)onParentDispose);
            }
        }
        SwingUtilities.invokeLater(() -> this.processFocusLost(e));
    }

    private void processFocusLost(FocusEvent e) {
        boolean childPopupInactive;
        Component opposite = e.getOppositeComponent();
        if (this.myPanel.isInFloatingMode() && opposite != null && DialogWrapper.findInstance((Component)opposite) != null) {
            this.myPanel.hideHint();
            return;
        }
        boolean nodePopupInactive = !this.myPanel.isNodePopupActive();
        boolean bl = childPopupInactive = !JBPopupFactory.getInstance().isChildPopupFocused((Component)this.myPanel);
        if (nodePopupInactive && childPopupInactive && opposite != null && opposite != this.myPanel && !this.myPanel.isAncestorOf(opposite) && !e.isTemporary()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
        }
        this.myPanel.updateItems();
    }

    private void rebuildUI() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getUpdateQueue().queueRebuildUi();
        }
    }

    private void updateModel() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getModel().setChanged(true);
            this.myPanel.getUpdateQueue().queueModelUpdateFromFocus();
        }
    }

    public void fileStatusesChanged() {
        this.rebuildUI();
    }

    public void fileStatusChanged(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            NavBarListener.$$$reportNull$$$0(2);
        }
        this.rebuildUI();
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(3);
        }
        this.updateModel();
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(4);
        }
        this.updateModel();
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(5);
        }
        this.updateModel();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(6);
        }
        this.updateModel();
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(7);
        }
        this.updateModel();
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(8);
        }
        this.updateModel();
    }

    public void libraryRootsChanged(@Nullable @Nls String presentableLibraryName, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull String libraryNameForDebug) {
        if (oldRoots == null) {
            NavBarListener.$$$reportNull$$$0(9);
        }
        if (newRoots == null) {
            NavBarListener.$$$reportNull$$$0(10);
        }
        if (libraryNameForDebug == null) {
            NavBarListener.$$$reportNull$$$0(11);
        }
        this.updateModel();
    }

    public void problemsAppeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NavBarListener.$$$reportNull$$$0(12);
        }
        this.updateModel();
    }

    public void problemsDisappeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NavBarListener.$$$reportNull$$$0(13);
        }
        this.updateModel();
    }

    @Override
    public void modelChanged() {
        this.rebuildUI();
    }

    @Override
    public void selectionChanged() {
        this.myPanel.updateItems();
        this.myPanel.scrollSelectionToVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name2;
        if (this.myPanel.isShowing() && ("focusOwner".equals(name2 = evt.getPropertyName()) || "permanentFocusOwner".equals(name2))) {
            this.myPanel.getUpdateQueue().restartRebuild();
        }
    }

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        if (action2 == null) {
            NavBarListener.$$$reportNull$$$0(14);
        }
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            NavBarListener.$$$reportNull$$$0(16);
        }
        if (NavBarListener.shouldSkipAction(action2)) {
            return;
        }
        if (this.myPanel.isInFloatingMode()) {
            this.myPanel.hideHint();
        } else {
            this.myPanel.cancelPopup();
        }
    }

    private static boolean shouldSkipAction(AnAction action2) {
        return action2 instanceof PopupAction || action2 instanceof CopyAction || action2 instanceof CutAction || action2 instanceof ListActions || action2 instanceof NavBarActions || action2 instanceof ScrollingUtil.ScrollingAction;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!(e.isAltDown() || e.isMetaDown() || e.isControlDown() || this.myPanel.isNodePopupActive())) {
            if (!Character.isLetter(e.getKeyChar())) {
                return;
            }
            this.myPanel.moveDown();
            SwingUtilities.invokeLater(() -> {
                try {
                    Robot robot = new Robot();
                    boolean shiftOn = e.isShiftDown();
                    int code = e.getKeyCode();
                    if (shiftOn) {
                        robot.keyPress(16);
                    }
                    robot.keyPress(code);
                    robot.keyRelease(code);
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            });
        }
    }

    public void fileOpened(@NotNull FileEditorManager manager2, @NotNull VirtualFile file2) {
        if (manager2 == null) {
            NavBarListener.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            NavBarListener.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myPanel.isFocused()) {
                manager2.openFile(file2, true);
            }
        });
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        if (source == null) {
            NavBarListener.$$$reportNull$$$0(19);
        }
        this.myPanel.getNavBarUI().clearItems();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public void virtualFileAppearanceChanged(@NotNull VirtualFile virtualFile2) {
        PsiFile psiFile;
        if (virtualFile2 == null) {
            NavBarListener.$$$reportNull$$$0(20);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myPanel.getProject()).findFile(virtualFile2)) != null) {
            this.myPanel.queueFileUpdate(psiFile);
            this.rebuildUI();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(21);
        }
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(22);
        }
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(23);
        }
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(24);
        }
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(25);
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(26);
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(27);
        }
    }

    @Override
    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        if (pluginDescriptor == null) {
            NavBarListener.$$$reportNull$$$0(28);
        }
        this.myPanel.getNavBarUI().clearItems();
    }

    @Override
    public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        if (pluginDescriptor == null) {
            NavBarListener.$$$reportNull$$$0(29);
        }
        this.myPanel.getNavBarUI().clearItems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryNameForDebug";
                break;
            }
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unsubscribeFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileStatusChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "libraryRootsChanged";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "problemsAppeared";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "problemsDisappeared";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "afterActionPerformed";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAndFeelChanged";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "virtualFileAppearanceChanged";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildAddition";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildRemoval";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildReplacement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildMovement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildrenChange";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePluginUnload";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginUnloaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

