/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class SelectInNavBarTarget
extends SelectInTargetPsiWrapper
implements DumbAware {
    public static final String NAV_BAR_ID = "NavBar";

    SelectInNavBarTarget(@NotNull Project project) {
        if (project == null) {
            SelectInNavBarTarget.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NonNls
    public String getToolWindowId() {
        return NAV_BAR_ID;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return UISettings.getInstance().getShowNavigationBar();
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile2, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar(false);
    }

    @Override
    protected void select(PsiElement element2, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar(false);
    }

    public static void selectInNavBar(boolean showPopup2) {
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(context2 -> {
            IdeRootPaneNorthExtension navBarExt;
            IdeFrame frame = (IdeFrame)IdeFrame.KEY.getData((DataContext)context2);
            if (frame instanceof IdeFrameEx && (navBarExt = ((IdeFrameEx)frame).getNorthExtension(NAV_BAR_ID)) != null) {
                JComponent c = navBarExt.getComponent();
                NavBarPanel panel2 = (NavBarPanel)c.getClientProperty("NavBarPanel");
                panel2.rebuildAndSelectItem(list2 -> {
                    int lastDirectory;
                    if (UISettings.getInstance().getShowMembersInNavigationBar() && (lastDirectory = ContainerUtil.lastIndexOf((List)list2, item -> NavBarPanel.isExpandable(item.getObject()))) >= 0 && lastDirectory < list2.size() - 1) {
                        return lastDirectory;
                    }
                    return list2.size() - 1;
                }, showPopup2);
            }
        });
    }

    public float getWeight() {
        return 8.0f;
    }

    public String getMinorViewId() {
        return null;
    }

    @Override
    public String toString() {
        return IdeBundle.message((String)"navigation.bar", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/navigationToolbar/SelectInNavBarTarget", "<init>"));
    }
}

