/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.experimental;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.navigationToolbar.experimental.CenterToolbarGroup;
import com.intellij.ide.navigationToolbar.experimental.NewToolbarBorderLayout;
import com.intellij.ide.navigationToolbar.experimental.NewToolbarPaneListener;
import com.intellij.ide.navigationToolbar.experimental.NewToolbarRootPaneExtension;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.experimental.toolbar.RunWidgetAvailabilityManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000b\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u0000H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/NewToolbarRootPaneExtension;", "Lcom/intellij/openapi/wm/IdeRootPaneNorthExtension;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myPanel", "Ljavax/swing/JPanel;", "runWidgetAvailabilityManager", "Lcom/intellij/ide/ui/experimental/toolbar/RunWidgetAvailabilityManager;", "runWidgetListener", "com/intellij/ide/navigationToolbar/experimental/NewToolbarRootPaneExtension$runWidgetListener$1", "Lcom/intellij/ide/navigationToolbar/experimental/NewToolbarRootPaneExtension$runWidgetListener$1;", "copy", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getKey", "", "reinitAndDoLayout", "reinitAndPaintAll", "repaint", "revalidate", "uiSettingsChanged", "settings", "Lcom/intellij/ide/ui/UISettings;", "Companion", "intellij.platform.lang.impl"})
public final class NewToolbarRootPaneExtension
extends IdeRootPaneNorthExtension
implements Disposable {
    private final RunWidgetAvailabilityManager runWidgetAvailabilityManager;
    private final runWidgetListener.1 runWidgetListener;
    private final JPanel myPanel;
    private final Project myProject;
    private static final String NEW_TOOLBAR_KEY = "NEW_TOOLBAR_KEY";
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getKey() {
        return NEW_TOOLBAR_KEY;
    }

    /*
     * WARNING - void declaration
     */
    private final void reinitAndDoLayout() {
        ActivityTracker.getInstance().inc();
        this.myPanel.removeAll();
        if (this.myPanel.isVisible()) {
            CustomActionsSchema actionsSchema = CustomActionsSchema.getInstance();
            Object object = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)(this.runWidgetAvailabilityManager.isAvailable() ? "RightToolbarSideGroup" : "RightToolbarSideGroupNoRunWidget"), (Object)"East"), TuplesKt.to((Object)"CenterToolbarSideGroup", (Object)"Center"), TuplesKt.to((Object)"LeftToolbarSideGroup", (Object)"West")});
            boolean bl = false;
            Iterator iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                ActionToolbar toolbar;
                ActionGroup actionGroup2;
                void actionId;
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator2.next();
                boolean bl2 = false;
                object = (String)entry3.getKey();
                entry3 = entry2;
                bl2 = false;
                String layoutConstrains = (String)entry3.getValue();
                AnAction action2 = actionsSchema.getCorrectedAction((String)actionId);
                AnAction anAction2 = action2;
                if (!(anAction2 instanceof ActionGroup)) {
                    anAction2 = null;
                }
                if ((ActionGroup)anAction2 == null) {
                    throw (Throwable)new IllegalArgumentException("Action group '" + (String)actionId + "' not found; actual action: " + action2);
                }
                Intrinsics.checkNotNullExpressionValue((Object)ActionManager.getInstance().createActionToolbar("MainToolbar", actionGroup2, true), (String)"ActionManager.getInstanc\u2026          true,\n        )");
                toolbar.setTargetComponent((JComponent)this.myPanel);
                toolbar.setLayoutPolicy(0);
                ApplicationKt.getApplication().invokeLater(new Runnable(toolbar){
                    final /* synthetic */ ActionToolbar $toolbar;

                    public final void run() {
                        this.$toolbar.getComponent().revalidate();
                        this.$toolbar.getComponent().repaint();
                    }
                    {
                        this.$toolbar = actionToolbar;
                    }
                });
                ActionToolbar actionToolbar = toolbar;
                if (actionToolbar == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
                }
                this.myPanel.add((Component)((JComponent)actionToolbar), layoutConstrains);
            }
        }
    }

    private final void reinitAndPaintAll() {
        this.reinitAndDoLayout();
        this.repaint();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    public void uiSettingsChanged(@NotNull UISettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        logger.info("Show old main toolbar: " + settings.getShowMainToolbar() + "; show old navigation bar: " + settings.getShowNavigationBar());
        logger.info("Show new main toolbar: " + ToolbarSettings.Companion.getInstance().isVisible());
        ToolbarSettings toolbarSettings = ToolbarSettings.Companion.getInstance();
        this.myPanel.setEnabled(toolbarSettings.isEnabled());
        this.myPanel.setVisible(this.myPanel.isEnabled() && toolbarSettings.isVisible() && !settings.getPresentationMode());
        this.repaint();
    }

    @NotNull
    public NewToolbarRootPaneExtension copy() {
        return new NewToolbarRootPaneExtension(this.myProject);
    }

    public void dispose() {
        this.runWidgetAvailabilityManager.removeListener(this.runWidgetListener);
    }

    public void revalidate() {
        if (this.myProject.isDisposed()) {
            logger.warn("Project '" + this.myProject + "' disposal has already been initiated.");
            return;
        }
        if (ToolbarSettings.Companion.getInstance().isEnabled() && ToolbarSettings.Companion.getInstance().isVisible()) {
            ((StatusBarWidgetsManager)((Object)this.myProject.getService(StatusBarWidgetsManager.class))).updateAllWidgets();
            this.reinitAndDoLayout();
            AnAction anAction2 = CustomActionsSchema.getInstance().getCorrectedAction("CenterToolbarSideGroup");
            if (!(anAction2 instanceof CenterToolbarGroup)) {
                anAction2 = null;
            }
            CenterToolbarGroup centerToolbarGroup = (CenterToolbarGroup)anAction2;
            if (centerToolbarGroup == null) {
                return;
            }
            CenterToolbarGroup group2 = centerToolbarGroup;
            ActionToolbar actionToolbar = ActionManagerEx.getInstanceEx().createActionToolbar("MainToolbar", (ActionGroup)group2, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManagerEx.getInsta\u2026AIN_TOOLBAR, group, true)");
            ActionToolbar toolBar = actionToolbar;
            toolBar.setTargetComponent((JComponent)null);
            toolBar.setLayoutPolicy(1);
            ActionToolbar actionToolbar2 = toolBar;
            if (actionToolbar2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
            }
            this.myPanel.add((Component)((JComponent)actionToolbar2), "Center");
        }
    }

    private final void repaint() {
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public NewToolbarRootPaneExtension(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.runWidgetAvailabilityManager = RunWidgetAvailabilityManager.Companion.getInstance(this.myProject);
        this.runWidgetListener = new RunWidgetAvailabilityManager.RunWidgetAvailabilityListener(this){
            final /* synthetic */ NewToolbarRootPaneExtension this$0;

            public void availabilityChanged(boolean value2) {
                NewToolbarRootPaneExtension.access$reinitAndPaintAll(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.myPanel = new JPanel(new NewToolbarBorderLayout()){

            @NotNull
            protected Graphics getComponentGraphics(@Nullable Graphics graphics) {
                Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"JBSwingUtilities.runGlob\u2026ponentGraphics(graphics))");
                return graphics2D;
            }
            {
                this.setOpaque(true);
                this.setBorder(BorderFactory.createEmptyBorder(0, JBUI.scale((int)4), 0, JBUI.scale((int)4)));
            }
        };
        Disposer.register((Disposable)((Disposable)this.myProject), (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(NewToolbarPaneListener.Companion.getTOPIC(), (Object)new NewToolbarPaneListener(){

            @Override
            public void stateChanged() {
                myPanel.doLayout();
                myPanel.repaint();
            }
        });
        this.runWidgetAvailabilityManager.addListener(this.runWidgetListener);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NewToolbarRootPaneExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        NewToolbarRootPaneExtension.logger = logger;
    }

    public static final /* synthetic */ void access$reinitAndPaintAll(NewToolbarRootPaneExtension $this) {
        $this.reinitAndPaintAll();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/NewToolbarRootPaneExtension$Companion;", "", "()V", "NEW_TOOLBAR_KEY", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

