/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.nls;

import com.ibm.icu.number.FormattedNumber;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import com.intellij.DynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NlsMessages {
    private static final MeasureUnit[] TIME_UNITS = new MeasureUnit[]{MeasureUnit.MILLISECOND, MeasureUnit.SECOND, MeasureUnit.MINUTE, MeasureUnit.HOUR, MeasureUnit.DAY};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};
    private static final int[] PADDED_FORMATS = new int[]{3, 2, 2, 2, 1};

    @NotNull
    @Nls
    public static String formatAndList(Collection<?> list2) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.WIDE).format(list2);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String formatNarrowAndList(Collection<?> list2) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.NARROW).format(list2);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String formatOrList(Collection<?> list2) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.OR, (ListFormatter.Width)ListFormatter.Width.WIDE).format(list2);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningAnd() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatAndList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(3);
        }
        return collector;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningNarrowAnd() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatNarrowAndList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(4);
        }
        return collector;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningOr() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatOrList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(5);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationApproximate(long duration) {
        return NlsMessages.formatDuration(duration, 2, false);
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationApproximateNarrow(long duration) {
        return NlsMessages.formatDuration(duration, 2, true);
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDuration(long duration) {
        return NlsMessages.formatDuration(duration, Integer.MAX_VALUE, false);
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    private static String formatDuration(long duration, int maxFragments, boolean narrow) {
        long multiplier;
        int i2;
        LongArrayList unitValues = new LongArrayList();
        IntArrayList unitIndices = new IntArrayList();
        long count = duration;
        for (i2 = 1; i2 < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i2]); ++i2) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder == 0L && unitValues.isEmpty()) continue;
            unitValues.add(0, remainder);
            unitIndices.add(0, i2 - 1);
        }
        unitValues.add(0, count);
        unitIndices.add(0, i2 - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.getInt(maxFragments - 1);
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.getLong(maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.getLong(maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return NlsMessages.formatDuration(duration + increment, maxFragments, narrow);
            }
        }
        int finalCount = Math.min(unitValues.size(), maxFragments);
        if (narrow) {
            ArrayList<String> fragments = new ArrayList<String>();
            LocalizedNumberFormatter formatter = (LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)DynamicBundle.getLocale()).unitWidth(NumberFormatter.UnitWidth.SHORT);
            for (i2 = 0; i2 < finalCount; ++i2) {
                fragments.add(((LocalizedNumberFormatter)formatter.unit(TIME_UNITS[unitIndices.getInt(i2)])).format(unitValues.getLong(i2)).toString().replace(' ', '\u2009'));
            }
            String string = StringUtil.join(fragments, (String)" ");
            if (string == null) {
                NlsMessages.$$$reportNull$$$0(6);
            }
            return string;
        }
        MeasureFormat format2 = MeasureFormat.getInstance((Locale)DynamicBundle.getLocale(), (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.SHORT);
        Measure[] measures = new Measure[finalCount];
        for (i2 = 0; i2 < finalCount; ++i2) {
            measures[i2] = new Measure((Number)unitValues.getLong(i2), TIME_UNITS[unitIndices.getInt(i2)]);
        }
        String string = format2.formatMeasures(measures);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationPadded(long millis) {
        long multiplier;
        int i2;
        long millisIn = 1L;
        for (i2 = 1; i2 < TIME_MULTIPLIERS.length && millis >= (millisIn *= (multiplier = TIME_MULTIPLIERS[i2])); ++i2) {
        }
        long d = millis;
        LocalizedNumberFormatter formatter = (LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)DynamicBundle.getLocale()).unitWidth(NumberFormatter.UnitWidth.NARROW);
        ArrayList<FormattedNumber> result2 = new ArrayList<FormattedNumber>();
        --i2;
        while (i2 >= 0) {
            long multiplier2 = i2 == TIME_MULTIPLIERS.length - 1 ? 1L : TIME_MULTIPLIERS[i2 + 1];
            long value2 = d / (millisIn /= multiplier2);
            d %= millisIn;
            IntegerWidth style = IntegerWidth.zeroFillTo((int)(result2.isEmpty() ? 1 : PADDED_FORMATS[i2]));
            LocalizedNumberFormatter unitFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)formatter.unit(TIME_UNITS[i2])).integerWidth(style);
            result2.add(unitFormatter.format(value2));
            --i2;
        }
        String string = ListFormatter.getInstance((Locale)Locale.getDefault(), (ListFormatter.Type)ListFormatter.Type.UNITS, (ListFormatter.Width)ListFormatter.Width.NARROW).format(result2);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDateLong(Date date) {
        String string = DateFormat.getDateInstance(1, DynamicBundle.getLocale()).format(date);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/nls/NlsMessages";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAndList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNarrowAndList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatOrList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningAnd";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningNarrowAnd";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningOr";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPadded";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateLong";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

