/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.ide.plugins.BundledPluginsListerKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/BundledPluginsLister;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "getCommandName", "", "getRequiredModality", "", "main", "", "args", "", "intellij.platform.ide.impl"})
public final class BundledPluginsLister
implements ApplicationStarter {
    @NotNull
    public String getCommandName() {
        return "listBundledPlugins";
    }

    public int getRequiredModality() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        try {
            Writer writer;
            if (args.size() == 2) {
                Path outFile;
                Path path2 = outFile = Path.of(args.get(1), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outFile");
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                BufferedWriter bufferedWriter = Files.newBufferedWriter(outFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"Files.newBufferedWriter(outFile)");
                writer = bufferedWriter;
            } else {
                writer = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
            }
            Writer out = writer;
            Closeable closeable = (Closeable)new JsonFactory().createGenerator(out).useDefaultPrettyPrinter();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                JsonGenerator writer2 = (JsonGenerator)closeable;
                boolean bl3 = false;
                List<IdeaPluginDescriptorImpl> plugins2 = PluginManagerCore.getPluginSet().enabledPlugins;
                ArrayList<String> modules2 = new ArrayList<String>();
                ArrayList<String> pluginIds2 = new ArrayList<String>(plugins2.size());
                for (IdeaPluginDescriptorImpl plugin2 : plugins2) {
                    pluginIds2.add(plugin2.getPluginId().getIdString());
                    for (PluginId pluginId : plugin2.modules) {
                        modules2.add(pluginId.getIdString());
                    }
                }
                CollectionsKt.sort((List)pluginIds2);
                CollectionsKt.sort((List)modules2);
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                ArrayList<String> extensions2 = new ArrayList<String>();
                FileTypeManager fileTypeManager2 = fileTypeManager;
                Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager2, (String)"fileTypeManager");
                for (FileType type : fileTypeManager2.getRegisteredFileTypes()) {
                    if (type instanceof PlainTextLikeFileType) continue;
                    FileType fileType = type;
                    Intrinsics.checkNotNull((Object)fileType);
                    Iterator iterator2 = fileTypeManager.getAssociations(fileType).iterator();
                    while (iterator2.hasNext()) {
                        FileNameMatcher matcher;
                        FileNameMatcher fileNameMatcher = matcher = (FileNameMatcher)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)fileNameMatcher, (String)"matcher");
                        extensions2.add(fileNameMatcher.getPresentableString());
                    }
                }
                JsonGenerator jsonGenerator = writer2;
                Intrinsics.checkNotNullExpressionValue((Object)jsonGenerator, (String)"writer");
                JsonGenerator $this$obj$iv = jsonGenerator;
                String fieldName$iv = null;
                boolean $i$f$obj = false;
                $this$obj$iv.writeStartObject();
                boolean bl4 = false;
                BundledPluginsListerKt.access$writeList(writer2, "modules", modules2);
                BundledPluginsListerKt.access$writeList(writer2, "plugins", pluginIds2);
                BundledPluginsListerKt.access$writeList(writer2, "extensions", extensions2);
                $this$obj$iv.writeEndObject();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        int n = 0;
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

