/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginEnabler;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel {
    protected static final boolean HIDE_IMPLEMENTATION_DETAILS = !Boolean.getBoolean("startup.performance.framework");
    protected final List<IdeaPluginDescriptor> view = new ArrayList<IdeaPluginDescriptor>();
    private final Map<PluginId, PluginEnabledState> myEnabled = new HashMap<PluginId, PluginEnabledState>();
    @Nullable
    private final Project myProject;

    public InstalledPluginsTableModel(@Nullable Project project) {
        this.myProject = project;
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor plugin2 : PluginManagerCore.getPlugins()) {
            PluginId pluginId = plugin2.getPluginId();
            if (appInfo.isEssentialPlugin(pluginId)) {
                this.setEnabled(pluginId, PluginEnabledState.ENABLED);
                continue;
            }
            this.view.add(plugin2);
        }
        this.view.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        ProjectPluginTracker pluginTracker = this.myProject != null ? DynamicPluginEnabler.findPluginTracker(this.myProject) : null;
        for (IdeaPluginDescriptor descriptor2 : this.view) {
            this.setEnabled(descriptor2, pluginTracker);
        }
    }

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    public final boolean isLoaded(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(0);
        }
        return InstalledPluginsTableModel.isLoaded(pluginId, this.getEnabledMap());
    }

    private void setEnabled(@NotNull IdeaPluginDescriptor ideaPluginDescriptor, @Nullable ProjectPluginTracker pluginTracker) {
        if (ideaPluginDescriptor == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(1);
        }
        PluginId pluginId = ideaPluginDescriptor.getPluginId();
        PluginEnabledState enabled = pluginTracker != null && pluginTracker.isEnabled(pluginId) ? PluginEnabledState.ENABLED_FOR_PROJECT : (pluginTracker != null && pluginTracker.isDisabled(pluginId) ? PluginEnabledState.DISABLED_FOR_PROJECT : (PluginManagerCore.isDisabled(pluginId) ? PluginEnabledState.DISABLED : (ideaPluginDescriptor.isEnabled() ? PluginEnabledState.ENABLED : null)));
        this.setEnabled(pluginId, enabled);
    }

    protected final void setEnabled(@NotNull PluginId pluginId, @Nullable PluginEnabledState enabled) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(2);
        }
        this.myEnabled.put(pluginId, enabled);
    }

    protected void updatePluginDependencies(@Nullable Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
    }

    protected final void enableRows(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull PluginEnableDisableAction action2) {
        if (descriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(4);
        }
        HashMap<PluginId, PluginEnabledState> tempEnabled = new HashMap<PluginId, PluginEnabledState>(this.myEnabled);
        InstalledPluginsTableModel.setNewEnabled(descriptors, tempEnabled, action2, (descriptor2, pair) -> {});
        boolean enabled = action2.isEnable();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        Set<PluginId> pluginIdsToUpdate = enabled ? InstalledPluginsTableModel.getDependenciesToEnable(descriptors, tempEnabled, pluginIdMap) : InstalledPluginsTableModel.getDependentsToDisable(descriptors, tempEnabled, pluginIdMap);
        ArrayList<? extends IdeaPluginDescriptor> descriptorsToUpdate = new ArrayList<IdeaPluginDescriptor>();
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (PluginId pluginId : pluginIdsToUpdate) {
            IdeaPluginDescriptorImpl descriptor3 = pluginIdMap.get(pluginId);
            descriptorsToUpdate.add(descriptor3);
            pluginNames.add(InstalledPluginsTableModel.getPluginNameOrId(pluginId, descriptor3));
        }
        if (HIDE_IMPLEMENTATION_DETAILS && !this.createUpdateDependenciesDialog(pluginNames, action2)) {
            return;
        }
        descriptorsToUpdate.addAll(descriptors);
        InstalledPluginsTableModel.setNewEnabled(descriptorsToUpdate, this.myEnabled, action2, this::handleBeforeChangeEnableState);
        this.updatePluginDependencies(pluginIdMap);
    }

    private static void setNewEnabled(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull Map<PluginId, PluginEnabledState> enabledMap, @NotNull PluginEnableDisableAction action2, @NotNull @NotNull BiConsumer<? super IdeaPluginDescriptor, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState>> beforeHandler) {
        if (descriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(5);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(7);
        }
        if (beforeHandler == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(8);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            PluginEnabledState oldState = enabledMap.get(pluginId);
            PluginEnabledState newState2 = oldState == null ? PluginEnabledState.DISABLED : action2.apply(oldState);
            if (newState2 == null) continue;
            beforeHandler.accept((IdeaPluginDescriptor)ideaPluginDescriptor, (Pair<PluginEnableDisableAction, PluginEnabledState>)Pair.create((Object)((Object)action2), (Object)((Object)newState2)));
            enabledMap.put(pluginId, newState2);
        }
    }

    @NotNull
    protected final Map<PluginId, PluginEnabledState> getEnabledMap() {
        Map<PluginId, PluginEnabledState> map2 = this.myEnabled;
        if (map2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    private static Set<PluginId> getDependenciesToEnable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull Map<PluginId, PluginEnabledState> enabledMap, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        if (descriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(10);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(11);
        }
        if (pluginIdMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(12);
        }
        LinkedHashSet result2 = new LinkedHashSet();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl)) continue;
            PluginManagerCore.processAllNonOptionalDependencies((IdeaPluginDescriptorImpl)ideaPluginDescriptor, pluginIdMap, (dependencyId, __) -> {
                PluginEnabledState state = (PluginEnabledState)((Object)((Object)((Object)enabledMap.get(dependencyId))));
                if (state == null) {
                    return FileVisitResult.TERMINATE;
                }
                if (!dependencyId.equals((Object)descriptor2.getPluginId()) && state.isDisabled()) {
                    result2.add(dependencyId);
                }
                return FileVisitResult.CONTINUE;
            });
        }
        Set<PluginId> set2 = Collections.unmodifiableSet(result2);
        if (set2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(13);
        }
        return set2;
    }

    @NotNull
    private static Set<PluginId> getDependentsToDisable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull Map<PluginId, PluginEnabledState> enabledMap, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        if (descriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(14);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(15);
        }
        if (pluginIdMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(16);
        }
        LinkedHashSet result2 = new LinkedHashSet();
        Set pluginIds2 = ContainerUtil.map2Set(descriptors, PluginDescriptor::getPluginId);
        for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry2 : pluginIdMap.entrySet()) {
            PluginId pluginId = entry2.getKey();
            IdeaPluginDescriptorImpl descriptor2 = entry2.getValue();
            if (descriptor2 == null || pluginIds2.contains(pluginId) || InstalledPluginsTableModel.isDisabled(pluginId, enabledMap)) continue;
            PluginManagerCore.processAllNonOptionalDependencies(descriptor2, pluginIdMap, (dependencyId, __) -> {
                if (!InstalledPluginsTableModel.isLoaded(dependencyId, enabledMap)) {
                    return FileVisitResult.TERMINATE;
                }
                if (!dependencyId.equals((Object)pluginId) && !InstalledPluginsTableModel.isHidden(descriptor2) && pluginIds2.contains(dependencyId)) {
                    result2.add(pluginId);
                }
                return FileVisitResult.CONTINUE;
            });
        }
        Set<PluginId> set2 = Collections.unmodifiableSet(result2);
        if (set2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(17);
        }
        return set2;
    }

    private boolean createUpdateDependenciesDialog(@NotNull List<String> dependencies2, @NotNull PluginEnableDisableAction action2) {
        String key;
        int size;
        if (dependencies2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(18);
        }
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(19);
        }
        if ((size = dependencies2.size()) == 0) {
            return true;
        }
        boolean hasOnlyOneDependency = size == 1;
        switch (action2) {
            case ENABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.enable.required.plugin" : "dialog.message.enable.required.plugins";
                break;
            }
            case ENABLE_FOR_PROJECT: {
                key = hasOnlyOneDependency ? "dialog.message.enable.required.plugin.for.current.project" : "dialog.message.enable.required.plugins.for.current.project";
                break;
            }
            case ENABLE_FOR_PROJECT_DISABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.enable.dependent.plugin.for.current.project.only" : "dialog.message.enable.dependent.plugins.for.current.project.only";
                break;
            }
            case DISABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.disable.dependent.plugin" : "dialog.message.disable.dependent.plugins";
                break;
            }
            case DISABLE_FOR_PROJECT: {
                key = hasOnlyOneDependency ? "dialog.message.disable.dependent.plugin.for.current.project" : "dialog.message.disable.dependent.plugins.for.current.project";
                break;
            }
            case DISABLE_FOR_PROJECT_ENABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.disable.required.plugin.for.current.project.only" : "dialog.message.disable.required.plugins.for.current.project.only";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + action2);
            }
        }
        String dependenciesText = hasOnlyOneDependency ? dependencies2.get(0) : StringUtil.join(dependencies2, StringUtil.repeat((String)"&nbsp;", (int)5)::concat, (String)"<br>");
        boolean enabled = action2.isEnable();
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)IdeBundle.message((String)(enabled ? "dialog.title.enable.required.plugins" : "dialog.title.disable.dependent.plugins"), (Object[])new Object[0]), (String)IdeBundle.message((String)key, (Object[])new Object[]{dependenciesText})).yesText(IdeBundle.message((String)(enabled ? "plugins.configurable.enable" : "plugins.configurable.disable"), (Object[])new Object[0]))).noText(Messages.getCancelButton())).ask(this.getProject());
    }

    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState> pair) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(20);
        }
        if (pair == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(21);
        }
    }

    protected static boolean isEnabled(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        PluginEnabledState state;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(22);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(23);
        }
        return (state = enabledMap.get(pluginId)) == null || state.isEnabled();
    }

    protected static boolean isDisabled(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        PluginEnabledState state;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(24);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(25);
        }
        return (state = enabledMap.get(pluginId)) == null || state.isDisabled();
    }

    protected static boolean isLoaded(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(26);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(27);
        }
        return enabledMap.get(pluginId) != null;
    }

    protected static boolean isDeleted(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(28);
        }
        return descriptor2 instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor2).isDeleted();
    }

    protected static boolean isHiddenImplementationDetail(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(29);
        }
        return HIDE_IMPLEMENTATION_DETAILS && descriptor2.isImplementationDetail();
    }

    protected static boolean isHidden(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(30);
        }
        return InstalledPluginsTableModel.isDeleted(descriptor2) || InstalledPluginsTableModel.isHiddenImplementationDetail(descriptor2);
    }

    @NotNull
    @NonNls
    protected static String getPluginNameOrId(@NotNull PluginId pluginId, @Nullable IdeaPluginDescriptor descriptor2) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(31);
        }
        String string = descriptor2 != null ? descriptor2.getName() : pluginId.getIdString();
        if (string == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginDescriptor";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeHandler";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 20: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesToEnable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentsToDisable";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNameOrId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLoaded";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enableRows";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNewEnabled";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 32: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesToEnable";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependentsToDisable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateDependenciesDialog";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDeleted";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isHiddenImplementationDetail";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPluginNameOrId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

