/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.core.CoreBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.InstallationSourceEnum;
import com.intellij.ide.plugins.org.PluginManagerFilters;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    static final Object ourLock = new Object();
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";

    private PluginInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static boolean prepareToUninstall(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) throws IOException {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(0);
        }
        Object object = ourLock;
        synchronized (object) {
            if (PluginManagerCore.isPluginInstalled(pluginDescriptor.getPluginId())) {
                if (pluginDescriptor.isBundled()) {
                    LOG.error("Plugin is bundled: " + pluginDescriptor.getPluginId());
                } else {
                    boolean needRestart;
                    boolean bl = needRestart = pluginDescriptor.isEnabled() && !DynamicPlugins.allowLoadUnloadWithoutRestart(pluginDescriptor);
                    if (needRestart) {
                        PluginInstaller.uninstallAfterRestart(pluginDescriptor.getPluginPath());
                    }
                    PluginStateManager.fireState(pluginDescriptor, false);
                    return needRestart;
                }
            }
        }
        return false;
    }

    private static void uninstallAfterRestart(@NotNull Path pluginPath) throws IOException {
        if (pluginPath == null) {
            PluginInstaller.$$$reportNull$$$0(1);
        }
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(pluginPath));
    }

    public static boolean uninstallDynamicPlugin(@Nullable JComponent parentComponent, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, boolean isUpdate) {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(2);
        }
        boolean uninstalledWithoutRestart = true;
        if (pluginDescriptor.isEnabled()) {
            DynamicPlugins.UnloadPluginOptions options2 = new DynamicPlugins.UnloadPluginOptions().withDisable(false).withUpdate(isUpdate).withWaitForClassloaderUnload(true);
            uninstalledWithoutRestart = parentComponent != null ? DynamicPlugins.INSTANCE.unloadPluginWithProgress(null, parentComponent, pluginDescriptor, options2) : DynamicPlugins.INSTANCE.unloadPlugin(pluginDescriptor, options2);
        }
        Path pluginPath = pluginDescriptor.getPluginPath();
        if (uninstalledWithoutRestart) {
            try {
                FileUtil.delete((Path)pluginPath);
            }
            catch (IOException e) {
                LOG.info("Failed to delete jar of dynamic plugin", (Throwable)e);
                uninstalledWithoutRestart = false;
            }
        }
        if (!uninstalledWithoutRestart) {
            try {
                PluginInstaller.uninstallAfterRestart(pluginPath);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return uninstalledWithoutRestart;
    }

    public static void installAfterRestart(@NotNull Path sourceFile, boolean deleteSourceFile, @Nullable Path existingPlugin, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(4);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        if (existingPlugin != null) {
            commands.add(new StartupActionScriptManager.DeleteCommand(existingPlugin));
        }
        Path pluginsPath = PluginInstaller.getPluginsPath();
        if (sourceFile.getFileName().toString().endsWith(".jar")) {
            commands.add(new StartupActionScriptManager.CopyCommand(sourceFile, pluginsPath.resolve(sourceFile.getFileName())));
        } else {
            commands.add(new StartupActionScriptManager.DeleteCommand(pluginsPath.resolve(PluginInstaller.rootEntryName(sourceFile))));
            commands.add(new StartupActionScriptManager.UnzipCommand(sourceFile, pluginsPath));
        }
        if (deleteSourceFile) {
            commands.add(new StartupActionScriptManager.DeleteCommand(sourceFile));
        }
        StartupActionScriptManager.addActionCommands(commands);
        PluginStateManager.fireState(descriptor2, true);
    }

    @Nullable
    private static Path installWithoutRestart(final @NotNull Path sourceFile, @NotNull IdeaPluginDescriptorImpl descriptor2, @Nullable JComponent parent) {
        Path result2;
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(6);
        }
        try {
            Task.WithResult<Path, IOException> task2 = new Task.WithResult<Path, IOException>(null, parent, IdeBundle.message((String)"progress.title.installing.plugin", (Object[])new Object[]{descriptor2.getName()}), false){

                protected Path compute(@NotNull ProgressIndicator indicator2) throws IOException {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return PluginInstaller.unpackPlugin(sourceFile, PluginInstaller.getPluginsPath());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller$1", "compute"));
                }
            };
            result2 = (Path)ProgressManager.getInstance().run((Task.WithResult)task2);
        }
        catch (Throwable throwable) {
            LOG.warn("Plugin " + descriptor2 + " failed to install without restart. " + throwable.getMessage(), throwable);
            result2 = null;
        }
        PluginStateManager.fireState(descriptor2, true);
        return result2;
    }

    @NotNull
    public static Path unpackPlugin(@NotNull Path sourceFile, @NotNull Path targetPath) throws IOException {
        Path target2;
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(7);
        }
        if (targetPath == null) {
            PluginInstaller.$$$reportNull$$$0(8);
        }
        if (sourceFile.getFileName().toString().endsWith(".jar")) {
            target2 = targetPath.resolve(sourceFile.getFileName());
            FileUtilRt.copy((File)sourceFile.toFile(), (File)target2.toFile());
        } else {
            target2 = targetPath.resolve(PluginInstaller.rootEntryName(sourceFile));
            FileUtilRt.delete((File)target2.toFile());
            new Decompressor.Zip(sourceFile).extract(targetPath);
        }
        Path path2 = target2;
        if (path2 == null) {
            PluginInstaller.$$$reportNull$$$0(9);
        }
        return path2;
    }

    public static String rootEntryName(@NotNull Path zip) throws IOException {
        if (zip == null) {
            PluginInstaller.$$$reportNull$$$0(10);
        }
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry zipEntry = entries2.nextElement();
                String name2 = zipEntry.getName();
                int i2 = name2.indexOf(47);
                if (i2 <= 0) continue;
                String string = name2.substring(0, i2);
                return string;
            }
        }
        throw new IOException("Corrupted archive (no file entries): " + zip);
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            PluginInstaller.$$$reportNull$$$0(11);
        }
        PluginStateManager.addStateListener(listener2);
    }

    static boolean installFromDisk(@NotNull File file2, @Nullable Project project, @Nullable JComponent parent) {
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(12);
        }
        return PluginInstaller.installFromDisk(new InstalledPluginsTableModel(project), PluginEnabler.HEADLESS, file2, parent, PluginInstaller::installPluginFromCallbackData);
    }

    static boolean installFromDisk(@NotNull InstalledPluginsTableModel model2, final @NotNull PluginEnabler pluginEnabler, @NotNull File file2, @Nullable JComponent parent, @NotNull Consumer<? super PluginInstallCallbackData> callback2) {
        if (model2 == null) {
            PluginInstaller.$$$reportNull$$$0(13);
        }
        if (pluginEnabler == null) {
            PluginInstaller.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(15);
        }
        if (callback2 == null) {
            PluginInstaller.$$$reportNull$$$0(16);
        }
        try {
            boolean isRestartRequired;
            Path path2 = file2.toPath();
            final IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(path2, null);
            if (pluginDescriptor == null) {
                MessagesEx.showErrorDialog(parent, IdeBundle.message((String)"dialog.message.fail.to.load.plugin.descriptor.from.file", (Object[])new Object[]{file2.getName()}), CommonBundle.getErrorTitle());
                return false;
            }
            if (!PluginManagerMain.checkThirdPartyPluginsAllowed(List.of(pluginDescriptor))) {
                return false;
            }
            if (!PluginManagerFilters.getInstance().allowInstallingPlugin(pluginDescriptor)) {
                String message2 = IdeBundle.message((String)"dialog.message.plugin.is.not.allowed", (Object[])new Object[]{pluginDescriptor.getName()});
                MessagesEx.showWarningDialog(parent, message2, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
                return false;
            }
            InstalledPluginsState ourState = InstalledPluginsState.getInstance();
            if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                String message3 = IdeBundle.message((String)"dialog.message.plugin.was.already.installed", (Object[])new Object[]{pluginDescriptor.getName()});
                MessagesEx.showWarningDialog(parent, message3, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
                return false;
            }
            PluginLoadingError error = PluginManagerCore.checkBuildNumberCompatibility(pluginDescriptor, PluginManagerCore.getBuildNumber());
            if (error != null) {
                MessagesEx.showErrorDialog(parent, error.getDetailedMessage(), CommonBundle.getErrorTitle());
                return false;
            }
            if (PluginManagerCore.isBrokenPlugin(pluginDescriptor)) {
                String message4 = CoreBundle.message((String)"plugin.loading.error.long.marked.as.broken", (Object[])new Object[]{pluginDescriptor.getName(), pluginDescriptor.getVersion()});
                MessagesEx.showErrorDialog(parent, message4, CommonBundle.getErrorTitle());
                return false;
            }
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginDescriptor.getPluginId());
            if (installedPlugin != null && ApplicationInfoEx.getInstanceEx().isEssentialPlugin(installedPlugin.getPluginId())) {
                String message5 = IdeBundle.message((String)"dialog.message.plugin.core.part", (Object[])new Object[]{pluginDescriptor.getName(), ApplicationNamesInfo.getInstance().getFullProductName()});
                MessagesEx.showErrorDialog(parent, message5, CommonBundle.getErrorTitle());
                return false;
            }
            PluginManagerUsageCollector.pluginInstallationStarted(pluginDescriptor, InstallationSourceEnum.FROM_DISK, installedPlugin != null ? installedPlugin.getVersion() : null);
            if (Registry.is((String)"custom-repository.certificate.signature.check") && !PluginSignatureChecker.verify(pluginDescriptor, file2, true)) {
                return false;
            }
            Task.WithResult<Pair<PluginInstallOperation, ? extends IdeaPluginDescriptor>, RuntimeException> task2 = new Task.WithResult<Pair<PluginInstallOperation, ? extends IdeaPluginDescriptor>, RuntimeException>(null, parent, IdeBundle.message((String)"progress.title.checking.plugin.dependencies", (Object[])new Object[0]), true){

                @NotNull
                protected Pair<PluginInstallOperation, ? extends IdeaPluginDescriptor> compute(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    PluginInstallOperation operation = new PluginInstallOperation(List.of(), CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins(), pluginEnabler, indicator2);
                    operation.setAllowInstallWithoutRestart(true);
                    Pair pair = operation.checkMissingDependencies(pluginDescriptor, null) ? Pair.create((Object)operation, (Object)operation.checkDependenciesAndReplacements(pluginDescriptor)) : Pair.empty();
                    if (pair == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return pair;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/plugins/PluginInstaller$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "compute";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "compute";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            Pair pair = (Pair)ProgressManager.getInstance().run((Task.WithResult)task2);
            PluginInstallOperation operation = (PluginInstallOperation)pair.getFirst();
            if (operation == null) {
                return false;
            }
            Path oldFile = installedPlugin != null && !installedPlugin.isBundled() ? installedPlugin.getPluginPath() : null;
            boolean bl = isRestartRequired = oldFile != null || !DynamicPlugins.allowLoadUnloadWithoutRestart(pluginDescriptor) || operation.isRestartRequired();
            if (isRestartRequired) {
                PluginInstaller.installAfterRestart(path2, false, oldFile, pluginDescriptor);
            }
            ourState.onPluginInstall(pluginDescriptor, installedPlugin != null, isRestartRequired);
            IdeaPluginDescriptor toDisable = (IdeaPluginDescriptor)pair.getSecond();
            if (toDisable != null) {
                pluginEnabler.disablePlugins(Set.of(toDisable));
            }
            Set<PluginInstallCallbackData> installedDependencies = operation.getInstalledDependentPlugins();
            ArrayList<IdeaPluginDescriptorImpl> installedPlugins = new ArrayList<IdeaPluginDescriptorImpl>();
            installedPlugins.add(pluginDescriptor);
            for (PluginInstallCallbackData plugin2 : installedDependencies) {
                installedPlugins.add(plugin2.getPluginDescriptor());
            }
            Set<String> notInstalled = PluginInstaller.findNotInstalledPluginDependencies(pluginDescriptor.getDependencies(), model2, ContainerUtil.map2Set(installedPlugins, PluginDescriptor::getPluginId));
            if (!notInstalled.isEmpty()) {
                String message6 = IdeBundle.message((String)"dialog.message.plugin.depends.on.unknown.plugin", (Object[])new Object[]{pluginDescriptor.getName(), notInstalled.size(), StringUtil.join(notInstalled, (String)", ")});
                MessagesEx.showWarningDialog(parent, message6, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
            }
            PluginManagerMain.suggestToEnableInstalledDependantPlugins(pluginEnabler, installedPlugins);
            callback2.accept(new PluginInstallCallbackData(path2, pluginDescriptor, isRestartRequired));
            for (PluginInstallCallbackData callbackData : installedDependencies) {
                if (callbackData.getPluginDescriptor().getPluginId().equals((Object)pluginDescriptor.getPluginId())) continue;
                callback2.accept(callbackData);
            }
            if (path2.toString().endsWith(".zip") && Registry.is((String)"ide.plugins.keep.archive")) {
                File tempFile = MarketplacePluginDownloadService.getPluginTempFile();
                FileUtil.copy((File)file2, (File)tempFile);
                MarketplacePluginDownloadService.renameFileToZipRoot(tempFile);
            }
            return true;
        }
        catch (IOException ex) {
            MessagesEx.showErrorDialog(parent, ex.getMessage(), CommonBundle.getErrorTitle());
            return false;
        }
    }

    public static boolean installAndLoadDynamicPlugin(@NotNull Path file2, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(17);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(18);
        }
        return PluginInstaller.installAndLoadDynamicPlugin(file2, null, descriptor2);
    }

    public static boolean installAndLoadDynamicPlugin(@NotNull Path file2, @Nullable JComponent parent, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        Path targetFile;
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(19);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(20);
        }
        if ((targetFile = PluginInstaller.installWithoutRestart(file2, descriptor2, parent)) == null) {
            return false;
        }
        IdeaPluginDescriptorImpl targetDescriptor = PluginDescriptorLoader.loadDescriptor(targetFile, DisabledPluginsState.disabledPlugins(), false, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER);
        if (targetDescriptor == null) {
            return false;
        }
        return DynamicPlugins.INSTANCE.loadPlugin(targetDescriptor);
    }

    @NotNull
    private static Set<String> findNotInstalledPluginDependencies(@NotNull List<? extends IdeaPluginDependency> dependencies2, @NotNull InstalledPluginsTableModel model2, @NotNull Set<PluginId> installedDependencies) {
        if (dependencies2 == null) {
            PluginInstaller.$$$reportNull$$$0(21);
        }
        if (model2 == null) {
            PluginInstaller.$$$reportNull$$$0(22);
        }
        if (installedDependencies == null) {
            PluginInstaller.$$$reportNull$$$0(23);
        }
        HashSet<String> notInstalled = new HashSet<String>();
        for (IdeaPluginDependency ideaPluginDependency : dependencies2) {
            PluginId pluginId;
            if (ideaPluginDependency.isOptional() || installedDependencies.contains(pluginId = ideaPluginDependency.getPluginId()) || model2.isLoaded(pluginId) || PluginManagerCore.isModuleDependency(pluginId)) continue;
            notInstalled.add(pluginId.getIdString());
        }
        HashSet<String> hashSet = notInstalled;
        if (hashSet == null) {
            PluginInstaller.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    static void chooseAndInstall(@Nullable Project project, @Nullable JComponent parent, @NotNull BiConsumer<? super File, ? super JComponent> callback2) {
        if (callback2 == null) {
            PluginInstaller.$$$reportNull$$$0(25);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, true, false, false){
            {
                this.setTitle(IdeBundle.message((String)"chooser.title.plugin.file", (Object[])new Object[0]));
                this.setDescription(IdeBundle.message((String)"chooser.description.jar.and.zip.archives.are.accepted", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(@Nullable VirtualFile file2) {
                if (file2 == null) {
                    return false;
                }
                String extension2 = file2.getExtension();
                return Comparing.strEqual((String)extension2, (String)"jar") || Comparing.strEqual((String)extension2, (String)"zip");
            }
        };
        String oldPath = PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH);
        VirtualFile toSelect2 = oldPath != null ? VfsUtil.findFileByIoFile((File)new File(FileUtilRt.toSystemDependentName((String)oldPath)), (boolean)false) : null;
        FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, (Component)parent, (VirtualFile)toSelect2, virtualFile2 -> {
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile2);
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, FileUtilRt.toSystemIndependentName((String)file2.getParent()));
            callback2.accept(file2, parent);
        });
    }

    @NotNull
    private static Path getPluginsPath() {
        Path path2 = Paths.get(PathManager.getPluginsPath(), new String[0]);
        if (path2 == null) {
            PluginInstaller.$$$reportNull$$$0(26);
        }
        return path2;
    }

    private static void installPluginFromCallbackData(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            PluginInstaller.$$$reportNull$$$0(27);
        }
        IdeaPluginDescriptorImpl descriptor2 = callbackData.getPluginDescriptor();
        if (!callbackData.getRestartNeeded() && PluginInstaller.installAndLoadDynamicPlugin(callbackData.getFile(), descriptor2)) {
            return;
        }
        PluginManagerConfigurable.shutdownOrRestartAppAfterInstall(PluginManagerConfigurable.getUpdatesDialogTitle(), action2 -> IdeBundle.message((String)"plugin.installed.ide.restart.required.message", (Object[])new Object[]{descriptor2.getName(), action2, ApplicationNamesInfo.getInstance().getFullProductName()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 4: 
            case 6: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstaller";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedDependencies";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackPlugin";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotInstalledPluginDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareToUninstall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uninstallAfterRestart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uninstallDynamicPlugin";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installAfterRestart";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installWithoutRestart";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unpackPlugin";
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rootEntryName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installFromDisk";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installAndLoadDynamicPlugin";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findNotInstalledPluginDependencies";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndInstall";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "installPluginFromCallbackData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

