/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.certificates;

import com.intellij.ide.plugins.certificates.PluginCertificateStore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/plugins/certificates/PluginCertificateStore;", "", "()V", "DEFAULT_PASSWORD", "", "DEFAULT_PATH", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANAGED_TRUSTSTORE_PATH", "customTrustManager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "getCustomTrustManager", "()Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "customTrustManager$delegate", "Lkotlin/Lazy;", "managedTrustedCertificates", "", "Ljava/security/cert/X509Certificate;", "getManagedTrustedCertificates", "()Ljava/util/List;", "managedTrustedCertificates$delegate", "loadCertificates", "storePath", "intellij.platform.ide.impl"})
public final class PluginCertificateStore {
    private static final Logger LOG;
    private static final String MANAGED_TRUSTSTORE_PATH;
    private static final String DEFAULT_PATH;
    private static final String DEFAULT_PASSWORD = "changeit";
    @NotNull
    private static final Lazy customTrustManager$delegate;
    @NotNull
    private static final Lazy managedTrustedCertificates$delegate;
    @NotNull
    public static final PluginCertificateStore INSTANCE;

    @NotNull
    public final ConfirmingTrustManager.MutableTrustManager getCustomTrustManager() {
        Lazy lazy = customTrustManager$delegate;
        PluginCertificateStore pluginCertificateStore = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConfirmingTrustManager.MutableTrustManager)lazy.getValue();
    }

    @NotNull
    public final List<X509Certificate> getManagedTrustedCertificates() {
        Lazy lazy = managedTrustedCertificates$delegate;
        PluginCertificateStore pluginCertificateStore = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509Certificate> loadCertificates(String storePath) {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean bl = false;
        Path path2 = Paths.get(storePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(path)");
        Path keystorePath = path2;
        Object object = keystorePath;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl2 = false;
        if (Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                InputStream inputStream2 = PathKt.inputStream((Path)keystorePath);
                object = DEFAULT_PASSWORD;
                boolean bl3 = false;
                char[] cArray = ((String)object).toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                keystore.load(inputStream2, cArray);
                Enumeration<String> enumeration = keystore.aliases();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keystore.aliases()");
                object = enumeration;
                bl3 = false;
                ArrayList<String> arrayList = Collections.list(object);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                object = arrayList;
                boolean $i$f$mapNotNull = false;
                void var6_10 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    X509Certificate x509Certificate;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    String it = (String)element$iv$iv;
                    boolean bl5 = false;
                    Certificate certificate = keystore.getCertificate(it);
                    if (!(certificate instanceof X509Certificate)) {
                        certificate = null;
                    }
                    if ((X509Certificate)certificate == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    X509Certificate it$iv$iv = x509Certificate;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            catch (Exception e) {
                LOG.warn("Failed to load managed plugin truststore", (Throwable)e);
            }
        }
        return CollectionsKt.emptyList();
    }

    private PluginCertificateStore() {
    }

    static {
        PluginCertificateStore pluginCertificateStore;
        INSTANCE = pluginCertificateStore = new PluginCertificateStore();
        Logger logger = Logger.getInstance(PluginCertificateStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Plugi\u2026ificateStore::class.java)");
        LOG = logger;
        MANAGED_TRUSTSTORE_PATH = System.getProperty("intellij.plugin.truststore", "");
        DEFAULT_PATH = String.join((CharSequence)File.separator, PathManager.getConfigPath(), "ssl", "plugins-certs");
        customTrustManager$delegate = LazyKt.lazy((Function0)customTrustManager.2.INSTANCE);
        managedTrustedCertificates$delegate = LazyKt.lazy((Function0)managedTrustedCertificates.2.INSTANCE);
    }

    public static final /* synthetic */ String access$getDEFAULT_PATH$p(PluginCertificateStore $this) {
        PluginCertificateStore pluginCertificateStore = $this;
        return DEFAULT_PATH;
    }

    public static final /* synthetic */ String access$getMANAGED_TRUSTSTORE_PATH$p(PluginCertificateStore $this) {
        PluginCertificateStore pluginCertificateStore = $this;
        return MANAGED_TRUSTSTORE_PATH;
    }

    public static final /* synthetic */ List access$loadCertificates(PluginCertificateStore $this, String storePath) {
        return $this.loadCertificates(storePath);
    }
}

