/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.enums.PluginsGroupType;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.SearchPopupController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchResultPanel {
    public final SearchPopupController controller;
    public final int tabIndex;
    public final int backTabIndex;
    protected final PluginsGroupComponent myPanel;
    private JScrollBar myVerticalScrollBar;
    private PluginsGroup myGroup;
    private String myQuery;
    private AtomicBoolean myRunQuery;
    private boolean myEmpty;
    private boolean isMarketplace;
    protected Runnable myPostFillGroupCallback;

    public SearchResultPanel(@Nullable SearchPopupController controller, @NotNull PluginsGroupComponent panel2, boolean isMarketplace, int tabIndex, int backTabIndex) {
        if (panel2 == null) {
            SearchResultPanel.$$$reportNull$$$0(0);
        }
        this.myEmpty = true;
        this.controller = controller;
        this.myPanel = panel2;
        this.tabIndex = tabIndex;
        this.backTabIndex = backTabIndex;
        this.isMarketplace = isMarketplace;
        this.myGroup = new PluginsGroup(IdeBundle.message((String)"title.search.results", (Object[])new Object[0]), isMarketplace ? PluginsGroupType.SEARCH : PluginsGroupType.SEARCH_INSTALLED);
        this.setEmptyText("");
        if (this.isProgressMode()) {
            this.loading(false);
        }
    }

    @NotNull
    public PluginsGroupComponent getPanel() {
        PluginsGroupComponent pluginsGroupComponent = this.myPanel;
        if (pluginsGroupComponent == null) {
            SearchResultPanel.$$$reportNull$$$0(1);
        }
        return pluginsGroupComponent;
    }

    @NotNull
    public PluginsGroup getGroup() {
        PluginsGroup pluginsGroup = this.myGroup;
        if (pluginsGroup == null) {
            SearchResultPanel.$$$reportNull$$$0(2);
        }
        return pluginsGroup;
    }

    @NotNull
    public JComponent createScrollPane() {
        JBScrollPane pane2 = new JBScrollPane((Component)((Object)this.myPanel));
        pane2.setBorder((Border)JBUI.Borders.empty());
        if (this.isProgressMode()) {
            this.myVerticalScrollBar = pane2.getVerticalScrollBar();
        }
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            SearchResultPanel.$$$reportNull$$$0(3);
        }
        return jBScrollPane;
    }

    @NotNull
    public JComponent createVScrollPane() {
        JBScrollPane pane2 = (JBScrollPane)this.createScrollPane();
        pane2.setVerticalScrollBarPolicy(20);
        pane2.setHorizontalScrollBarPolicy(31);
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            SearchResultPanel.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    protected void setEmptyText(@NotNull String query2) {
        if (query2 == null) {
            SearchResultPanel.$$$reportNull$$$0(5);
        }
        this.myPanel.getEmptyText().setText(IdeBundle.message((String)"empty.text.nothing.found", (Object[])new Object[0]));
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    public void setEmpty() {
        this.myEmpty = true;
        this.myQuery = "";
    }

    @NotNull
    public String getQuery() {
        String string = StringUtil.defaultIfEmpty((String)this.myQuery, (String)"");
        if (string == null) {
            SearchResultPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setQuery(@NotNull String query2) {
        if (query2 == null) {
            SearchResultPanel.$$$reportNull$$$0(7);
        }
        assert (SwingUtilities.isEventDispatchThread());
        this.setEmptyText(query2);
        if (query2.equals(this.myQuery)) {
            this.myEmpty = query2.isEmpty();
            return;
        }
        if (this.myRunQuery != null) {
            this.myRunQuery.set(false);
            this.myRunQuery = null;
            this.loading(false);
        }
        this.removeGroup();
        this.myQuery = query2;
        this.myEmpty = query2.isEmpty();
        if (!this.myEmpty) {
            this.handleQuery(query2);
        }
    }

    private void handleQuery(@NotNull String query2) {
        if (query2 == null) {
            SearchResultPanel.$$$reportNull$$$0(8);
        }
        if (this.isProgressMode()) {
            this.loading(true);
            AtomicBoolean runQuery = this.myRunQuery = new AtomicBoolean(true);
            PluginsGroup group2 = this.myGroup;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.handleQuery(query2, group2);
                ApplicationManager.getApplication().invokeLater(() -> {
                    assert (SwingUtilities.isEventDispatchThread());
                    if (!runQuery.get()) {
                        return;
                    }
                    this.myRunQuery = null;
                    this.loading(false);
                    if (!this.myGroup.descriptors.isEmpty()) {
                        this.myGroup.titleWithCount();
                        try {
                            PluginLogo.startBatchMode();
                            this.myPanel.addLazyGroup(this.myGroup, this.myVerticalScrollBar, 100, this::fullRepaint);
                        }
                        finally {
                            PluginLogo.endBatchMode();
                        }
                    }
                    this.myPanel.initialSelection(false);
                    this.runPostFillGroupCallback();
                    this.fullRepaint();
                }, ModalityState.any());
            });
        } else {
            this.handleQuery(query2, this.myGroup);
            if (!this.myGroup.descriptors.isEmpty()) {
                this.myPanel.addGroup(this.myGroup);
                this.myGroup.titleWithCount();
                this.myPanel.initialSelection(false);
            }
            this.runPostFillGroupCallback();
            this.fullRepaint();
        }
    }

    protected abstract void handleQuery(@NotNull String var1, @NotNull PluginsGroup var2);

    private void runPostFillGroupCallback() {
        if (this.myPostFillGroupCallback != null) {
            this.myPostFillGroupCallback.run();
            this.myPostFillGroupCallback = null;
        }
    }

    private void loading(boolean start2) {
        PluginsGroupComponentWithProgress panel2 = (PluginsGroupComponentWithProgress)this.myPanel;
        if (start2) {
            panel2.startLoading();
        } else {
            panel2.stopLoading();
        }
    }

    public void dispose() {
        if (this.isProgressMode()) {
            ((PluginsGroupComponentWithProgress)this.myPanel).dispose();
        }
    }

    private boolean isProgressMode() {
        return this.myPanel instanceof PluginsGroupComponentWithProgress;
    }

    public void removeGroup() {
        if (this.myGroup.ui != null) {
            this.myPanel.removeGroup(this.myGroup);
            this.fullRepaint();
        }
        this.myGroup = new PluginsGroup(IdeBundle.message((String)"title.search.results", (Object[])new Object[0]), this.isMarketplace ? PluginsGroupType.SEARCH : PluginsGroupType.SEARCH_INSTALLED);
    }

    public void fullRepaint() {
        this.myPanel.doLayout();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchResultPanel";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchResultPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVScrollPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setQuery";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

