/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.TabHeaderListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedPaneHeaderComponent
extends JPanel {
    private final JBValue myHeight;
    private final JBValue myGap;
    private final JBValue myYOffset;
    private final JBTabbedPane myTabbedPane;
    private final TabHeaderListener myListener;

    public TabbedPaneHeaderComponent(@NotNull DefaultActionGroup actions2, @NotNull TabHeaderListener listener2) {
        if (actions2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(1);
        }
        this.myHeight = new JBValue.Float(30.0f);
        this.myGap = new JBValue.Float(10.0f);
        this.myYOffset = new JBValue.Float(32.0f);
        this.myTabbedPane = new JBTabbedPane(){

            public void setUI(TabbedPaneUI ui2) {
                boolean value2 = UIManager.getBoolean("TabbedPane.contentOpaque");
                UIManager.getDefaults().put("TabbedPane.contentOpaque", Boolean.FALSE);
                try {
                    super.setUI(ui2);
                }
                finally {
                    UIManager.getDefaults().put("TabbedPane.contentOpaque", (Object)value2);
                }
            }
        };
        this.myListener = listener2;
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                assert (parent.getComponentCount() == 2);
                int width = parent.getComponent((int)0).getPreferredSize().width * 2 + TabbedPaneHeaderComponent.this.myGap.get() + parent.getComponent((int)1).getPreferredSize().width;
                return new Dimension(width, TabbedPaneHeaderComponent.this.myHeight.get());
            }

            public void layoutContainer(Container parent) {
                assert (parent.getComponentCount() == 2);
                Component tabbedPane = parent.getComponent(0);
                Component toolbar = parent.getComponent(1);
                Dimension toolbarSize = toolbar.getPreferredSize();
                int width = tabbedPane.getPreferredSize().width * 2;
                int height = parent.getHeight();
                int gap = TabbedPaneHeaderComponent.this.myGap.get();
                int x = (parent.getWidth() - width - gap - toolbarSize.width) / 2 - width / 4;
                int y = height > 0 ? height - TabbedPaneHeaderComponent.this.myYOffset.get() : 0;
                int toolbarY = (y + height - toolbarSize.height) / 2;
                tabbedPane.setBounds(x, y, width, height - y);
                toolbar.setBounds(x + width + gap, toolbarY - JBUI.scale((int)1), toolbarSize.width, height);
            }
        });
        this.setOpaque(false);
        this.myTabbedPane.setOpaque(false);
        this.add((Component)this.myTabbedPane);
        this.add((Component)TabbedPaneHeaderComponent.createToolbar(actions2, IdeBundle.message((String)"plugin.manager.tooltip", (Object[])new Object[0]), AllIcons.General.GearPlain), "East");
    }

    @NotNull
    static JComponent createToolbar(final @NotNull DefaultActionGroup actions2, @Nullable @NlsActions.ActionText String tooltip2, @NotNull Icon icon2) {
        if (actions2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(2);
        }
        if (icon2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(3);
        }
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("PluginsHeaderToolbar", (ActionGroup)toolbarActionGroup, true);
        toolbar.setTargetComponent(toolbar.getComponent());
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setLayoutPolicy(0);
        final JComponent toolbarComponent = toolbar.getComponent();
        toolbarActionGroup.add((AnAction)new DumbAwareAction(tooltip2, tooltip2, icon2){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                final ListPopup actionGroupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions2, e.getDataContext(), true, null, Integer.MAX_VALUE);
                HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)actionGroupPopup);
                final Component component2 = toolbarComponent.getComponent(0);
                final Container dialogComponent = ((JComponent)component2).getRootPane().getParent();
                if (dialogComponent != null) {
                    final ComponentAdapter listener2 = new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            this.movePopup();
                        }

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            this.movePopup();
                        }

                        private void movePopup() {
                            if (actionGroupPopup.isVisible()) {
                                actionGroupPopup.setLocation(new RelativePoint(component2, this.getPopupPoint()).getScreenPoint());
                                actionGroupPopup.pack(true, true);
                            }
                        }
                    };
                    dialogComponent.addComponentListener(listener2);
                    actionGroupPopup.addListener(new JBPopupListener(){

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            dialogComponent.removeComponentListener(listener2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent$3$2", "onClosed"));
                        }
                    });
                }
                actionGroupPopup.show(new RelativePoint(component2, this.getPopupPoint()));
            }

            private Point getPopupPoint() {
                int dH = UIUtil.isUnderWin10LookAndFeel() ? JBUIScale.scale((int)1) : 0;
                return new Point(JBUIScale.scale((int)2), toolbarComponent.getComponent(0).getHeight() - dH);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent$3", "actionPerformed"));
            }
        });
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        JComponent jComponent = toolbarComponent;
        if (jComponent == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, 0, width, height + y);
    }

    public void setListener() {
        this.myTabbedPane.addChangeListener(e -> this.myListener.selectionChanged(this.myTabbedPane.getSelectedIndex()));
    }

    public void update() {
        this.doLayout();
        this.revalidate();
        this.myTabbedPane.doLayout();
        this.myTabbedPane.revalidate();
        this.repaint();
    }

    public void addTab(@NotNull @Nls String title2, @Nullable Icon icon2) {
        if (title2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(5);
        }
        this.myTabbedPane.addTab(title2, icon2, (Component)new JLabel());
        if (icon2 != null) {
            Component tab = this.myTabbedPane.getTabComponentAt(this.myTabbedPane.getTabCount() - 1);
            ((JLabel)tab).setHorizontalTextPosition(2);
        }
    }

    public int getSelectionTab() {
        return this.myTabbedPane.getSelectedIndex();
    }

    public void setSelection(int index2) {
        this.myTabbedPane.setSelectedIndex(index2);
    }

    public void setSelectionWithEvents(int index2) {
        this.setSelection(index2);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Runnable action2 = () -> this.setSelectionWithEvents(this.myTabbedPane.getSelectedIndex() == 0 ? 1 : 0);
        this.addTabSelectionAction("NextTab", action2);
        this.addTabSelectionAction("PreviousTab", action2);
    }

    private void addTabSelectionAction(@NotNull String actionId, @NotNull Runnable callback2) {
        if (actionId == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(6);
        }
        if (callback2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(7);
        }
        EventHandler.addGlobalAction(this, actionId, () -> {
            if (this.myTabbedPane.getTabCount() > 0) {
                callback2.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTab";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTabSelectionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

