/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DetachLibraryDeleteProvider
implements DeleteProvider {
    private final Project myProject;
    private final LibraryOrderEntry myOrderEntry;

    DetachLibraryDeleteProvider(@NotNull Project project, @NotNull LibraryOrderEntry orderEntry) {
        if (project == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(0);
        }
        if (orderEntry == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myOrderEntry = orderEntry;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        String title2;
        if (dataContext == null) {
            DetachLibraryDeleteProvider.$$$reportNull$$$0(3);
        }
        Module module = this.myOrderEntry.getOwnerModule();
        String message2 = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{this.myOrderEntry.getPresentableName(), module.getName()});
        int ret = Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)(title2 = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(module.getProject(), () -> {
            Runnable action2 = () -> {
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                OrderEntry[] orderEntries = rootManager.getOrderEntries();
                ModifiableRootModel model2 = rootManager.getModifiableModel();
                OrderEntry[] modifiableEntries = model2.getOrderEntries();
                for (int i2 = 0; i2 < orderEntries.length; ++i2) {
                    OrderEntry entry2 = orderEntries[i2];
                    if (!(entry2 instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry2).getLibrary() != this.myOrderEntry.getLibrary()) continue;
                    model2.removeOrderEntry(modifiableEntries[i2]);
                }
                model2.commit();
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, title2, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/DetachLibraryDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

