/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.startup.impl.StartupManagerImplKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerExImplKt;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J4\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010 0\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0016J\b\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020\u0015H\u0007J\u0010\u0010&\u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u000eH\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u000eH\u0016J.\u0010*\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J$\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u0002022\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u00103\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u000eH\u0016J\u0016\u00104\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020605H\u0002J\b\u00107\u001a\u00020\u0015H\u0002J\b\u00108\u001a\u00020\u0015H\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u00100\u001a\u00020 H\u0002J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u000eH\u0016J\b\u0010<\u001a\u00020\u0015H\u0002J\b\u0010=\u001a\u00020\nH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/ide/startup/impl/StartupManagerImpl;", "Lcom/intellij/ide/startup/StartupManagerEx;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allActivitiesPassed", "Ljava/util/concurrent/CompletableFuture;", "", "isStartupActivitiesPassed", "", "lock", "postStartupActivities", "Ljava/util/ArrayDeque;", "Ljava/lang/Runnable;", "postStartupActivitiesPassed", "", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "startupActivities", "checkCleared", "", "checkNonDefaultProject", "checkThatPostActivitiesNotPassed", "dispose", "executeActivityFromExtensionPoint", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "extensionPointName", "", "supplier", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/startup/StartupActivity;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAllActivitiesPassedFuture", "postStartupActivityPassed", "prepareForNextTest", "projectOpened", "registerPostStartupActivity", "runnable", "registerStartupActivity", "runActivities", "activities", "Ljava/util/Deque;", "activityName", "runActivityAndMeasureDuration", "", "activity", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "runAfterOpened", "runBackgroundPostStartupActivities", "", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "runPostStartupActivities", "runPostStartupActivitiesRegisteredDynamically", "runStartupActivity", "runWhenProjectIsInitialized", "action", "scheduleBackgroundPostStartupActivities", "startupActivityPassed", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class StartupManagerImpl
extends StartupManagerEx
implements Disposable {
    private final Object lock;
    private final ArrayDeque<Runnable> startupActivities;
    private final ArrayDeque<Runnable> postStartupActivities;
    private volatile int postStartupActivitiesPassed;
    private final CompletableFuture<Object> allActivitiesPassed;
    private volatile boolean isStartupActivitiesPassed;
    private ScheduledFuture<?> scheduledFuture;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void checkNonDefaultProject() {
        StartupManagerImplKt.access$getLOG$p().assertTrue(!this.project.isDefault(), (Object)"Please don't register startup activities for the default project: they won't ever be run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStartupActivity(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.checkNonDefaultProject();
        StartupManagerImplKt.access$getLOG$p().assertTrue(!this.isStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.startupActivities.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPostStartupActivity(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        if (DumbService.isDumbAware((Object)runnable2)) {
            this.runAfterOpened(runnable2);
            return;
        }
        this.checkNonDefaultProject();
        this.checkThatPostActivitiesNotPassed();
        StartupManagerImplKt.access$getLOG$p().warn("Activities registered via registerPostStartupActivity must be dumb-aware: " + runnable2);
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.checkThatPostActivitiesNotPassed();
            bl2 = this.postStartupActivities.add((Runnable)new DumbAwareRunnable(this, runnable2){
                final /* synthetic */ StartupManagerImpl this$0;
                final /* synthetic */ Runnable $runnable$inlined;
                {
                    this.this$0 = startupManagerImpl;
                    this.$runnable$inlined = runnable2;
                }

                public final void run() {
                    DumbService.getInstance((Project)StartupManagerImpl.access$getProject$p(this.this$0)).unsafeRunWhenSmart(this.$runnable$inlined);
                }
            });
        }
    }

    private final void checkThatPostActivitiesNotPassed() {
        if (this.postStartupActivityPassed()) {
            StartupManagerImplKt.access$getLOG$p().error("Registering post-startup activity that will never be run (" + " disposed=" + this.project.isDisposed() + ", open=" + this.project.isOpen() + ", passed=" + this.isStartupActivitiesPassed + ")");
        }
    }

    @Override
    public boolean startupActivityPassed() {
        return this.isStartupActivitiesPassed;
    }

    public boolean postStartupActivityPassed() {
        boolean bl;
        switch (this.postStartupActivitiesPassed) {
            case 2: {
                bl = true;
                break;
            }
            case -1: {
                throw (Throwable)new RuntimeException("Aborted; check the log for a reason");
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public CompletableFuture<Object> getAllActivitiesPassedFuture() {
        return this.allActivitiesPassed;
    }

    public final void projectOpened(@Nullable ProgressIndicator indicator2) {
        Application app2 = ApplicationManager.getApplication();
        if (indicator2 != null) {
            Application application = app2;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isInternal()) {
                indicator2.setText(IdeBundle.message((String)"startup.indicator.text.running.startup.activities", (Object[])new Object[0]));
            }
        }
        StartupManagerImplKt.access$getLOG$p().assertTrue(!this.isStartupActivitiesPassed);
        String name$iv = "project startup";
        ActivityCategory category$iv = ActivityCategory.DEFAULT;
        boolean $i$f$runActivity = false;
        Activity activity = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startActivity(name, category)");
        Activity activity$iv = activity;
        boolean bl = false;
        StartupManagerImpl.runActivities$default(this, this.startupActivities, null, indicator2, 2, null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ExtensionsArea extensionsArea = application.getExtensionArea();
        if (extensionsArea == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionsAreaImpl");
        }
        ExtensionPointImpl extensionPointImpl = ((ExtensionsAreaImpl)extensionsArea).getExtensionPoint("com.intellij.startupActivity");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointImpl, (String)"(ApplicationManager.getA\u2026ntellij.startupActivity\")");
        ExtensionPointImpl extensionPoint = extensionPointImpl;
        String string = extensionPoint.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionPoint.name");
        String extensionPointName = string;
        extensionPoint.processImplementations(true, new BiConsumer(extensionPointName, this, indicator2){
            final /* synthetic */ String $extensionPointName;
            final /* synthetic */ StartupManagerImpl this$0;
            final /* synthetic */ ProgressIndicator $indicator$inlined;
            {
                this.$extensionPointName = string;
                this.this$0 = startupManagerImpl;
                this.$indicator$inlined = progressIndicator;
            }

            public final void accept(Supplier<? extends StartupActivity> supplier2, PluginDescriptor descriptor2) {
                PluginDescriptor pluginDescriptor = descriptor2;
                Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"descriptor");
                Supplier<? extends StartupActivity> supplier3 = supplier2;
                Intrinsics.checkNotNullExpressionValue(supplier3, (String)"supplier");
                StartupManagerImpl.access$executeActivityFromExtensionPoint(this.this$0, pluginDescriptor, this.$extensionPointName, supplier3, this.$indicator$inlined);
            }
        });
        this.isStartupActivitiesPassed = true;
        Unit result$iv = Unit.INSTANCE;
        activity$iv.end();
        ProgressIndicator progressIndicator = indicator2;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        StartUpMeasurer.compareAndSetCurrentState((LoadingState)LoadingState.COMPONENTS_LOADED, (LoadingState)LoadingState.PROJECT_OPENED);
        StartUpMeasurer.compareAndSetCurrentState((LoadingState)LoadingState.APP_STARTED, (LoadingState)LoadingState.PROJECT_OPENED);
        Application application2 = app2;
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"app");
        if (application2.isUnitTestMode() && !app2.isDispatchThread()) {
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.project, new Runnable(this){
                final /* synthetic */ StartupManagerImpl this$0;

                public final void run() {
                    StartupManagerImpl.access$runPostStartupActivities(this.this$0);
                }
                {
                    this.this$0 = startupManagerImpl;
                }
            });
        } else {
            ForkJoinPool.commonPool().execute(new Runnable(this){
                final /* synthetic */ StartupManagerImpl this$0;

                public final void run() {
                    if (!StartupManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        try {
                            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)StartupManagerImpl.access$getProject$p(this.this$0), new Runnable(this){
                                final /* synthetic */ projectOpened.3 this$0;

                                public final void run() {
                                    StartupManagerImpl.access$runPostStartupActivities(this.this$0.this$0);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                    }
                }
                {
                    this.this$0 = startupManagerImpl;
                }
            });
            if (app2.isUnitTestMode()) {
                StartupManagerImplKt.access$getLOG$p().assertTrue(app2.isDispatchThread());
                ProjectManagerExImplKt.waitAndProcessInvocationEventsInIdeEventQueue(this);
            }
        }
    }

    private final void executeActivityFromExtensionPoint(PluginDescriptor descriptor2, String extensionPointName, Supplier<? extends StartupActivity> supplier2, ProgressIndicator indicator2) {
        block3: {
            if (this.project.isDisposed()) {
                return;
            }
            PluginId pluginId = descriptor2.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"descriptor.pluginId");
            PluginId pluginId2 = pluginId;
            if (Intrinsics.areEqual((Object)pluginId2, (Object)PluginManagerCore.CORE_ID) ^ true && Intrinsics.areEqual((Object)pluginId2, (Object)PluginManagerCore.JAVA_PLUGIN_ID) ^ true && Intrinsics.areEqual((Object)pluginId2.getIdString(), (Object)"com.jetbrains.performancePlugin") ^ true && Intrinsics.areEqual((Object)pluginId2.getIdString(), (Object)"com.intellij.kotlinNative.platformDeps") ^ true) {
                StartupManagerImplKt.access$getLOG$p().error("Only bundled plugin can define " + extensionPointName + ": " + descriptor2);
                return;
            }
            ProgressIndicator progressIndicator = indicator2;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            StartupActivity startupActivity = supplier2.get();
            if (startupActivity == null) break block3;
            StartupActivity startupActivity2 = startupActivity;
            boolean bl = false;
            boolean bl2 = false;
            StartupActivity it = startupActivity2;
            boolean bl3 = false;
            this.runActivityAndMeasureDuration(it, pluginId2, indicator2);
        }
    }

    private final void runPostStartupActivities() {
        try {
            StartupManagerImplKt.access$getLOG$p().assertTrue(this.isStartupActivitiesPassed);
            PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)snapshot, (String)"PerformanceWatcher.takeSnapshot()");
            PerformanceWatcher.Snapshot snapshot2 = snapshot;
            Activity activity = StartUpMeasurer.startActivity((String)"project post-startup dumb-aware activities");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026POST_START_UP_ACTIVITIES)");
            Activity dumbAwareActivity = activity;
            AtomicReference edtActivity = new AtomicReference();
            AtomicBoolean uiFreezeWarned = new AtomicBoolean();
            AtomicInteger counter = new AtomicInteger();
            DumbService dumbService = DumbService.getInstance((Project)this.project);
            StartupActivity.POST_STARTUP_ACTIVITY.processWithPluginDescriptor(new BiConsumer(this, dumbService, edtActivity, counter, uiFreezeWarned){
                final /* synthetic */ StartupManagerImpl this$0;
                final /* synthetic */ DumbService $dumbService;
                final /* synthetic */ AtomicReference $edtActivity;
                final /* synthetic */ AtomicInteger $counter;
                final /* synthetic */ AtomicBoolean $uiFreezeWarned;

                public final void accept(@NotNull StartupActivity extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    if (StartupManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        return;
                    }
                    if (DumbService.isDumbAware((Object)extension2)) {
                        this.$dumbService.runWithWaitForSmartModeDisabled(new Runnable(this, extension2, pluginDescriptor){
                            final /* synthetic */ runPostStartupActivities.1 this$0;
                            final /* synthetic */ StartupActivity $extension;
                            final /* synthetic */ PluginDescriptor $pluginDescriptor;

                            public final void run() {
                                StartupManagerImpl startupManagerImpl = this.this$0.this$0;
                                PluginId pluginId = this.$pluginDescriptor.getPluginId();
                                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
                                StartupManagerImpl.runActivityAndMeasureDuration$default(startupManagerImpl, this.$extension, pluginId, null, 4, null);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$extension = startupActivity;
                                this.$pluginDescriptor = pluginDescriptor;
                            }
                        });
                        return;
                    }
                    if (this.$edtActivity.get() == null) {
                        this.$edtActivity.set(StartUpMeasurer.startActivity((String)"project post-startup edt activities"));
                    }
                    if (!LightEdit.owns((Project)StartupManagerImpl.access$getProject$p(this.this$0))) {
                        this.$counter.incrementAndGet();
                        this.$dumbService.unsafeRunWhenSmart(new Runnable(this, extension2, pluginDescriptor){
                            final /* synthetic */ runPostStartupActivities.1 this$0;
                            final /* synthetic */ StartupActivity $extension;
                            final /* synthetic */ PluginDescriptor $pluginDescriptor;

                            public final void run() {
                                StartupManagerImpl startupManagerImpl = this.this$0.this$0;
                                PluginId pluginId = this.$pluginDescriptor.getPluginId();
                                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
                                long duration = StartupManagerImpl.runActivityAndMeasureDuration$default(startupManagerImpl, this.$extension, pluginId, null, 4, null);
                                if (duration > StartupManagerImplKt.access$getEDT_WARN_THRESHOLD_IN_NANO$p()) {
                                    StartupManagerImplKt.access$reportUiFreeze(this.this$0.$uiFreezeWarned);
                                }
                                StartupManagerImplKt.access$dumbUnawarePostActivitiesPassed(this.this$0.$edtActivity, this.this$0.$counter.decrementAndGet());
                            }
                            {
                                this.this$0 = var1_1;
                                this.$extension = startupActivity;
                                this.$pluginDescriptor = pluginDescriptor;
                            }
                        });
                    }
                }
                {
                    this.this$0 = startupManagerImpl;
                    this.$dumbService = dumbService;
                    this.$edtActivity = atomicReference;
                    this.$counter = atomicInteger;
                    this.$uiFreezeWarned = atomicBoolean;
                }
            });
            StartupManagerImplKt.access$dumbUnawarePostActivitiesPassed(edtActivity, counter.get());
            if (this.project.isDisposed()) {
                return;
            }
            this.runPostStartupActivitiesRegisteredDynamically();
            dumbAwareActivity.end();
            snapshot2.logResponsivenessSinceCreation("Post-startup activities under progress");
            if (!this.project.isDisposed()) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) {
                    this.scheduleBackgroundPostStartupActivities();
                    Companion.addActivityEpListener(this.project);
                }
            }
        }
        catch (Throwable t) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                this.postStartupActivitiesPassed = -1;
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long runActivityAndMeasureDuration(StartupActivity activity, PluginId pluginId, ProgressIndicator indicator2) {
        ProgressIndicator progressIndicator = indicator2;
        if (progressIndicator != null) {
            progressIndicator.pushState();
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        try {
            this.runStartupActivity(activity);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            StartupManagerImplKt.access$getLOG$p().error(e);
        }
        finally {
            ProgressIndicator progressIndicator2 = indicator2;
            if (progressIndicator2 != null) {
                progressIndicator2.popState();
            }
        }
        return StartupManagerImplKt.access$addCompletedActivity(startTime, activity.getClass(), pluginId);
    }

    static /* synthetic */ long runActivityAndMeasureDuration$default(StartupManagerImpl startupManagerImpl, StartupActivity startupActivity, PluginId pluginId, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runActivityAndMeasureDuration");
        }
        if ((n & 4) != 0) {
            progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        }
        return startupManagerImpl.runActivityAndMeasureDuration(startupActivity, pluginId, progressIndicator);
    }

    private final void runStartupActivity(StartupActivity activity) {
        if (!(this.project instanceof LightEditCompatible) || activity instanceof LightEditCompatible) {
            activity.runActivity(this.project);
        }
    }

    private final void runPostStartupActivitiesRegisteredDynamically() {
        StartupManagerImpl.runActivities$default(this, this.postStartupActivities, "project post-startup", null, 4, null);
        this.postStartupActivitiesPassed = 1;
        if (LightEdit.owns((Project)this.project)) {
            this.postStartupActivitiesPassed = 2;
            this.allActivitiesPassed.complete(null);
        } else {
            DumbService.getInstance((Project)this.project).unsafeRunWhenSmart(new Runnable(this){
                final /* synthetic */ StartupManagerImpl this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DumbService dumbService;
                    Object object = StartupManagerImpl.access$getLock$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        if (StartupManagerImpl.access$getPostStartupActivities$p(this.this$0).isEmpty()) {
                            StartupManagerImpl.access$setPostStartupActivitiesPassed$p(this.this$0, 2);
                            StartupManagerImpl.access$getAllActivitiesPassed$p(this.this$0).complete(null);
                            return;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    StartupManagerImpl.runActivities$default(this.this$0, StartupManagerImpl.access$getPostStartupActivities$p(this.this$0), null, null, 6, null);
                    DumbService dumbService2 = dumbService = DumbService.getInstance((Project)StartupManagerImpl.access$getProject$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)dumbService2, (String)"dumbService");
                    if (dumbService2.isDumb()) {
                        dumbService.unsafeRunWhenSmart((Runnable)this);
                    } else {
                        StartupManagerImpl.access$setPostStartupActivitiesPassed$p(this.this$0, 2);
                        StartupManagerImpl.access$getAllActivitiesPassed$p(this.this$0).complete(null);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runActivities(Deque<Runnable> activities2, String activityName, ProgressIndicator indicator2) {
        block17: {
            Activity activity;
            Object it2;
            boolean bl;
            Object object = this.lock;
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (object) {
                boolean bl4 = false;
                if (activities2.isEmpty()) {
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            String string = activityName;
            if (string != null) {
                String string2 = string;
                boolean bl5 = false;
                bl = false;
                it2 = string2;
                boolean bl6 = false;
                activity = StartUpMeasurer.startActivity((String)it2);
            } else {
                activity = null;
            }
            Activity activity2 = activity;
            while (true) {
                PluginClassLoader pluginClassLoader;
                Object runnable2;
                Object object2 = this.lock;
                bl = false;
                boolean it2 = false;
                synchronized (object2) {
                    boolean bl7 = false;
                    it2 = activities2.pollFirst();
                }
                if (it2 == null) {
                    break;
                }
                ProgressIndicator progressIndicator = indicator2;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                long startTime = StartUpMeasurer.getCurrentTime();
                ProgressManager.checkCanceled();
                try {
                    runnable2.run();
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    StartupManagerImplKt.access$getLOG$p().error(e);
                }
                Class<?> runnableClass = runnable2.getClass();
                ClassLoader classLoader = runnableClass.getClassLoader();
                if (!(classLoader instanceof PluginClassLoader)) {
                    classLoader = null;
                }
                if ((pluginClassLoader = (PluginClassLoader)((Object)classLoader)) == null || (pluginClassLoader = pluginClassLoader.getPluginId()) == null) {
                    pluginClassLoader = PluginManagerCore.CORE_ID;
                }
                Intrinsics.checkNotNullExpressionValue((Object)((Object)pluginClassLoader), (String)"(runnableClass.classLoad\u2026PluginManagerCore.CORE_ID");
                StartupManagerImplKt.access$addCompletedActivity(startTime, runnableClass, (PluginId)pluginClassLoader);
            }
            Activity activity3 = activity2;
            if (activity3 == null) break block17;
            activity3.end();
        }
    }

    static /* synthetic */ void runActivities$default(StartupManagerImpl startupManagerImpl, Deque deque, String string, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runActivities");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        startupManagerImpl.runActivities(deque, string, progressIndicator);
    }

    private final void scheduleBackgroundPostStartupActivities() {
        this.scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(this){
            final /* synthetic */ StartupManagerImpl this$0;

            public final void run() {
                List activities2;
                StartupManagerImpl.access$setScheduledFuture$p(this.this$0, null);
                if (StartupManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                long startTimeNano = System.nanoTime();
                List list2 = activities2 = (List)ReadAction.compute((ThrowableComputable)new ThrowableComputable(this){
                    final /* synthetic */ scheduleBackgroundPostStartupActivities.1 this$0;

                    public final List<StartupActivity.Background> compute() {
                        StartupManagerImplKt.access$getBACKGROUND_POST_STARTUP_ACTIVITY$p().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StartupActivity.Background>(this){
                            final /* synthetic */ scheduleBackgroundPostStartupActivities.activities.1 this$0;

                            public void extensionAdded(@NotNull StartupActivity.Background extension2, @NotNull PluginDescriptor pluginDescriptor) {
                                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                                AppExecutorUtil.getAppScheduledExecutorService().execute(new Runnable(this, extension2){
                                    final /* synthetic */ scheduleBackgroundPostStartupActivities.activities.1 this$0;
                                    final /* synthetic */ StartupActivity.Background $extension;

                                    public final void run() {
                                        StartupManagerImpl.access$runBackgroundPostStartupActivities(this.this$0.this$0.this$0.this$0, CollectionsKt.listOf((Object)this.$extension));
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$extension = background;
                                    }
                                });
                            }
                            {
                                this.this$0 = this$0;
                            }
                        }, (Disposable)StartupManagerImpl.access$getProject$p(this.this$0.this$0));
                        return StartupManagerImplKt.access$getBACKGROUND_POST_STARTUP_ACTIVITY$p().getExtensionList();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"activities");
                StartupManagerImpl.access$runBackgroundPostStartupActivities(this.this$0, list2);
                Logger $this$debug$iv = StartupManagerImplKt.access$getLOG$p();
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl = false;
                    String string = "Background post-startup activities done in " + TimeoutUtil.getDurationMillis((long)startTimeNano) + "ms";
                    logger.debug(string, (Throwable)e$iv);
                }
            }
            {
                this.this$0 = startupManagerImpl;
            }
        }, (long)Registry.intValue((String)"ide.background.post.startup.activity.delay"), TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.scheduledFuture = null;
    }

    private final void runBackgroundPostStartupActivities(List<? extends StartupActivity.Background> activities2) {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.project, new Runnable(this, activities2){
            final /* synthetic */ StartupManagerImpl this$0;
            final /* synthetic */ List $activities;

            public final void run() {
                for (StartupActivity.Background activity : this.$activities) {
                    ProgressManager.checkCanceled();
                    if (StartupManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        return;
                    }
                    StartupManagerImpl.access$runStartupActivity(this.this$0, (StartupActivity)activity);
                }
            }
            {
                this.this$0 = startupManagerImpl;
                this.$activities = list2;
            }
        });
    }

    public void runWhenProjectIsInitialized(@NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (DumbService.isDumbAware((Object)action2)) {
            this.runAfterOpened(new Runnable(this, action2){
                final /* synthetic */ StartupManagerImpl this$0;
                final /* synthetic */ Runnable $action;

                public final void run() {
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.NON_MODAL, (Condition)StartupManagerImpl.access$getProject$p(this.this$0).getDisposed(), (Runnable)this.$action);
                }
                {
                    this.this$0 = startupManagerImpl;
                    this.$action = runnable2;
                }
            });
        } else if (!LightEdit.owns((Project)this.project)) {
            this.runAfterOpened(new Runnable(this, action2){
                final /* synthetic */ StartupManagerImpl this$0;
                final /* synthetic */ Runnable $action;

                public final void run() {
                    DumbService.getInstance((Project)StartupManagerImpl.access$getProject$p(this.this$0)).unsafeRunWhenSmart(this.$action);
                }
                {
                    this.this$0 = startupManagerImpl;
                    this.$action = runnable2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterOpened(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.checkNonDefaultProject();
        if (this.postStartupActivitiesPassed < 1) {
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                if (this.postStartupActivitiesPassed < 1) {
                    this.postStartupActivities.add(runnable2);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        runnable2.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final synchronized void prepareForNextTest() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.startupActivities.clear();
            this.postStartupActivities.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final synchronized void checkCleared() {
        try {
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                boolean bl4 = this.startupActivities.isEmpty();
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean $i$a$-assert-StartupManagerImpl$checkCleared$1$32 = false;
                    String $i$a$-assert-StartupManagerImpl$checkCleared$1$32 = "Activities: " + this.startupActivities;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-StartupManagerImpl$checkCleared$1$32));
                }
                bl4 = this.postStartupActivities.isEmpty();
                bl5 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl6 = false;
                    String string = "DumbAware Post Activities: " + this.postStartupActivities;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        finally {
            this.prepareForNextTest();
        }
    }

    public StartupManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lock = new Object();
        this.startupActivities = new ArrayDeque();
        this.postStartupActivities = new ArrayDeque();
        this.allActivitiesPassed = new CompletableFuture();
    }

    public static final /* synthetic */ Project access$getProject$p(StartupManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$executeActivityFromExtensionPoint(StartupManagerImpl $this, PluginDescriptor descriptor2, String extensionPointName, Supplier supplier2, ProgressIndicator indicator2) {
        $this.executeActivityFromExtensionPoint(descriptor2, extensionPointName, supplier2, indicator2);
    }

    public static final /* synthetic */ void access$runPostStartupActivities(StartupManagerImpl $this) {
        $this.runPostStartupActivities();
    }

    public static final /* synthetic */ Object access$getLock$p(StartupManagerImpl $this) {
        return $this.lock;
    }

    public static final /* synthetic */ ArrayDeque access$getPostStartupActivities$p(StartupManagerImpl $this) {
        return $this.postStartupActivities;
    }

    public static final /* synthetic */ int access$getPostStartupActivitiesPassed$p(StartupManagerImpl $this) {
        return $this.postStartupActivitiesPassed;
    }

    public static final /* synthetic */ void access$setPostStartupActivitiesPassed$p(StartupManagerImpl $this, int n) {
        $this.postStartupActivitiesPassed = n;
    }

    public static final /* synthetic */ CompletableFuture access$getAllActivitiesPassed$p(StartupManagerImpl $this) {
        return $this.allActivitiesPassed;
    }

    public static final /* synthetic */ ScheduledFuture access$getScheduledFuture$p(StartupManagerImpl $this) {
        return $this.scheduledFuture;
    }

    public static final /* synthetic */ void access$setScheduledFuture$p(StartupManagerImpl $this, ScheduledFuture scheduledFuture) {
        $this.scheduledFuture = scheduledFuture;
    }

    public static final /* synthetic */ void access$runBackgroundPostStartupActivities(StartupManagerImpl $this, List activities2) {
        $this.runBackgroundPostStartupActivities(activities2);
    }

    public static final /* synthetic */ void access$runStartupActivity(StartupManagerImpl $this, StartupActivity activity) {
        $this.runStartupActivity(activity);
    }

    public static final /* synthetic */ long access$runActivityAndMeasureDuration(StartupManagerImpl $this, StartupActivity activity, PluginId pluginId, ProgressIndicator indicator2) {
        return $this.runActivityAndMeasureDuration(activity, pluginId, indicator2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/impl/StartupManagerImpl$Companion;", "", "()V", "addActivityEpListener", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @VisibleForTesting
        public final void addActivityEpListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartupActivity.POST_STARTUP_ACTIVITY.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StartupActivity>(project){
                final /* synthetic */ Project $project;

                public void extensionAdded(@NotNull StartupActivity activity, @NotNull PluginDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    StartupManager startupManager = StartupManagerEx.getInstance((Project)this.$project);
                    if (startupManager == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.startup.impl.StartupManagerImpl");
                    }
                    StartupManagerImpl startupManager2 = (StartupManagerImpl)startupManager;
                    PluginId pluginId = descriptor2.getPluginId();
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"descriptor.pluginId");
                    PluginId pluginId2 = pluginId;
                    if (DumbService.isDumbAware((Object)activity)) {
                        AppExecutorUtil.getAppExecutorService().execute(new Runnable(this, startupManager2, activity, pluginId2){
                            final /* synthetic */ addActivityEpListener.1 this$0;
                            final /* synthetic */ StartupManagerImpl $startupManager;
                            final /* synthetic */ StartupActivity $activity;
                            final /* synthetic */ PluginId $pluginId;

                            public final void run() {
                                if (!this.this$0.$project.isDisposed()) {
                                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.this$0.$project, new Runnable(this){
                                        final /* synthetic */ addActivityEpListener.extensionAdded.1 this$0;

                                        public final void run() {
                                            StartupManagerImpl startupManagerImpl = this.this$0.$startupManager;
                                            StartupActivity startupActivity = this.this$0.$activity;
                                            PluginId pluginId = this.this$0.$pluginId;
                                            ProgressManager progressManager = ProgressManager.getInstance();
                                            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                                            StartupManagerImpl.access$runActivityAndMeasureDuration(startupManagerImpl, startupActivity, pluginId, progressManager.getProgressIndicator());
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$startupManager = startupManagerImpl;
                                this.$activity = startupActivity;
                                this.$pluginId = pluginId;
                            }
                        });
                    } else {
                        DumbService.getInstance((Project)this.$project).unsafeRunWhenSmart(new Runnable(startupManager2, activity, pluginId2){
                            final /* synthetic */ StartupManagerImpl $startupManager;
                            final /* synthetic */ StartupActivity $activity;
                            final /* synthetic */ PluginId $pluginId;

                            public final void run() {
                                StartupManagerImpl.runActivityAndMeasureDuration$default(this.$startupManager, this.$activity, this.$pluginId, null, 4, null);
                            }
                            {
                                this.$startupManager = startupManagerImpl;
                                this.$activity = startupActivity;
                                this.$pluginId = pluginId;
                            }
                        });
                    }
                }
                {
                    this.$project = $captured_local_variable$0;
                }
            }, (Disposable)project);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

