/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.ToolbarComboWidget;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;

public class ToolbarComboWidgetUI
extends ComponentUI {
    private static final int ELEMENTS_GAP = 5;
    private static final int ICONS_GAP = 5;
    private static final Icon EXPAND_ICON = AllIcons.General.ChevronDown;
    private static final int MIN_TEXT_LENGTH = 5;
    private static final int SEPARATOR_WIDTH = 1;
    private final HoverAreaTracker hoverTracker = new HoverAreaTracker();
    private final ClickListener clickListener = new ClickListener();

    public static ComponentUI createUI(JComponent c) {
        return new ToolbarComboWidgetUI();
    }

    @Override
    public void installUI(JComponent c) {
        ToolbarComboWidget widget = (ToolbarComboWidget)c;
        ToolbarComboWidgetUI.setUIDefaults(widget);
        this.hoverTracker.installTo(widget);
        this.clickListener.installTo(widget);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.hoverTracker.uninstall();
        this.clickListener.uninstall();
        c.removeMouseListener(this.clickListener);
    }

    private static void setUIDefaults(ToolbarComboWidget c) {
        c.setBackground(UIManager.getColor("ToolbarComboWidget.background"));
        c.setHoverBackground(UIManager.getColor("ToolbarComboWidget.hoverBackground"));
        Insets insets = UIManager.getInsets("ToolbarComboWidget.borderInsets");
        JBEmptyBorder border = JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
        c.setBorder((Border)border);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        ToolbarComboWidget combo = (ToolbarComboWidget)c;
        this.paintBackground(g, combo);
        List<Icon> leftIcons = combo.getLeftIcons();
        List<Icon> rightIcons = combo.getRightIcons();
        Rectangle paintRect = SwingUtilities.calculateInnerArea(c, null);
        Graphics2D g2 = (Graphics2D)g.create(paintRect.x, paintRect.y, paintRect.width, paintRect.height);
        try {
            String text2;
            if (!leftIcons.isEmpty()) {
                Rectangle iconsRect = ToolbarComboWidgetUI.paintIcons(leftIcons, combo, g2);
                ToolbarComboWidgetUI.doClip(g2, iconsRect.width + 5);
            }
            if (!StringUtil.isEmpty((String)(text2 = combo.getText()))) {
                int maxTextWidth = ToolbarComboWidgetUI.calcMaxTextWidth(combo, paintRect);
                g2.setColor(c.getForeground());
                Rectangle textRect = ToolbarComboWidgetUI.drawText(text2, maxTextWidth, g2);
                ToolbarComboWidgetUI.doClip(g2, textRect.width + 5);
            }
            if (!rightIcons.isEmpty()) {
                Rectangle iconsRect = ToolbarComboWidgetUI.paintIcons(rightIcons, combo, g2);
                ToolbarComboWidgetUI.doClip(g2, iconsRect.width + 5);
            }
            if (ToolbarComboWidgetUI.isSeparatorShown(combo)) {
                g2.setColor(UIManager.getColor("Separator.separatorColor"));
                Rectangle bounds2 = g2.getClipBounds();
                g2.fillRect(bounds2.x, bounds2.y, 1, bounds2.height);
                ToolbarComboWidgetUI.doClip(g2, 6);
            }
            ToolbarComboWidgetUI.paintIcons(Collections.singletonList(EXPAND_ICON), combo, g2);
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBackground(Graphics g, ToolbarComboWidget c) {
        Graphics g2 = g.create();
        try {
            g2.setColor(c.getBackground());
            Rectangle bounds2 = g2.getClipBounds();
            g2.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            Rectangle hoverRect = this.hoverTracker.getHoverRect();
            if (hoverRect != null) {
                g2.setColor(c.getHoverBackground());
                g2.fillRect(hoverRect.x, hoverRect.y, hoverRect.width, hoverRect.height);
            }
        }
        finally {
            g2.dispose();
        }
    }

    private static Rectangle drawText(@NotNull String fullText, int maxWidth, Graphics2D g) {
        if (fullText == null) {
            ToolbarComboWidgetUI.$$$reportNull$$$0(0);
        }
        FontMetrics metrics = g.getFontMetrics();
        Rectangle clipBounds = g.getClipBounds();
        clipBounds.width = maxWidth;
        String text2 = ToolbarComboWidgetUI.calcShownText(fullText, metrics, maxWidth);
        Rectangle strBounds = metrics.getStringBounds(text2, g).getBounds();
        strBounds.setLocation((int)(clipBounds.getCenterX() - strBounds.getCenterX()), (int)(clipBounds.getCenterY() - strBounds.getCenterY()));
        g.drawString(text2, strBounds.x, strBounds.y);
        return clipBounds;
    }

    private static String calcShownText(String text2, FontMetrics metrics, int maxWidth) {
        int width = metrics.stringWidth(text2);
        while (width > maxWidth && text2.length() > 5) {
            text2 = text2.substring(0, text2.length() - 1);
            width = metrics.stringWidth(text2 + "...");
        }
        return text2;
    }

    private static int calcMaxTextWidth(ToolbarComboWidget c, Rectangle paintRect) {
        int right;
        int left = ToolbarComboWidgetUI.calcIconsWidth(c.getLeftIcons());
        if (left > 0) {
            left += 5;
        }
        if ((right = ToolbarComboWidgetUI.calcIconsWidth(c.getRightIcons())) > 0) {
            right += 5;
        }
        int separator2 = ToolbarComboWidgetUI.isSeparatorShown(c) ? 6 : 0;
        int otherElementsWidth = left + right + separator2 + 5 + EXPAND_ICON.getIconWidth();
        return paintRect.width - otherElementsWidth;
    }

    private static int calcIconsWidth(List<Icon> icons) {
        int res2 = 0;
        for (Icon icon2 : icons) {
            if (res2 > 0) {
                res2 += 5;
            }
            res2 += icon2.getIconWidth();
        }
        return res2;
    }

    private static void doClip(Graphics2D g, int shift) {
        Rectangle bounds2 = g.getClipBounds();
        g.clipRect(bounds2.x + shift, bounds2.y, bounds2.width - shift, bounds2.height);
    }

    private static Rectangle paintIcons(List<Icon> icons, JComponent c, Graphics g) {
        if (icons.isEmpty()) {
            return new Rectangle();
        }
        Rectangle bounds2 = g.getClipBounds();
        int maxHeight = 0;
        int shift = 0;
        for (Icon icon2 : icons) {
            if (shift != 0) {
                shift += 5;
            }
            int x = bounds2.x + shift;
            int y = bounds2.y + bounds2.height / 2 - icon2.getIconHeight() / 2;
            icon2.paintIcon(c, g, x, y);
            shift += icon2.getIconWidth();
            maxHeight = Math.max(maxHeight, icon2.getIconHeight());
        }
        return new Rectangle(shift, maxHeight);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        ToolbarComboWidget combo = (ToolbarComboWidget)c;
        Dimension res2 = new Dimension();
        List<Icon> icons = combo.getLeftIcons();
        if (!icons.isEmpty()) {
            res2.width += ToolbarComboWidgetUI.calcIconsWidth(icons);
            res2.height = icons.stream().mapToInt(Icon::getIconHeight).max().orElse(0);
        }
        if (!StringUtil.isEmpty((String)combo.getText())) {
            if (res2.width > 0) {
                res2.width += 5;
            }
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            res2.width += metrics.stringWidth(combo.getText());
            res2.height = Math.max(res2.height, metrics.getHeight());
        }
        if (!(icons = combo.getRightIcons()).isEmpty()) {
            if (res2.width > 0) {
                res2.width += 5;
            }
            res2.width += ToolbarComboWidgetUI.calcIconsWidth(icons);
            res2.height = Math.max(res2.height, icons.stream().mapToInt(Icon::getIconHeight).max().orElse(0));
        }
        if (ToolbarComboWidgetUI.isSeparatorShown(combo)) {
            if (res2.width > 0) {
                res2.width += 5;
            }
            ++res2.width;
        }
        if (res2.width > 0) {
            res2.width += 5;
        }
        res2.width += EXPAND_ICON.getIconWidth();
        res2.height = Math.max(res2.height, EXPAND_ICON.getIconHeight());
        Insets insets = c.getInsets();
        res2.height += insets.top + insets.bottom;
        res2.width += insets.left + insets.right;
        return res2;
    }

    private static boolean isSeparatorShown(ToolbarComboWidget widget) {
        return !widget.getExpandListeners().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullText", "com/intellij/ide/ui/laf/darcula/ui/ToolbarComboWidgetUI", "drawText"));
    }

    private static class ClickListener
    extends MyMouseTracker {
        private ClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!ToolbarComboWidgetUI.isSeparatorShown(this.comp)) {
                this.notifyPressListeners(e);
                return;
            }
            int leftPartWidth = this.comp.getWidth() - (5 + EXPAND_ICON.getIconWidth() + this.comp.getInsets().right);
            if (e.getPoint().x <= leftPartWidth) {
                this.notifyPressListeners(e);
            } else {
                this.notifyExpandListeners(e);
            }
        }

        private void notifyExpandListeners(MouseEvent e) {
            ActionEvent ae = new ActionEvent(this.comp, 0, null, System.currentTimeMillis(), e.getModifiersEx());
            this.comp.getExpandListeners().forEach(listener2 -> listener2.actionPerformed(ae));
        }

        private void notifyPressListeners(MouseEvent e) {
            ActionEvent ae = new ActionEvent(this.comp, 0, null, System.currentTimeMillis(), e.getModifiersEx());
            this.comp.getPressListeners().forEach(listener2 -> listener2.actionPerformed(ae));
        }
    }

    private static class HoverAreaTracker
    extends MyMouseTracker {
        private Rectangle hoverRect;

        private HoverAreaTracker() {
        }

        private Rectangle getHoverRect() {
            return this.hoverRect;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.calcHoverRect(e.getPoint());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.updateHoverRect(null);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.calcHoverRect(e.getPoint());
        }

        private void calcHoverRect(Point mousePosition) {
            Rectangle compBounds = this.comp.getVisibleRect();
            if (!ToolbarComboWidgetUI.isSeparatorShown(this.comp)) {
                this.updateHoverRect(compBounds);
                return;
            }
            int rightPart = 6 + EXPAND_ICON.getIconWidth() + this.comp.getInsets().right;
            Rectangle right = new Rectangle((int)(compBounds.getMaxX() - (double)rightPart), compBounds.y, rightPart, compBounds.height);
            Rectangle left = new Rectangle(compBounds.x, compBounds.y, compBounds.width - rightPart + 1, compBounds.height);
            this.updateHoverRect(left.contains(mousePosition) ? left : right);
        }

        private void updateHoverRect(Rectangle newRect) {
            if (Objects.equals(this.hoverRect, newRect)) {
                return;
            }
            this.hoverRect = newRect;
            this.comp.repaint();
        }
    }

    private static abstract class MyMouseTracker
    extends MouseAdapter {
        protected ToolbarComboWidget comp;

        private MyMouseTracker() {
        }

        public void installTo(ToolbarComboWidget c) {
            this.comp = c;
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
        }

        public void uninstall() {
            this.comp.removeMouseListener(this);
            this.comp.removeMouseMotionListener(this);
            this.comp = null;
        }
    }
}

