/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TextWithIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformModuleRendererFactory
extends ModuleRendererFactory {
    @Override
    @NotNull
    public DefaultListCellRenderer getModuleRenderer() {
        return new PlatformModuleRenderer();
    }

    @Override
    public boolean rendersLocationString() {
        return true;
    }

    @Override
    @Nullable
    public TextWithIcon getModuleTextWithIcon(Object element2) {
        String text2 = PlatformModuleRendererFactory.getItemText(element2);
        return text2 == null ? null : new TextWithIcon(text2, null);
    }

    @NlsSafe
    @Nullable
    private static String getItemText(Object value2) {
        if (!(value2 instanceof NavigationItem)) {
            return null;
        }
        ItemPresentation presentation2 = ((NavigationItem)value2).getPresentation();
        if (presentation2 == null) {
            return null;
        }
        String containerText = presentation2.getLocationString();
        if (StringUtil.isEmpty((String)containerText)) {
            return null;
        }
        return " " + containerText;
    }

    public static class PlatformModuleRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
            Component component2 = super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
            this.setText(StringUtil.notNullize((String)PlatformModuleRendererFactory.getItemText(value2)));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.setHorizontalTextPosition(2);
            this.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground());
            this.setForeground(isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor());
            return component2;
        }
    }
}

