/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PropertiesComponentImpl.class);
    private final Map<@NonNls String, @NonNls String> myMap = new ConcurrentHashMap<String, String>();
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    PropertiesComponentImpl() {
    }

    private void doPut(@NotNull String key, @NotNull String value2) {
        String reason;
        if (key == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(1);
        }
        if ((reason = Verifier.checkCharacterData((String)key)) != null) {
            LOG.error(reason);
        }
        this.myMap.put(key, value2);
        this.incModificationCount();
    }

    public Element getState() {
        Element parentNode = new Element("state");
        ArrayList<String> keys2 = new ArrayList<String>(this.myMap.keySet());
        keys2.sort(null);
        for (String key : keys2) {
            String value2 = this.myMap.get(key);
            if (value2 == null) continue;
            Element element2 = new Element(ELEMENT_PROPERTY);
            element2.setAttribute(ATTRIBUTE_NAME, key);
            element2.setAttribute(ATTRIBUTE_VALUE, value2);
            parentNode.addContent(element2);
        }
        return parentNode;
    }

    public void loadState(@NotNull Element parentNode) {
        if (parentNode == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(2);
        }
        this.myMap.clear();
        for (Element e : parentNode.getChildren(ELEMENT_PROPERTY)) {
            String name2 = e.getAttributeValue(ATTRIBUTE_NAME);
            if (name2 == null) continue;
            this.myMap.put(name2, e.getAttributeValue(ATTRIBUTE_VALUE));
        }
    }

    public String getValue(@NotNull String name2) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(3);
        }
        return this.myMap.get(name2);
    }

    public void setValue(@NotNull String name2, @Nullable String value2) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(4);
        }
        if (value2 == null) {
            this.unsetValue(name2);
        } else {
            this.doPut(name2, value2);
        }
    }

    public void setValue(@NotNull String name2, @Nullable String value2, @Nullable String defaultValue) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(5);
        }
        if (value2 == null || value2.equals(defaultValue)) {
            this.unsetValue(name2);
        } else {
            this.doPut(name2, value2);
        }
    }

    public void setValue(@NotNull String name2, float value2, float defaultValue) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(6);
        }
        if (value2 == defaultValue) {
            this.unsetValue(name2);
        } else {
            this.doPut(name2, String.valueOf(value2));
        }
    }

    public void setValue(@NotNull String name2, int value2, int defaultValue) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(7);
        }
        if (value2 == defaultValue) {
            this.unsetValue(name2);
        } else {
            this.doPut(name2, String.valueOf(value2));
        }
    }

    public void setValue(@NotNull String name2, boolean value2, boolean defaultValue) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(8);
        }
        if (value2 == defaultValue) {
            this.unsetValue(name2);
        } else {
            this.setValue(name2, String.valueOf(value2));
        }
    }

    public void unsetValue(@NotNull String name2) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(9);
        }
        this.myMap.remove(name2);
        this.incModificationCount();
    }

    public boolean isValueSet(@NotNull String name2) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(10);
        }
        return this.myMap.containsKey(name2);
    }

    public String @Nullable [] getValues(@NotNull @NonNls String name2) {
        String value2;
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(11);
        }
        return (value2 = this.getValue(name2)) != null ? value2.split("\n") : null;
    }

    public void setValues(@NotNull @NonNls String name2, String[] values2) {
        if (name2 == null) {
            PropertiesComponentImpl.$$$reportNull$$$0(12);
        }
        if (values2 == null) {
            this.setValue(name2, null);
        } else {
            this.setValue(name2, StringUtil.join((String[])values2, (String)"\n"));
        }
    }

    public Set<String> getKeys() {
        return this.myMap.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_VALUE;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/PropertiesComponentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doPut";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "unsetValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isValueSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

