/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.RecommendationDescription;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipAndTrickPromotionFactory;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.ide.util.TipsOrderUtil;
import com.intellij.ide.util.TipsUsageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TipPanel
extends JPanel
implements DoNotAskOption {
    private static final JBColor DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private static final Logger LOG = Logger.getInstance(TipPanel.class);
    @Nullable
    private final Project myProject;
    private final TipUIUtil.Browser myBrowser;
    private final JLabel myPoweredByLabel;
    final AbstractAction myPreviousTipAction;
    final AbstractAction myNextTipAction;
    @NotNull
    private String myAlgorithm = "unknown";
    @Nullable
    private String myAlgorithmVersion = null;
    private List<TipAndTrickBean> myTips = Collections.emptyList();
    private TipAndTrickBean myCurrentTip = null;
    private JPanel myCurrentPromotion = null;

    public TipPanel(@Nullable Project project) {
        this.setLayout(new BorderLayout());
        if (SystemInfo.isWin10OrNewer && !StartupUiUtil.isUnderDarcula()) {
            this.setBorder(JBUI.Borders.customLine((Color)Gray.xD0, (int)1, (int)0, (int)0, (int)0));
        }
        this.myProject = project;
        this.myBrowser = TipUIUtil.createBrowser();
        this.myBrowser.getComponent().setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myBrowser.getComponent(), (boolean)true);
        scrollPane.setBorder(JBUI.Borders.customLine((Color)DIVIDER_COLOR, (int)0, (int)0, (int)1, (int)0));
        this.add((Component)scrollPane, "Center");
        this.myPoweredByLabel = new JBLabel();
        this.myPoweredByLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myPoweredByLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        this.add((Component)this.myPoweredByLabel, "South");
        this.myPreviousTipAction = new PreviousTipAction();
        this.myNextTipAction = new NextTipAction();
        this.setTips(TipAndTrickBean.EP_NAME.getExtensionList());
    }

    void setTips(@NotNull List<TipAndTrickBean> list2) {
        if (list2 == null) {
            TipPanel.$$$reportNull$$$0(0);
        }
        RecommendationDescription recommendation = ((TipsOrderUtil)ApplicationManager.getApplication().getService(TipsOrderUtil.class)).sort(list2);
        this.myTips = new ArrayList<TipAndTrickBean>(recommendation.getTips());
        this.myAlgorithm = recommendation.getAlgorithm();
        this.myAlgorithmVersion = recommendation.getVersion();
        if (!TipPanel.isExperiment(this.myAlgorithm)) {
            this.myTips = TipsUsageManager.getInstance().filterShownTips(this.myTips);
        }
        this.showNext(true);
    }

    private static boolean isExperiment(String algorithm) {
        return algorithm.endsWith("_SUMMER2020");
    }

    @Override
    public Dimension getPreferredSize() {
        return new JBDimension(400, 200);
    }

    private void showNext(boolean forward) {
        int index2;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        int n = index2 = this.myCurrentTip != null ? this.myTips.indexOf(this.myCurrentTip) : -1;
        if (forward) {
            if (index2 < this.myTips.size() - 1) {
                this.setTip(this.myTips.get(index2 + 1));
            }
        } else if (index2 > 0) {
            this.setTip(this.myTips.get(index2 - 1));
        }
    }

    private void setTip(@NotNull TipAndTrickBean tip) {
        if (tip == null) {
            TipPanel.$$$reportNull$$$0(1);
        }
        this.myCurrentTip = tip;
        TipUIUtil.openTipInBrowser(this.myCurrentTip, this.myBrowser);
        this.myPoweredByLabel.setText(TipUIUtil.getPoweredByText(this.myCurrentTip));
        this.myPoweredByLabel.setVisible(!StringUtil.isEmpty((String)this.myPoweredByLabel.getText()));
        this.setPromotionForCurrentTip();
        TipsOfTheDayUsagesCollector.triggerTipShown(tip, this.myAlgorithm, this.myAlgorithmVersion);
        TipsUsageManager.getInstance().fireTipShown(this.myCurrentTip);
        this.myPreviousTipAction.setEnabled(this.myTips.indexOf(this.myCurrentTip) > 0);
        this.myNextTipAction.setEnabled(this.myTips.indexOf(this.myCurrentTip) < this.myTips.size() - 1);
    }

    private void setPromotionForCurrentTip() {
        List promotions;
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        if (this.myCurrentPromotion != null) {
            this.remove(this.myCurrentPromotion);
            this.myCurrentPromotion = null;
            this.myBrowser.getComponent().setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        }
        if (!(promotions = ContainerUtil.mapNotNull((Collection)TipAndTrickPromotionFactory.getEP_NAME().getExtensionList(), factory2 -> factory2.createPromotionPanel(this.myProject, this.myCurrentTip))).isEmpty()) {
            if (promotions.size() > 1) {
                LOG.warn("Found more than one promotion for tip " + this.myCurrentTip);
            }
            this.myCurrentPromotion = (JPanel)promotions.get(0);
            this.add((Component)this.myCurrentPromotion, "North");
            this.myBrowser.getComponent().setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)12));
            this.removeTopMarginFromTipContent();
        }
        this.revalidate();
        this.repaint();
    }

    private void removeTopMarginFromTipContent() {
        @Nls String tipText = this.myBrowser.getText();
        Matcher firstTagMatcher = Pattern.compile("<body>\\s*<\\w+", 2).matcher(tipText);
        if (firstTagMatcher.find()) {
            int endOffset = firstTagMatcher.end();
            @Nls String editedTipText = new StringBuilder(tipText).insert(endOffset, " style=\"margin-top: 0px\"").toString();
            this.myBrowser.setText(editedTipText);
        }
    }

    public boolean canBeHidden() {
        return true;
    }

    public boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    public boolean isToBeShown() {
        return GeneralSettings.getInstance().isShowTipsOnStartup();
    }

    public void setToBeShown(boolean toBeShown, int exitCode) {
        GeneralSettings.getInstance().setShowTipsOnStartup(toBeShown);
    }

    @NotNull
    public String getDoNotShowMessage() {
        String string = IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]);
        if (string == null) {
            TipPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTips";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTip";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NextTipAction
    extends AbstractAction {
        NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
            this.putValue("FocusedAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.NEXT_TIP.log();
            TipPanel.this.showNext(true);
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.PREVIOUS_TIP.log();
            TipPanel.this.showNext(false);
        }
    }
}

