/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.scopeChooser.ScopeConfigurable;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String SCOPE_CHOOSER_CONFIGURABLE_UI_KEY = "ScopeChooserConfigurable.UI";
    public static final String PROJECT_SCOPES = "project.scopes";
    private final NamedScopesHolder myLocalScopesManager;
    private final NamedScopesHolder mySharedScopesManager;
    private final Project myProject;

    public ScopeChooserConfigurable(Project project) {
        super((MasterDetailsState)new ScopeChooserConfigurableState());
        this.myLocalScopesManager = NamedScopeManager.getInstance((Project)project);
        this.mySharedScopesManager = DependencyValidationManager.getInstance((Project)project);
        this.myProject = project;
        this.initTree();
    }

    protected String getComponentStateKey() {
        return SCOPE_CHOOSER_CONFIGURABLE_UI_KEY;
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new MyAddAction(fromPopup));
        result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, ScopeChooserConfigurable.forAll(o -> {
            if (o instanceof MasterDetailsComponent.MyNode) {
                NamedConfigurable namedConfigurable = ((MasterDetailsComponent.MyNode)o).getConfigurable();
                Object editableObject = namedConfigurable != null ? namedConfigurable.getEditableObject() : null;
                return editableObject instanceof NamedScope;
            }
            return false;
        })));
        result2.add((AnAction)new MyCopyAction());
        result2.add((AnAction)new MySaveAsAction());
        result2.add((AnAction)new MyMoveAction(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), IconUtil.getMoveUpIcon(), -1));
        result2.add((AnAction)new MyMoveAction(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), IconUtil.getMoveDownIcon(), 1));
        return result2;
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        this.loadScopes(this.mySharedScopesManager);
        this.loadScopes(this.myLocalScopesManager);
        this.loadComponentState();
        List<String> order = this.getScopesState().myOrder;
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (o1, o2) -> {
            int idx1 = order.indexOf(o1.getDisplayName());
            int idx2 = order.indexOf(o2.getDisplayName());
            return idx1 - idx2;
        });
        if (this.getScopesState().myOrder.size() != this.myRoot.getChildCount()) {
            this.loadStateOrder();
        }
        super.reset();
    }

    public void apply() throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(ProjectBundle.message((String)"rename.message.prefix.scope", (Object[])new Object[0]), ProjectBundle.message((String)"rename.scope.title", (Object[])new Object[0]), ScopeConfigurable.class);
        this.checkForPredefinedNames();
        super.apply();
        this.processScopes();
        this.loadStateOrder();
        this.refreshProject();
    }

    private void refreshProject() {
        if (this.myProject.isDefault()) {
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        for (VirtualFile openVirtualFile : fileEditorManager.getOpenFiles()) {
            fileEditorManager.updateFilePresentation(openVirtualFile);
        }
        ProjectView.getInstance(this.myProject).refresh();
    }

    private void checkForPredefinedNames() throws ConfigurationException {
        HashSet<String> predefinedScopes = new HashSet<String>();
        for (NamedScope scope2 : CustomScopesAggregator.getAllCustomScopes(this.myProject)) {
            predefinedScopes.add(scope2.getScopeId());
        }
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            NamedConfigurable scopeConfigurable = node2.getConfigurable();
            String name2 = scopeConfigurable.getDisplayName();
            if (!predefinedScopes.contains(name2)) continue;
            this.selectNodeInTree((DefaultMutableTreeNode)node2);
            throw new ConfigurationException(LangBundle.message((String)"dialog.message.scope.name.equals.to.predefined.one", (Object[])new Object[0]), ProjectBundle.message((String)"rename.scope.title", (Object[])new Object[0]));
        }
    }

    public ScopeChooserConfigurableState getScopesState() {
        return (ScopeChooserConfigurableState)this.myState;
    }

    public boolean isModified() {
        List<String> order = this.getScopesState().myOrder;
        if (this.myRoot.getChildCount() != order.size()) {
            return true;
        }
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            ScopeConfigurable scopeConfigurable = (ScopeConfigurable)node2.getConfigurable();
            NamedScope namedScope = scopeConfigurable.getEditableObject();
            if (order.size() <= i2) {
                return true;
            }
            String name2 = order.get(i2);
            if (!Comparing.strEqual((String)name2, (String)namedScope.getScopeId())) {
                return true;
            }
            if (!this.isInitialized(scopeConfigurable)) continue;
            NamedScopesHolder holder = scopeConfigurable.getHolder();
            NamedScope scope2 = holder.getScope(name2);
            if (scope2 == null) {
                return true;
            }
            if (!scopeConfigurable.isModified()) continue;
            return true;
        }
        return false;
    }

    private void processScopes() {
        ArrayList<NamedScope> localScopes = new ArrayList<NamedScope>();
        ArrayList<NamedScope> sharedScopes = new ArrayList<NamedScope>();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            ScopeConfigurable scopeConfigurable = (ScopeConfigurable)node2.getConfigurable();
            NamedScope namedScope = scopeConfigurable.getScope();
            if (scopeConfigurable.getHolder() == this.myLocalScopesManager) {
                localScopes.add(namedScope);
                continue;
            }
            sharedScopes.add(namedScope);
        }
        this.myLocalScopesManager.setScopes(localScopes.toArray(NamedScope.EMPTY_ARRAY));
        this.mySharedScopesManager.setScopes(sharedScopes.toArray(NamedScope.EMPTY_ARRAY));
    }

    private void loadStateOrder() {
        List<String> order = this.getScopesState().myOrder;
        order.clear();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            order.add(((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2)).getDisplayName());
        }
    }

    private void loadScopes(NamedScopesHolder holder) {
        NamedScope[] scopes;
        for (NamedScope scope2 : scopes = holder.getScopes()) {
            if (this.isPredefinedScope(scope2)) continue;
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new ScopeConfigurable(scope2, holder == this.mySharedScopesManager, this.myProject, this.TREE_UPDATER)));
        }
    }

    private boolean isPredefinedScope(NamedScope scope2) {
        return ScopeChooserConfigurable.getPredefinedScopes(this.myProject).contains(scope2);
    }

    private static Collection<NamedScope> getPredefinedScopes(Project project) {
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.addAll(NamedScopeManager.getInstance((Project)project).getPredefinedScopes());
        result2.addAll(DependencyValidationManager.getInstance((Project)project).getPredefinedScopes());
        return result2;
    }

    protected void initTree() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MasterDetailsComponent.MyNode node2;
                NamedConfigurable namedConfigurable;
                TreePath path2 = e.getOldLeadSelectionPath();
                if (path2 != null && (namedConfigurable = (node2 = (MasterDetailsComponent.MyNode)path2.getLastPathComponent()).getConfigurable()) instanceof ScopeConfigurable) {
                    ((ScopeConfigurable)namedConfigurable).cancelCurrentProgress();
                }
            }
        });
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName()), true);
        this.myTree.getEmptyText().setText(IdeBundle.message((String)"scopes.no.scoped", (Object[])new Object[0]));
    }

    protected boolean wasObjectStored(Object editableObject) {
        if (editableObject instanceof NamedScope) {
            NamedScope scope2 = (NamedScope)editableObject;
            String scopeId = scope2.getScopeId();
            return this.myLocalScopesManager.getScope(scopeId) != null || this.mySharedScopesManager.getScope(scopeId) != null;
        }
        return false;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"scopes.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        return PROJECT_SCOPES;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable2) {
        super.updateSelection(configurable2);
        if (configurable2 instanceof ScopeConfigurable) {
            ((ScopeConfigurable)configurable2).restoreCanceledProgress();
        }
    }

    @Nullable
    protected String getEmptySelectionString() {
        return IdeBundle.message((String)"scope.chooser.select.scope.text", (Object[])new Object[0]);
    }

    private String createUniqueName() {
        String str = InspectionsBundle.message((String)"inspection.profile.unnamed", (Object[])new Object[0]);
        HashSet treeScopes = new HashSet();
        this.obtainCurrentScopes(treeScopes);
        if (!treeScopes.contains(str)) {
            return str;
        }
        int i2 = 1;
        while (treeScopes.contains(str + i2)) {
            ++i2;
        }
        return str + i2;
    }

    private void obtainCurrentScopes(@NotNull Set<? super String> scopes) {
        if (scopes == null) {
            ScopeChooserConfigurable.$$$reportNull$$$0(0);
        }
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            NamedScope scope2 = (NamedScope)node2.getConfigurable().getEditableObject();
            scopes.add(scope2.getScopeId());
        }
    }

    private void addNewScope(NamedScope scope2, boolean isLocal) {
        MasterDetailsComponent.MyNode nodeToAdd = new MasterDetailsComponent.MyNode((NamedConfigurable)new ScopeConfigurable(scope2, !isLocal, this.myProject, this.TREE_UPDATER));
        this.myRoot.add((MutableTreeNode)nodeToAdd);
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)nodeToAdd);
    }

    private void createScope(boolean isLocal, @NlsContexts.DialogTitle String title2, PackageSet set2) {
        final NamedScopesHolder holder = isLocal ? this.myLocalScopesManager : this.mySharedScopesManager;
        String newName2 = Messages.showInputDialog((Component)this.myTree, (String)IdeBundle.message((String)"add.scope.name.label", (Object[])new Object[0]), (String)title2, (Icon)Messages.getInformationIcon(), (String)this.createUniqueName(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                for (NamedScope scope2 : holder.getPredefinedScopes()) {
                    if (!Comparing.strEqual((String)scope2.getScopeId(), (String)inputString.trim())) continue;
                    return false;
                }
                return inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newName2 != null) {
            this.addNewScope(holder.createScope(newName2, set2), isLocal);
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            ScopeChooserConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainCurrentScopes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ScopeChooserConfigurableState
    extends MasterDetailsState {
        @XCollection(propertyElementName="order", elementName="scope", valueAttributeName="name")
        public List<String> myOrder = new ArrayList<String>();
    }

    private class MySaveAsAction
    extends DumbAwareAction {
        MySaveAsAction() {
            super(ExecutionBundle.messagePointer((String)"action.name.save.as.configuration", (Object[])new Object[0]), AllIcons.Actions.MenuSaveall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ScopeConfigurable scopeConfigurable;
            PackageSet set2;
            MasterDetailsComponent.MyNode node2;
            NamedConfigurable configurable2;
            TreePath selectionPath;
            if (e == null) {
                MySaveAsAction.$$$reportNull$$$0(0);
            }
            if ((selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath()) != null && (configurable2 = (node2 = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof ScopeConfigurable && (set2 = (scopeConfigurable = (ScopeConfigurable)configurable2).getEditableObject().getValue()) != null) {
                if (scopeConfigurable.getHolder() == ScopeChooserConfigurable.this.mySharedScopesManager) {
                    ScopeChooserConfigurable.this.createScope(true, IdeBundle.message((String)"scopes.save.dialog.title.local", (Object[])new Object[0]), set2.createCopy());
                } else {
                    ScopeChooserConfigurable.this.createScope(false, IdeBundle.message((String)"scopes.save.dialog.title.shared", (Object[])new Object[0]), set2.createCopy());
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySaveAsAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ScopeChooserConfigurable.this.getSelectedObject() instanceof NamedScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MySaveAsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCopyAction
    extends DumbAwareAction {
        MyCopyAction() {
            super(ExecutionBundle.messagePointer((String)"copy.configuration.action.name", (Object[])new Object[0]), COPY_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)ScopeChooserConfigurable.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            NamedScope scope2;
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(0);
            }
            if ((scope2 = (NamedScope)ScopeChooserConfigurable.this.getSelectedObject()) != null) {
                ScopeConfigurable configurable2 = (ScopeConfigurable)((MasterDetailsComponent.MyNode)ScopeChooserConfigurable.this.myTree.getSelectionPath().getLastPathComponent()).getConfigurable();
                NamedScopesHolder holder = configurable2.getHolder();
                PackageSet set2 = scope2.getValue();
                ScopeChooserConfigurable.this.addNewScope(holder.createScope(ScopeChooserConfigurable.this.createUniqueName(), set2 == null ? null : set2.createCopy()), holder == ScopeChooserConfigurable.this.myLocalScopesManager);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ScopeChooserConfigurable.this.getSelectedObject() instanceof NamedScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyCopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMoveAction
    extends DumbAwareAction {
        private final int myDirection;

        protected MyMoveAction(String text2, Icon icon2, int direction) {
            super(() -> text2, icon2);
            ShortcutSet shortcutSet = direction < 0 ? CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.UP) : CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.DOWN);
            this.registerCustomShortcutSet(shortcutSet, (JComponent)ScopeChooserConfigurable.this.myTree);
            this.myDirection = direction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyMoveAction.$$$reportNull$$$0(0);
            }
            TreeUtil.moveSelectedRow((JTree)ScopeChooserConfigurable.this.myTree, (int)this.myDirection);
        }

        public void update(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode treeNode2;
            if (e == null) {
                MyMoveAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(false);
            TreePath selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null && (treeNode2 = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof ScopeConfigurable) {
                if (this.myDirection < 0) {
                    presentation2.setEnabled(treeNode2.getPreviousSibling() != null);
                } else {
                    presentation2.setEnabled(treeNode2.getNextSibling() != null);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyMoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAddAction
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection,
    DumbAware {
        private AnAction[] myChildren;
        private final boolean myFromPopup;

        MyAddAction(boolean fromPopup) {
            super(IdeBundle.message((String)"add.scope.popup.title", (Object[])new Object[0]), true);
            this.myFromPopup = fromPopup;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setIcon(LayeredIcon.ADD_WITH_DROPDOWN);
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD), (JComponent)ScopeChooserConfigurable.this.myTree);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAddAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (this.myFromPopup) {
                this.setPopup(false);
            }
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myChildren == null) {
                this.myChildren = new AnAction[2];
                this.myChildren[0] = new DumbAwareAction(IdeBundle.message((String)"add.local.scope.action.text", (Object[])new Object[0]), IdeBundle.message((String)"add.local.scope.action.text", (Object[])new Object[0]), ScopeChooserConfigurable.this.myLocalScopesManager.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ScopeChooserConfigurable.this.createScope(true, IdeBundle.message((String)"add.scope.dialog.title", (Object[])new Object[0]), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction$1", "actionPerformed"));
                    }
                };
                this.myChildren[1] = new DumbAwareAction(IdeBundle.message((String)"add.shared.scope.action.text", (Object[])new Object[0]), IdeBundle.message((String)"add.shared.scope.action.text", (Object[])new Object[0]), ScopeChooserConfigurable.this.mySharedScopesManager.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        ScopeChooserConfigurable.this.createScope(false, IdeBundle.message((String)"add.scope.dialog.title", (Object[])new Object[0]), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction$2", "actionPerformed"));
                    }
                };
            }
            if (this.myFromPopup) {
                AnAction action2 = this.myChildren[this.getDefaultIndex()];
                action2.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
                AnAction[] anActionArray = new AnAction[]{action2};
                if (anActionArray == null) {
                    MyAddAction.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }
            if (this.myChildren == null) {
                MyAddAction.$$$reportNull$$$0(2);
            }
            return this.myChildren;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        public int getDefaultIndex() {
            TreePath selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
                Object editableObject = node2.getConfigurable().getEditableObject();
                if (editableObject instanceof NamedScope) {
                    editableObject = ((MasterDetailsComponent.MyNode)node2.getParent()).getConfigurable().getEditableObject();
                }
                if (editableObject instanceof NamedScopeManager) {
                    return 0;
                }
                if (editableObject instanceof DependencyValidationManager) {
                    return 1;
                }
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

