/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepCancelledException;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBCardLayout;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class AbstractWizardEx
extends AbstractWizard<AbstractWizardStepEx> {
    @NlsContexts.DialogTitle
    private final String myTitle;
    private final Object2IntMap<Object> myStepId2Index = new Object2IntOpenHashMap();
    private final Int2ObjectMap<AbstractWizardStepEx> myIndex2Step = new Int2ObjectOpenHashMap();

    public AbstractWizardEx(@NlsContexts.DialogTitle String title2, @Nullable Project project, List<? extends AbstractWizardStepEx> steps2) {
        super(title2, project);
        this.myTitle = title2;
        int index2 = 0;
        for (AbstractWizardStepEx abstractWizardStepEx : steps2) {
            this.myStepId2Index.put(abstractWizardStepEx.getStepId(), index2);
            this.myIndex2Step.put(index2, (Object)abstractWizardStepEx);
            this.addStep((Step)abstractWizardStepEx);
            abstractWizardStepEx.addStepListener(new AbstractWizardStepEx.Listener(){

                public void stateChanged() {
                    AbstractWizardEx.this.updateButtons();
                }

                public void doNextAction() {
                    if (AbstractWizardEx.this.getNextButton().isEnabled()) {
                        AbstractWizardEx.this.doNextAction();
                    }
                }
            });
            ++index2;
        }
        this.init();
    }

    protected void doPreviousAction() {
        AbstractWizardStepEx currentStep = (AbstractWizardStepEx)this.mySteps.get(this.myCurrentStep);
        try {
            currentStep._commitPrev();
        }
        catch (CommitStepCancelledException e) {
            return;
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return;
        }
        this.myCurrentStep = this.getPreviousStep(this.myCurrentStep);
        this.updateStep(JBCardLayout.SwipeDirection.BACKWARD);
    }

    protected void doNextAction() {
        AbstractWizardStepEx currentStep = (AbstractWizardStepEx)this.mySteps.get(this.myCurrentStep);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepCancelledException e) {
            return;
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return;
        }
        if (this.isLastStep()) {
            this.doOKAction();
            return;
        }
        this.myCurrentStep = this.getNextStep(this.myCurrentStep);
        this.updateStep(JBCardLayout.SwipeDirection.FORWARD);
    }

    protected int getNextStep(int step2) {
        AbstractWizardStepEx stepObject = (AbstractWizardStepEx)this.myIndex2Step.get(step2);
        Object nextStepId = stepObject.getNextStepId();
        return this.myStepId2Index.getInt(nextStepId);
    }

    protected int getPreviousStep(int step2) {
        AbstractWizardStepEx stepObject = (AbstractWizardStepEx)this.myIndex2Step.get(step2);
        Object previousStepId = stepObject.getPreviousStepId();
        return this.myStepId2Index.getInt(previousStepId);
    }

    protected String getHelpID() {
        return ((AbstractWizardStepEx)this.getCurrentStepObject()).getHelpId();
    }

    protected void updateStep() {
        super.updateStep();
        this.updateButtons();
        AbstractWizardStepEx step2 = (AbstractWizardStepEx)this.getCurrentStepObject();
        String stepTitle = step2.getTitle();
        this.setTitle((String)(stepTitle != null ? this.myTitle + ": " + stepTitle : this.myTitle));
        JComponent toFocus = step2.getPreferredFocusedComponent();
        if (toFocus != null) {
            IdeFocusManager.findInstanceByComponent((Component)this.getWindow()).requestFocus((Component)toFocus, true);
        }
    }

    protected void updateButtons() {
        super.updateButtons();
        this.getPreviousButton().setEnabled(((AbstractWizardStepEx)this.getCurrentStepObject()).getPreviousStepId() != null);
        this.getNextButton().setEnabled(((AbstractWizardStepEx)this.getCurrentStepObject()).isComplete() && !this.isLastStep() || this.isLastStep() && this.canFinish());
    }

    protected boolean canGoNext() {
        return ((AbstractWizardStepEx)this.getCurrentStepObject()).isComplete();
    }

    protected boolean isLastStep() {
        return ((AbstractWizardStepEx)this.myIndex2Step.get(this.myCurrentStep)).getNextStepId() == null;
    }

    protected boolean canFinish() {
        for (AbstractWizardStepEx step2 : this.mySteps) {
            if (step2.isComplete()) continue;
            return false;
        }
        return true;
    }

    protected void dispose() {
        super.dispose();
        for (AbstractWizardStepEx step2 : this.mySteps) {
            Disposer.dispose((Disposable)step2);
        }
    }
}

